/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.client.render.blockentity;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Calendar;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.colossalchests.GeneralConfig;
import org.cyclops.colossalchests.block.ChestMaterial;
import org.cyclops.colossalchests.blockentity.BlockEntityColossalChest;
import org.cyclops.colossalchests.client.render.blockentity.RenderTileEntityChestBase;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class RenderTileEntityColossalChest
extends RenderTileEntityChestBase<BlockEntityColossalChest> {
    public static final Map<ChestMaterial, ResourceLocation> TEXTURES_CHEST = Maps.newHashMap();
    public static final Map<ChestMaterial, ResourceLocation> TEXTURES_INTERFACE = Maps.newHashMap();

    public RenderTileEntityColossalChest(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    protected void handleRotation(BlockEntityColossalChest tile, PoseStack matrixStack) {
        if (tile.isStructureComplete()) {
            Vec3 renderOffset = tile.getRenderOffset();
            matrixStack.m_85837_(-renderOffset.f_82479_, -renderOffset.f_82480_, -renderOffset.f_82481_);
        }
        super.handleRotation(tile, matrixStack);
        matrixStack.m_252880_(0.0f, (float)tile.getSizeSingular() * 0.0625f, 0.0f);
        float size = (float)tile.getSizeSingular() * 1.125f;
        matrixStack.m_85841_(size, size, size);
    }

    public void render(BlockEntityColossalChest tile, float partialTicks, PoseStack matrixStack, MultiBufferSource renderTypeBuffer, int combinedLightIn, int combinedOverlayIn) {
        if (tile.isStructureComplete()) {
            matrixStack.m_85836_();
            super.m_6922_(tile, partialTicks, matrixStack, renderTypeBuffer, combinedLightIn, combinedOverlayIn);
            if (tile.isStructureComplete() && tile.m_6683_(0.0f) == 0.0f && (GeneralConfig.alwaysShowInterfaceOverlay || Minecraft.m_91087_().f_91074_.m_6047_())) {
                matrixStack.m_85836_();
                Material materialInterface = this.getMaterialInterface(tile);
                VertexConsumer buffer = materialInterface.m_119194_(renderTypeBuffer, RenderType::m_110497_);
                for (Vec3i interfaceLocation : tile.getInterfaceLocations()) {
                    float translateX = interfaceLocation.m_123341_() - tile.m_58899_().m_123341_();
                    float translateY = interfaceLocation.m_123342_() - tile.m_58899_().m_123342_();
                    float translateZ = interfaceLocation.m_123343_() - tile.m_58899_().m_123343_();
                    matrixStack.m_252880_(translateX, translateY, translateZ);
                    this.renderInterface(matrixStack, buffer, materialInterface.m_119204_(), interfaceLocation.equals((Object)tile.m_58899_()), combinedLightIn);
                    matrixStack.m_252880_(-translateX, -translateY, -translateZ);
                }
                matrixStack.m_85849_();
            }
            matrixStack.m_85849_();
        }
    }

    public boolean shouldRenderOffScreen(BlockEntityColossalChest tile) {
        return true;
    }

    @Override
    protected Direction getDirection(BlockEntityColossalChest tile) {
        return tile.getRotation().m_122424_();
    }

    @Override
    protected Material getMaterial(BlockEntityColossalChest tile) {
        return new Material(Sheets.f_110740_, TEXTURES_CHEST.get(tile.getMaterial()));
    }

    protected Material getMaterialInterface(BlockEntityColossalChest tile) {
        return new Material(InventoryMenu.f_39692_, TEXTURES_INTERFACE.get(tile.getMaterial()));
    }

    protected void setMatrixOrientation(PoseStack matrixStack, Direction direction) {
        float translateX = -1.0f - (float)direction.m_122429_();
        float translateY = direction.m_122430_();
        float translateZ = direction.m_122431_();
        if (direction == Direction.NORTH) {
            translateZ += 1.0f;
            translateX += 2.0f;
            translateY -= 1.0f;
        } else if (direction == Direction.EAST) {
            translateX += 3.0f;
            translateY -= 1.0f;
            translateZ += 1.0f;
        } else if (direction == Direction.WEST) {
            translateY -= 1.0f;
        } else if (direction == Direction.SOUTH) {
            translateX += 1.0f;
            translateY -= 1.0f;
        } else if (direction == Direction.UP) {
            translateX += 1.0f;
            translateZ += 1.0f;
        } else if (direction == Direction.DOWN) {
            translateX += 1.0f;
        }
        matrixStack.m_252880_(translateX * 16.0f, translateY * 16.0f, translateZ * 16.0f);
        int rotationY = 0;
        int rotationX = 0;
        if (direction == Direction.SOUTH) {
            rotationY = 0;
        } else if (direction == Direction.NORTH) {
            rotationY = 180;
        } else if (direction == Direction.EAST) {
            rotationY = 90;
        } else if (direction == Direction.WEST) {
            rotationY = -90;
        } else if (direction == Direction.UP) {
            rotationX = -90;
        } else if (direction == Direction.DOWN) {
            rotationX = 90;
        }
        matrixStack.m_252781_(Axis.f_252436_.m_252977_((float)rotationY));
        matrixStack.m_252781_(Axis.f_252529_.m_252977_((float)rotationX));
    }

    protected void renderInterface(PoseStack matrixStack, VertexConsumer buffer, TextureAtlasSprite sprite, boolean core, int combinedLightIn) {
        for (Direction side : Direction.values()) {
            matrixStack.m_85836_();
            float scale = 0.063f;
            matrixStack.m_85841_(scale, scale, scale);
            matrixStack.m_85841_(1.0f, -1.0f, 1.0f);
            this.setMatrixOrientation(matrixStack, side);
            float indent = -0.2f;
            if (side == Direction.UP) {
                indent = -15.8f;
            }
            if (side == Direction.DOWN) {
                indent *= 2.0f;
            }
            int alpha = 255;
            float posMin = core ? 5.0f : 6.0f;
            float posMax = 16.0f - posMin;
            float uvScale = posMin / 16.0f;
            float uMin = (sprite.m_118410_() - sprite.m_118409_()) * uvScale + sprite.m_118409_();
            float uMax = (sprite.m_118410_() - sprite.m_118409_()) * (1.0f - uvScale) + sprite.m_118409_();
            float vMin = (sprite.m_118412_() - sprite.m_118411_()) * uvScale + sprite.m_118411_();
            float vMax = (sprite.m_118412_() - sprite.m_118411_()) * (1.0f - uvScale) + sprite.m_118411_();
            Matrix4f matrix = matrixStack.m_85850_().m_252922_();
            buffer.m_252986_(matrix, posMax, posMax, indent).m_6122_(255, 255, 255, alpha).m_7421_(uMin, vMax).m_85969_(combinedLightIn).m_5752_();
            buffer.m_252986_(matrix, posMax, posMin, indent).m_6122_(255, 255, 255, alpha).m_7421_(uMin, vMin).m_85969_(combinedLightIn).m_5752_();
            buffer.m_252986_(matrix, posMin, posMin, indent).m_6122_(255, 255, 255, alpha).m_7421_(uMax, vMin).m_85969_(combinedLightIn).m_5752_();
            buffer.m_252986_(matrix, posMin, posMax, indent).m_6122_(255, 255, 255, alpha).m_7421_(uMax, vMax).m_85969_(combinedLightIn).m_5752_();
            matrixStack.m_85849_();
        }
    }

    static {
        Calendar calendar = Calendar.getInstance();
        boolean christmas = calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26;
        TEXTURES_CHEST.put(ChestMaterial.WOOD, new ResourceLocation("entity/chest/" + (christmas ? "christmas" : "normal")));
        TEXTURES_CHEST.put(ChestMaterial.COPPER, new ResourceLocation("colossalchests", "models/chest_copper"));
        TEXTURES_CHEST.put(ChestMaterial.IRON, new ResourceLocation("colossalchests", "models/chest_iron"));
        TEXTURES_CHEST.put(ChestMaterial.SILVER, new ResourceLocation("colossalchests", "models/chest_silver"));
        TEXTURES_CHEST.put(ChestMaterial.GOLD, new ResourceLocation("colossalchests", "models/chest_gold"));
        TEXTURES_CHEST.put(ChestMaterial.DIAMOND, new ResourceLocation("colossalchests", "models/chest_diamond"));
        TEXTURES_CHEST.put(ChestMaterial.OBSIDIAN, new ResourceLocation("colossalchests", "models/chest_obsidian"));
        TEXTURES_INTERFACE.put(ChestMaterial.WOOD, new ResourceLocation("colossalchests", "blocks/interface_wood"));
        TEXTURES_INTERFACE.put(ChestMaterial.COPPER, new ResourceLocation("colossalchests", "blocks/interface_copper"));
        TEXTURES_INTERFACE.put(ChestMaterial.IRON, new ResourceLocation("colossalchests", "blocks/interface_iron"));
        TEXTURES_INTERFACE.put(ChestMaterial.SILVER, new ResourceLocation("colossalchests", "blocks/interface_silver"));
        TEXTURES_INTERFACE.put(ChestMaterial.GOLD, new ResourceLocation("colossalchests", "blocks/interface_gold"));
        TEXTURES_INTERFACE.put(ChestMaterial.DIAMOND, new ResourceLocation("colossalchests", "blocks/interface_diamond"));
        TEXTURES_INTERFACE.put(ChestMaterial.OBSIDIAN, new ResourceLocation("colossalchests", "blocks/interface_obsidian"));
    }
}

