/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.logic.editors;

import mcjty.lib.gui.Window;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.rftoolsbase.api.control.parameters.ParameterType;
import mcjty.rftoolsbase.api.control.parameters.ParameterValue;
import mcjty.rftoolscontrol.modules.processor.logic.editors.AbstractParameterEditor;
import mcjty.rftoolscontrol.modules.processor.logic.editors.ParameterEditorCallback;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;

public class StringEditor
extends AbstractParameterEditor {
    private TextField field;

    @Override
    public void build(Minecraft mc, Screen gui, Panel panel, ParameterEditorCallback callback) {
        Panel constantPanel = Widgets.horizontal();
        this.field = new TextField().event(newText -> callback.valueChanged(this.readValue())).addTextEnterEvent(newText -> this.closeWindow());
        constantPanel.children(new Widget[]{this.field});
        this.createEditorPanel(mc, gui, panel, callback, constantPanel, ParameterType.PAR_STRING);
    }

    @Override
    public void initialFocusInternal(Window window) {
        window.setTextFocus((Widget)this.field);
    }

    @Override
    protected ParameterValue readConstantValue() {
        return ParameterValue.constant((Object)this.field.getText());
    }

    @Override
    protected void writeConstantValue(ParameterValue value) {
        if (value == null || value.getValue() == null) {
            this.field.text("");
        } else {
            try {
                this.field.text(value.getValue().toString());
            }
            catch (Exception e) {
                this.field.text("");
            }
        }
    }
}

