/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.multitank.blocks;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.blockcommands.ListCommand;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.rftoolscontrol.modules.multitank.MultiTankModule;
import mcjty.rftoolscontrol.modules.multitank.util.MultiTankFluidProperties;
import mcjty.rftoolscontrol.modules.multitank.util.MultiTankHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;

public class MultiTankTileEntity
extends GenericTileEntity {
    public static final int TANKS = 4;
    public static final int MAXCAPACITY = 10000;
    private final MultiTankFluidProperties[] properties = new MultiTankFluidProperties[4];
    @Cap(type=CapType.FLUIDS)
    private final LazyOptional<MultiTankHandler> fluidHandler = LazyOptional.of(this::createFluidHandler);
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<MenuProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Multi tank").containerSupplier(DefaultContainerProvider.empty(MultiTankModule.MULTITANK_CONTAINER, (GenericTileEntity)this)).setupSync((GenericTileEntity)this));
    @ServerCommand(type=FluidStack.class)
    public static final ListCommand<?, ?> CMD_GETFLUIDS = ListCommand.create((String)"rftoolscontrol.tank.getFluids", (te, player, params) -> {
        ArrayList<FluidStack> result = new ArrayList<FluidStack>(4);
        for (MultiTankFluidProperties property : te.properties) {
            result.add(property.getContents());
        }
        return result;
    }, (te, player, params, list) -> {
        for (int i = 0; i < 4; ++i) {
            te.properties[i].set((FluidStack)list.get(i));
        }
    });

    public MultiTankTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)MultiTankModule.TYPE_MULTITANK.get(), pos, state);
        for (int i = 0; i < 4; ++i) {
            this.properties[i] = new MultiTankFluidProperties(this, FluidStack.EMPTY, 10000);
        }
    }

    public MultiTankFluidProperties[] getProperties() {
        return this.properties;
    }

    protected void loadInfo(CompoundTag tagCompound) {
        super.loadInfo(tagCompound);
        CompoundTag info = tagCompound.m_128469_("Info");
        for (int i = 0; i < 4; ++i) {
            this.properties[i] = new MultiTankFluidProperties(this, FluidStack.loadFluidStackFromNBT((CompoundTag)info.m_128469_("f" + i)), 10000);
        }
    }

    protected void saveInfo(CompoundTag tagCompound) {
        super.saveInfo(tagCompound);
        CompoundTag info = this.getOrCreateInfo(tagCompound);
        for (int i = 0; i < 4; ++i) {
            FluidStack contents = this.properties[i].getContents();
            if (contents.isEmpty()) continue;
            CompoundTag tag = new CompoundTag();
            contents.writeToNBT(tag);
            info.m_128365_("f" + i, (Tag)tag);
        }
    }

    @Nonnull
    private MultiTankHandler createFluidHandler() {
        return new MultiTankHandler(this);
    }
}

