/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.device;

import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import sonar.fluxnetworks.common.device.FluxConnectorHandler;
import sonar.fluxnetworks.common.device.SideTransfer;

public class FluxPlugHandler
extends FluxConnectorHandler {
    private long mReceived;
    private long mRemoved;

    @Override
    public void onCycleEnd() {
        this.mChange = this.mReceived;
        this.mReceived = 0L;
        this.mRemoved = 0L;
    }

    @Override
    public long removeFromBuffer(long energy) {
        long op = Math.min(Math.min(energy, this.mBuffer), this.getLimit() - this.mRemoved);
        assert (op >= 0L);
        this.mBuffer -= op;
        this.mRemoved += op;
        return op;
    }

    public long receive(long maxReceive, @Nonnull Direction side, boolean simulate, long bufferLimiter) {
        long op = Math.min(Math.min(this.getLimit(), bufferLimiter - this.mBuffer) - this.mBuffer, maxReceive);
        if (op > 0L) {
            if (!simulate) {
                this.mBuffer += op;
                this.mReceived += op;
                SideTransfer transfer = this.mTransfers[side.m_122411_()];
                if (transfer != null) {
                    transfer.receive(op);
                }
            }
            return op;
        }
        return 0L;
    }
}

