/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.damageTypes;

import com.simibubi.create.Create;
import com.simibubi.create.foundation.utility.WorldAttached;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageEffects;
import net.minecraft.world.damagesource.DamageScaling;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DeathMessageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;

public class DamageTypeData {
    private static final List<DamageTypeData> all = new ArrayList<DamageTypeData>();
    public final ResourceKey<DamageType> key;
    public final ResourceLocation id;
    public final DamageType type;
    public final Collection<TagKey<DamageType>> tags;
    private Holder<DamageType> holder;
    private final WorldAttached<DamageSource> staticSources;

    protected DamageTypeData(ResourceKey<DamageType> key, DamageType type, Collection<TagKey<DamageType>> tags) {
        this.key = key;
        this.id = key.m_135782_();
        this.type = type;
        this.tags = tags;
        this.staticSources = new WorldAttached<DamageSource>(level -> new DamageSource(this.getHolder((LevelAccessor)level)));
    }

    public DamageSource source(LevelAccessor level) {
        return this.staticSources.get(level);
    }

    public DamageSource source(LevelAccessor level, @Nullable Entity entity) {
        return new DamageSource(this.getHolder(level), entity);
    }

    public DamageSource source(LevelAccessor level, @Nullable Entity cause, @Nullable Entity direct) {
        return new DamageSource(this.getHolder(level), cause, direct);
    }

    private Holder<DamageType> getHolder(LevelAccessor level) {
        if (this.holder == null) {
            Registry registry = level.m_9598_().m_175515_(Registries.f_268580_);
            this.holder = registry.m_246971_(this.key);
        }
        return this.holder;
    }

    public boolean is(@Nullable DamageSource source) {
        return source != null && this.is(source.m_269415_());
    }

    public boolean is(DamageType type) {
        return this.type.equals((Object)type);
    }

    public void register(BootstapContext<DamageType> ctx) {
        ctx.m_255272_(this.key, (Object)this.type);
    }

    public static Stream<DamageTypeData> allInNamespace(String namespace) {
        return all.stream().filter(data -> data.id.m_135827_().equals(namespace));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String msgId;
        private ResourceLocation location;
        private float exhaustion = 0.0f;
        private DamageScaling scaling = DamageScaling.WHEN_CAUSED_BY_LIVING_NON_PLAYER;
        private DamageEffects effects = DamageEffects.HURT;
        private DeathMessageType deathMessageType = DeathMessageType.DEFAULT;
        private final List<TagKey<DamageType>> tags = new ArrayList<TagKey<DamageType>>();

        public Builder location(ResourceLocation location) {
            this.location = location;
            return this;
        }

        public Builder location(String path) {
            return this.location(Create.asResource(path));
        }

        public Builder simpleId(ResourceLocation location) {
            this.location(location);
            return this.msgId(location.m_135827_() + "." + location.m_135815_());
        }

        public Builder simpleId(String path) {
            return this.simpleId(Create.asResource(path));
        }

        public Builder msgId(String msgId) {
            this.msgId = msgId;
            return this;
        }

        public Builder exhaustion(float exhaustion) {
            this.exhaustion = exhaustion;
            return this;
        }

        public Builder scaling(DamageScaling scaling) {
            this.scaling = scaling;
            return this;
        }

        public Builder effects(DamageEffects effects) {
            this.effects = effects;
            return this;
        }

        public Builder deathMessageType(DeathMessageType type) {
            this.deathMessageType = type;
            return this;
        }

        @SafeVarargs
        public final Builder tag(TagKey<DamageType> ... tags) {
            Collections.addAll(this.tags, tags);
            return this;
        }

        public DamageTypeData build() {
            if (this.location == null) {
                throw new IllegalArgumentException("location is required");
            }
            if (this.msgId == null) {
                throw new IllegalArgumentException("msgId is required");
            }
            DamageTypeData data = new DamageTypeData((ResourceKey<DamageType>)ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)this.location), new DamageType(this.msgId, this.scaling, this.exhaustion, this.effects, this.deathMessageType), this.tags);
            all.add(data);
            return data;
        }
    }
}

