/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.setup;

import com.mojang.serialization.Codec;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import net.silentchaos512.gear.loot.condition.HasTraitCondition;
import net.silentchaos512.gear.loot.function.SelectGearTierLootFunction;
import net.silentchaos512.gear.loot.function.SetPartsFunction;
import net.silentchaos512.gear.loot.modifier.BonusDropsTraitLootModifier;
import net.silentchaos512.gear.loot.modifier.MagmaticTraitLootModifier;

public final class SgLoot {
    public static final DeferredRegister<LootItemConditionType> LOOT_CONDITIONS = DeferredRegister.create((ResourceKey)Registries.f_256976_, (String)"silentgear");
    public static final DeferredRegister<LootItemFunctionType> LOOT_FUNCTIONS = DeferredRegister.create((ResourceKey)Registries.f_257015_, (String)"silentgear");
    public static final DeferredRegister<Codec<? extends IGlobalLootModifier>> LOOT_MODIFIERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"silentgear");
    public static final RegistryObject<LootItemConditionType> HAS_TRAIT = SgLoot.registerCondition("has_trait", () -> new LootItemConditionType((Serializer)HasTraitCondition.SERIALIZER));
    public static final RegistryObject<LootItemFunctionType> SELECT_TIER = SgLoot.registerFunction("select_tier", () -> new LootItemFunctionType((Serializer)SelectGearTierLootFunction.SERIALIZER));
    public static final RegistryObject<LootItemFunctionType> SET_PARTS = SgLoot.registerFunction("set_parts", () -> new LootItemFunctionType((Serializer)SetPartsFunction.SERIALIZER));
    public static final RegistryObject<Codec<BonusDropsTraitLootModifier>> BONUS_DROPS_TRAIT = SgLoot.registerModifier("bonus_drops_trait", BonusDropsTraitLootModifier.CODEC);
    public static final RegistryObject<Codec<MagmaticTraitLootModifier>> MAGMATIC_SMELTING = SgLoot.registerModifier("magmatic_smelting", MagmaticTraitLootModifier.CODEC);

    private SgLoot() {
    }

    private static <T extends LootItemConditionType> RegistryObject<T> registerCondition(String name, Supplier<T> condition) {
        return LOOT_CONDITIONS.register(name, condition);
    }

    private static <T extends LootItemFunctionType> RegistryObject<T> registerFunction(String name, Supplier<T> condition) {
        return LOOT_FUNCTIONS.register(name, condition);
    }

    private static <T extends IGlobalLootModifier> RegistryObject<Codec<T>> registerModifier(String name, Supplier<Codec<T>> codec) {
        return LOOT_MODIFIERS.register(name, codec);
    }
}

