/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.gear.material.MaterialManager;
import net.silentchaos512.gear.gear.material.MaterialSerializers;
import net.silentchaos512.gear.network.LoginPacket;
import net.silentchaos512.gear.network.Network;

public class SyncMaterialsPacket
extends LoginPacket {
    private final List<IMaterial> materials;

    public SyncMaterialsPacket() {
        this(MaterialManager.getValues());
    }

    public SyncMaterialsPacket(Collection<IMaterial> materials) {
        this.materials = new ArrayList<IMaterial>(materials);
    }

    public static SyncMaterialsPacket fromBytes(FriendlyByteBuf buf) {
        SilentGear.LOGGER.debug("Materials packet: {} bytes", (Object)buf.readableBytes());
        SyncMaterialsPacket packet = new SyncMaterialsPacket(Collections.emptyList());
        Network.verifyNetworkVersion(buf);
        int count = buf.m_130242_();
        for (int i = 0; i < count; ++i) {
            packet.materials.add(MaterialSerializers.read(buf));
        }
        return packet;
    }

    public void toBytes(FriendlyByteBuf buf) {
        Network.writeModVersionInfoToNetwork(buf);
        buf.m_130130_(this.materials.size());
        this.materials.forEach(mat -> MaterialSerializers.write(mat, buf));
    }

    public List<IMaterial> getMaterials() {
        return Collections.unmodifiableList(this.materials);
    }
}

