/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.silentchaos512.gear.item.ICycleItem;

public class KeyPressOnItemPacket {
    private final Type type;
    private final int slot;

    public KeyPressOnItemPacket(Type type, int slot) {
        this.type = type;
        this.slot = slot;
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        Slot inventorySlot;
        ItemStack stack;
        ServerPlayer player = context.get().getSender();
        if (player != null && player.f_36096_ != null && this.slot >= 0 && this.slot < player.f_36096_.f_38839_.size() && !(stack = (inventorySlot = player.f_36096_.m_38853_(this.slot)).m_7993_()).m_41619_()) {
            switch (this.type) {
                case CYCLE_BACK: 
                case CYCLE_NEXT: {
                    if (!(stack.m_41720_() instanceof ICycleItem)) break;
                    ((ICycleItem)stack.m_41720_()).onCycleKeyPress(stack, this.type);
                    player.f_36096_.m_6199_(inventorySlot.f_40218_);
                    break;
                }
            }
        }
        context.get().setPacketHandled(true);
    }

    public static KeyPressOnItemPacket decode(FriendlyByteBuf buffer) {
        Type type = (Type)buffer.m_130066_(Type.class);
        int slot = buffer.m_130242_();
        return new KeyPressOnItemPacket(type, slot);
    }

    public static void encode(KeyPressOnItemPacket msg, FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)msg.type);
        buffer.m_130130_(msg.slot);
    }

    public static enum Type {
        CYCLE_BACK(-1),
        CYCLE_NEXT(1),
        OPEN_ITEM(0);

        public final int direction;

        private Type(int direction) {
            this.direction = direction;
        }
    }
}

