/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.loot.modifier;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.util.ModResourceLocation;
import org.jetbrains.annotations.NotNull;

public class LootTableInjectorLootModifier
extends LootModifier {
    private static final Map<ResourceLocation, Float> SEED_CHANCE = ImmutableMap.builder().put((Object)BuiltInLootTables.f_78759_, (Object)Float.valueOf(0.33333334f)).put((Object)BuiltInLootTables.f_78697_, (Object)Float.valueOf(0.6666667f)).put((Object)BuiltInLootTables.f_78692_, (Object)Float.valueOf(0.33333334f)).put((Object)BuiltInLootTables.f_78741_, (Object)Float.valueOf(0.6666667f)).put((Object)BuiltInLootTables.f_78686_, (Object)Float.valueOf(0.33333334f)).put((Object)BuiltInLootTables.f_78695_, (Object)Float.valueOf(0.33333334f)).put((Object)BuiltInLootTables.f_78763_, (Object)Float.valueOf(0.6666667f)).put((Object)BuiltInLootTables.f_78762_, (Object)Float.valueOf(0.6f)).build();
    public static final Supplier<Codec<LootTableInjectorLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> LootTableInjectorLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, LootTableInjectorLootModifier::new)));

    public LootTableInjectorLootModifier(LootItemCondition[] conditions) {
        super(conditions);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ObjectArrayList ret = new ObjectArrayList(generatedLoot);
        ResourceLocation baseTableId = context.getQueriedLootTableId();
        ModResourceLocation injectTableId = LootTableInjectorLootModifier.getInjectorTableId(baseTableId);
        LootTable lootTable = context.m_78952_().m_7654_().m_278653_().m_278676_((ResourceLocation)injectTableId);
        lootTable.m_79148_(context, arg_0 -> ((ObjectArrayList)ret).add(arg_0));
        return ret;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }

    @NotNull
    public static ModResourceLocation getInjectorTableId(ResourceLocation baseTableId) {
        return SilentGear.getId("inject/" + baseTableId.m_135827_() + "/" + baseTableId.m_135815_());
    }
}

