/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.part;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.part.IGearPart;
import net.silentchaos512.gear.api.part.IPartSerializer;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.gear.part.CompoundPart;
import net.silentchaos512.gear.gear.part.PartManager;
import net.silentchaos512.gear.gear.part.UpgradePart;

public final class PartSerializers {
    public static final CompoundPart.Serializer COMPOUND_PART = new CompoundPart.Serializer((ResourceLocation)SilentGear.getId("compound_part"), CompoundPart::new);
    public static final UpgradePart.Serializer UPGRADE_PART = new UpgradePart.Serializer((ResourceLocation)SilentGear.getId("misc_upgrade"), UpgradePart::new);
    private static final Map<ResourceLocation, IPartSerializer<?>> REGISTRY = new HashMap();

    private PartSerializers() {
    }

    public static <S extends IPartSerializer<T>, T extends IGearPart> S register(S serializer) {
        if (REGISTRY.containsKey(serializer.getName())) {
            throw new IllegalArgumentException("Duplicate part serializer " + serializer.getName());
        }
        SilentGear.LOGGER.info(PartManager.MARKER, "Registered part serializer '{}'", (Object)serializer.getName());
        REGISTRY.put(serializer.getName(), serializer);
        return serializer;
    }

    public static IGearPart deserialize(ResourceLocation id, JsonObject json) {
        String typeStr = GsonHelper.m_13906_((JsonObject)json, (String)"type");
        ResourceLocation type = SilentGear.getIdWithDefaultNamespace(typeStr);
        PartSerializers.log(() -> "deserialize " + id + " (type " + type + ")");
        IPartSerializer<?> serializer = REGISTRY.get(type);
        if (serializer == null) {
            throw new JsonSyntaxException("Invalid or unsupported part type " + type);
        }
        return serializer.read(id, json);
    }

    public static IGearPart read(FriendlyByteBuf buffer) {
        ResourceLocation id = buffer.m_130281_();
        ResourceLocation type = buffer.m_130281_();
        PartSerializers.log(() -> "read " + id + " (type " + type + ")");
        IPartSerializer<?> serializer = REGISTRY.get(type);
        if (serializer == null) {
            throw new IllegalArgumentException("Unknown part serializer " + type);
        }
        return serializer.read(id, buffer);
    }

    public static <T extends IGearPart> void write(T part, FriendlyByteBuf buffer) {
        ResourceLocation id = part.getId();
        ResourceLocation type = part.getSerializer().getName();
        PartSerializers.log(() -> "write " + id + " (type " + type + ")");
        buffer.m_130085_(id);
        buffer.m_130085_(type);
        IPartSerializer<?> serializer = part.getSerializer();
        serializer.write(buffer, part);
    }

    private static void log(Supplier<?> msg) {
        if (((Boolean)Config.Common.extraPartAndTraitLogging.get()).booleanValue()) {
            SilentGear.LOGGER.info(PartManager.MARKER, msg.get());
        }
    }

    static {
        PartSerializers.register(COMPOUND_PART);
        PartSerializers.register(UPGRADE_PART);
    }
}

