/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.data.trait;

import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.data.DataGenerator;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.Tags;
import net.silentchaos512.gear.api.data.trait.AttributeTraitBuilder;
import net.silentchaos512.gear.api.data.trait.BlockFillerTraitBuilder;
import net.silentchaos512.gear.api.data.trait.BlockMiningSpeedTraitBuilder;
import net.silentchaos512.gear.api.data.trait.BlockPlacerTraitBuilder;
import net.silentchaos512.gear.api.data.trait.DurabilityTraitBuilder;
import net.silentchaos512.gear.api.data.trait.EnchantmentTraitBuilder;
import net.silentchaos512.gear.api.data.trait.StatModifierTraitBuilder;
import net.silentchaos512.gear.api.data.trait.SynergyTraitBuilder;
import net.silentchaos512.gear.api.data.trait.TargetEffectTraitBuilder;
import net.silentchaos512.gear.api.data.trait.TraitBuilder;
import net.silentchaos512.gear.api.data.trait.TraitsProviderBase;
import net.silentchaos512.gear.api.data.trait.WielderEffectTraitBuilder;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.gear.trait.StellarTrait;
import net.silentchaos512.gear.setup.SgBlocks;
import net.silentchaos512.gear.setup.SgTags;
import net.silentchaos512.gear.util.Const;

public class TraitsProvider
extends TraitsProviderBase {
    public TraitsProvider(DataGenerator generator) {
        super(generator, "silentgear");
    }

    @Override
    public Collection<TraitBuilder> getTraits() {
        ArrayList<TraitBuilder> ret = new ArrayList<TraitBuilder>();
        ret.add(TraitBuilder.simple(Const.Traits.ANCIENT, 5).withGearTypeCondition(GearType.TOOL, new GearType[0]));
        ret.add(TraitBuilder.simple(Const.Traits.BOUNCE, 1).withGearTypeCondition(GearType.ARMOR, new GearType[0]));
        ret.add(TraitBuilder.simple(Const.Traits.BRILLIANT, 1));
        ret.add(TraitBuilder.simple(Const.Traits.CONFETTI, 5).withGearTypeCondition(GearType.WEAPON, new GearType[0]));
        ret.add(TraitBuilder.simple(Const.Traits.FIREPROOF, 1).extraWikiLines("  - The item cannot be destroyed by fire or lava"));
        ret.add(TraitBuilder.simple(Const.Traits.FLAMMABLE, 1));
        ret.add(TraitBuilder.simple(Const.Traits.INDESTRUCTIBLE, 1).extraWikiLines("  - The damage (durability lost) of the item will remain the same as when the trait was added", "  - The item can still be repaired if desired"));
        ret.add(TraitBuilder.simple(Const.Traits.JABBERWOCKY, 1).withGearTypeCondition(GearType.HARVEST_TOOL, new GearType[0]).extraWikiLines("Something may happen if you mine certain blocks with this"));
        ret.add(TraitBuilder.simple(Const.Traits.LUSTROUS, 5).withGearTypeCondition(GearType.HARVEST_TOOL, new GearType[0]));
        ret.add(TraitBuilder.simple(Const.Traits.MAGMATIC, 1).withGearTypeCondition(GearType.HARVEST_TOOL, new GearType[0]).extraWikiLines("Smelted drops are not affected by fortune to prevent item duplication"));
        ret.add(TraitBuilder.simple(Const.Traits.MAGNETIC, 5).extraWikiLines("Higher levels increase range"));
        ret.add(TraitBuilder.simple(Const.Traits.MULTI_BREAK, 5).extraWikiLines("  - This trait has never been coded ~~and has almost achieved meme status~~", "  - Intended effect: mine multiple blocks like vein miner"));
        ret.add(TraitBuilder.simple(Const.Traits.RED_CARD, 1));
        ret.add(TraitBuilder.simple(Const.Traits.SNOW_WALKER, 1).extraWikiLines("Allows the player to walk on powder snow without sinking. This will work on any armor or curio."));
        ret.add(TraitBuilder.simple(Const.Traits.SPOON, 1).withGearTypeCondition(GearType.PICKAXE, new GearType[0]));
        ret.add(TraitBuilder.simple(Const.Traits.TURTLE, 1).withGearTypeCondition(GearType.HELMET, GearType.CURIO));
        ret.add(TraitBuilder.simple(Const.Traits.VOID_WARD, 1).withGearTypeCondition(GearType.ARMOR, new GearType[0]).extraWikiLines("When void damage is taken, the player is launched upward and given a levitation and slow falling effect"));
        ret.add(TraitBuilder.simple(Const.Traits.WIDEN, 3).withGearTypeCondition(GearType.HARVEST_TOOL, new GearType[0]).extraWikiLines("  - Adds the trait level to the effect radius", "  - Level 1 = 5x5, 2 = 7x7, 3 = 9x9"));
        ret.add(new SynergyTraitBuilder(Const.Traits.CRUDE, 5, -0.04f).cancelsWith(Const.Traits.RUSTIC).cancelsWith(Const.Traits.SYNERGISTIC));
        ret.add(new SynergyTraitBuilder(Const.Traits.RUSTIC, 5, 0.05f).setRange(0.749f, 1.001f).cancelsWith(Const.Traits.SYNERGISTIC));
        ret.add(new SynergyTraitBuilder(Const.Traits.SYNERGISTIC, 5, 0.04f).setRangeMin(1.0f).cancelsWith(Const.Traits.CRUDE));
        ret.add(new DurabilityTraitBuilder(Const.Traits.BENDING, 5, -1, 0.075f).cancelsWith(Const.Traits.FLEXIBLE));
        ret.add(new DurabilityTraitBuilder(Const.Traits.BRITTLE, 5, 1, 0.1f).cancelsWith(Const.Traits.MALLEABLE));
        ret.add(new DurabilityTraitBuilder(Const.Traits.FLEXIBLE, 5, -1, 0.075f).cancelsWith(Const.Traits.BENDING));
        ret.add(new DurabilityTraitBuilder(Const.Traits.MALLEABLE, 5, -1, 0.1f).cancelsWith(Const.Traits.BRITTLE));
        ret.add(new DurabilityTraitBuilder(Const.Traits.STURDY, 5, -1, 0.175f).cancelsWith(Const.Traits.BRITTLE));
        ret.add(TraitsProvider.selfRepairTrait(Const.Traits.RENEW, 5, 0.018f, 1));
        ret.add(new AttributeTraitBuilder(Const.Traits.BASTION, 5).addModifierAnySlot(GearType.ALL, Attributes.f_22284_, AttributeModifier.Operation.ADDITION, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f).withGearTypeCondition(GearType.ARMOR, GearType.CURIO));
        ret.add(new AttributeTraitBuilder(Const.Traits.CURSED, 7).addModifierAnySlot(GearType.ALL, Attributes.f_22286_, AttributeModifier.Operation.ADDITION, -0.5f, -1.0f, -1.5f, -2.0f, -3.0f, -4.0f, -5.0f).cancelsWith(Const.Traits.LUCKY).extraWikiLines("  - Please see the extra info on the Lucky trait and this wiki page: https://minecraft.gamepedia.com/Luck"));
        ret.add(new AttributeTraitBuilder(Const.Traits.LUCKY, 7).addModifierAnySlot(GearType.ALL, Attributes.f_22286_, AttributeModifier.Operation.ADDITION, 0.5f, 1.0f, 1.5f, 2.0f, 3.0f, 4.0f, 5.0f).cancelsWith(Const.Traits.CURSED).extraWikiLines("  - **Luck has nothing to do with the Fortune enchantment!** It affects loot from some loot tables, but not most. It does not increase drops from normal ores. Please read here for more information: https://minecraft.gamepedia.com/Luck"));
        ret.add(new AttributeTraitBuilder(Const.Traits.HEAVY, 5).addArmorModifier(Attributes.f_22279_, AttributeModifier.Operation.MULTIPLY_BASE, -0.01f, -0.02f, -0.03f, -0.04f, -0.05f).cancelsWith(Const.Traits.LIGHT).withGearTypeCondition(GearType.ARMOR, new GearType[0]));
        ret.add(new AttributeTraitBuilder(Const.Traits.LIGHT, 5).addArmorModifier(Attributes.f_22279_, AttributeModifier.Operation.MULTIPLY_BASE, 0.01f, 0.02f, 0.03f, 0.04f, 0.05f).cancelsWith(Const.Traits.HEAVY).withGearTypeCondition(GearType.ARMOR, new GearType[0]));
        int maxLevel = 5;
        float[] values = new float[maxLevel];
        for (int i = 0; i < maxLevel; ++i) {
            values[i] = -0.15f * (float)(i + 1);
        }
        ret.add(new AttributeTraitBuilder(Const.Traits.MOONWALKER, maxLevel).addModifierAnySlot(GearType.ALL, (Attribute)ForgeMod.ENTITY_GRAVITY.get(), AttributeModifier.Operation.MULTIPLY_BASE, values).withGearTypeCondition(GearType.BOOTS, GearType.CURIO));
        ret.add(new AttributeTraitBuilder(Const.Traits.REACH, 5).addModifierAnySlot(GearType.ALL, (Attribute)ForgeMod.BLOCK_REACH.get(), AttributeModifier.Operation.ADDITION, 0.5f, 1.0f, 1.5f, 2.0f, 3.0f));
        ret.add(new AttributeTraitBuilder(Const.Traits.SWIFT_SWIM, 5).addModifierAnySlot(GearType.ALL, (Attribute)ForgeMod.SWIM_SPEED.get(), AttributeModifier.Operation.ADDITION, 0.2f, 0.4f, 0.6f, 0.8f, 1.0f));
        ret.add(new EnchantmentTraitBuilder(Const.Traits.FIERY, 2).addEnchantments(GearType.MELEE_WEAPON, Enchantments.f_44981_, 1, 2).addEnchantments(GearType.RANGED_WEAPON, Enchantments.f_44990_, 1).withGearTypeCondition(GearType.WEAPON, new GearType[0]));
        ret.add(new EnchantmentTraitBuilder(Const.Traits.SILKY, 1).addEnchantments(GearType.HARVEST_TOOL, Enchantments.f_44985_, 1).withGearTypeCondition(GearType.HARVEST_TOOL, new GearType[0]));
        ret.add(new WielderEffectTraitBuilder(Const.Traits.ADAMANT, 5).addEffect(GearType.ARMOR, WielderEffectTraitBuilder.LevelType.PIECE_COUNT, MobEffects.f_19606_, 1, 1, 1, 2));
        ret.add(new WielderEffectTraitBuilder(Const.Traits.AQUATIC, 5).addEffect(GearType.ARMOR, WielderEffectTraitBuilder.LevelType.FULL_SET_ONLY, MobEffects.f_19608_, 1));
        ret.add(new WielderEffectTraitBuilder(Const.Traits.FLAME_WARD, 1).addEffect(GearType.ARMOR, WielderEffectTraitBuilder.LevelType.FULL_SET_ONLY, MobEffects.f_19607_, 1).overridesTrait(Const.Traits.FLAMMABLE).withGearTypeCondition(GearType.ARMOR, new GearType[0]).extraWikiLines("  - The item cannot be destroyed by fire or lava"));
        ret.add(new WielderEffectTraitBuilder(Const.Traits.KITTY_VISION, 1).addEffect(GearType.HELMET, WielderEffectTraitBuilder.LevelType.TRAIT_LEVEL, MobEffects.f_19611_, 1).addEffect(GearType.CURIO, WielderEffectTraitBuilder.LevelType.TRAIT_LEVEL, MobEffects.f_19611_, 1).withGearTypeCondition(GearType.HELMET, GearType.CURIO));
        ret.add(new WielderEffectTraitBuilder(Const.Traits.MIGHTY, 5).addEffect(GearType.TOOL, WielderEffectTraitBuilder.LevelType.TRAIT_LEVEL, MobEffects.f_19600_, 0, 0, 1, 1, 2).addEffect(GearType.TOOL, WielderEffectTraitBuilder.LevelType.TRAIT_LEVEL, MobEffects.f_19598_, 1, 1, 1, 2, 3).addEffect(GearType.CURIO, WielderEffectTraitBuilder.LevelType.TRAIT_LEVEL, MobEffects.f_19598_, 1, 1, 2, 2, 3).withGearTypeCondition(GearType.TOOL, GearType.CURIO));
        ret.add(new WielderEffectTraitBuilder(Const.Traits.STELLAR, 5, StellarTrait.SERIALIZER.getName()).addEffect(GearType.ARMOR, WielderEffectTraitBuilder.LevelType.PIECE_COUNT, MobEffects.f_19596_, 0, 1, 2, 3).addEffect(GearType.ARMOR, WielderEffectTraitBuilder.LevelType.PIECE_COUNT, MobEffects.f_19603_, 1, 2, 3, 4).extraWikiLines(String.format("  - Has a %d%% chance per level to restore 1 durability each second", 2)));
        ret.add(new TargetEffectTraitBuilder(Const.Traits.VENOM, 5).withDurationByLevel(GearType.TOOL, MobEffects.f_19614_, 0, 4.0f).withGearTypeCondition(GearType.TOOL, new GearType[0]));
        ret.add(new StatModifierTraitBuilder(Const.Traits.ACCELERATE, 5).addStatMod(ItemStats.HARVEST_SPEED, 2.0f, true, false).addStatMod(ItemStats.ATTACK_SPEED, 0.01f, true, false).addStatMod(ItemStats.RANGED_SPEED, 0.01f, true, false).withGearTypeCondition(GearType.TOOL, new GearType[0]));
        ret.add(new StatModifierTraitBuilder(Const.Traits.BULKY, 5).addStatMod(ItemStats.ATTACK_SPEED, -0.075f, true, false).withGearTypeCondition(GearType.TOOL, new GearType[0]));
        ret.add(new StatModifierTraitBuilder(Const.Traits.CHIPPING, 5).addStatMod(ItemStats.ARMOR, -0.075f, true, true).addStatMod(ItemStats.HARVEST_SPEED, 0.25f, true, true));
        ret.add(new StatModifierTraitBuilder(Const.Traits.CRUSHING, 5).addStatMod(ItemStats.ARMOR, 0.05f, true, true).addStatMod(ItemStats.MELEE_DAMAGE, -0.1667f, true, true));
        ret.add(new StatModifierTraitBuilder(Const.Traits.ERODED, 5).addStatMod(ItemStats.MELEE_DAMAGE, -0.15f, true, true).addStatMod(ItemStats.HARVEST_SPEED, 0.15f, true, true).cancelsWith(Const.Traits.JAGGED).withGearTypeCondition(GearType.TOOL, new GearType[0]));
        ret.add(new StatModifierTraitBuilder(Const.Traits.HARD, 5).addStatMod(ItemStats.HARVEST_SPEED, 0.05f, true, true).addStatMod(ItemStats.RANGED_DAMAGE, -0.1f, true, true).cancelsWith(Const.Traits.SOFT).withGearTypeCondition(GearType.TOOL, new GearType[0]));
        ret.add(new StatModifierTraitBuilder(Const.Traits.JAGGED, 5).addStatMod(ItemStats.MELEE_DAMAGE, 0.1667f, true, true).addStatMod(ItemStats.RANGED_DAMAGE, -0.1667f, true, true).cancelsWith(Const.Traits.ERODED));
        ret.add(new StatModifierTraitBuilder(Const.Traits.ORGANIC, 5).addStatMod(ItemStats.ENCHANTMENT_VALUE, 0.1f, true, true).addStatMod(ItemStats.MAGIC_DAMAGE, -0.15f, true, true).cancelsWith(Const.Traits.ERODED));
        ret.add(new StatModifierTraitBuilder(Const.Traits.SHARP, 5).addStatMod(ItemStats.HARVEST_SPEED, 0.125f, true, true).addStatMod(ItemStats.MELEE_DAMAGE, 0.125f, true, true).withGearTypeCondition(GearType.TOOL, new GearType[0]));
        ret.add(new StatModifierTraitBuilder(Const.Traits.SOFT, 5).addStatMod(ItemStats.HARVEST_SPEED, -0.15f, true, true).cancelsWith(Const.Traits.HARD).withGearTypeCondition(GearType.TOOL, new GearType[0]));
        ret.add(new BlockPlacerTraitBuilder(Const.Traits.CRACKLER, 1, Blocks.f_50137_, 3).withGearTypeCondition(GearType.TOOL, new GearType[0]));
        ret.add(new BlockPlacerTraitBuilder(Const.Traits.FLOATSTONER, 1, Blocks.f_50259_, 3).withGearTypeCondition(GearType.TOOL, new GearType[0]));
        ret.add(new BlockPlacerTraitBuilder(Const.Traits.IGNITE, 1, Blocks.f_50083_, 1).sound(SoundEvents.f_11942_, 1.0f, 1.0f).withGearTypeCondition(GearType.TOOL, new GearType[0]));
        ret.add(new BlockPlacerTraitBuilder(Const.Traits.RACKER, 1, Blocks.f_50134_, 3).withGearTypeCondition(GearType.TOOL, new GearType[0]));
        ret.add(new BlockPlacerTraitBuilder(Const.Traits.REFRACTIVE, 1, (Block)SgBlocks.PHANTOM_LIGHT.get(), 5).sound(SoundEvents.f_144049_, 0.75f, 0.5f).withGearTypeCondition(GearType.TOOL, new GearType[0]));
        ret.add(new BlockPlacerTraitBuilder(Const.Traits.TERMINUS, 1, Blocks.f_50069_, 3).withGearTypeCondition(GearType.TOOL, new GearType[0]));
        ret.add(new BlockPlacerTraitBuilder(Const.Traits.VULCAN, 1, Blocks.f_50080_, 20).cooldown(100).withGearTypeCondition(GearType.TOOL, new GearType[0]));
        ret.add(new BlockFillerTraitBuilder(Const.Traits.ROAD_MAKER, 1, Blocks.f_152481_, 0.5f).target(Blocks.f_50440_).fillRange(1, 0, 1, false));
        ret.add(TraitsProvider.bonusDropsTraits(Const.Traits.GOLD_DIGGER, 5, 0.15f, 0.5f, Ingredient.m_204132_(SgTags.Items.GOLD_DIGGER_DROPS)).withGearTypeCondition(GearType.HARVEST_TOOL, new GearType[0]));
        ret.add(TraitsProvider.bonusDropsTraits(Const.Traits.IMPERIAL, 5, 0.08f, 1.0f, Ingredient.m_204132_(SgTags.Items.IMPERIAL_DROPS)).withGearTypeCondition(GearType.HARVEST_TOOL, new GearType[0]));
        ret.add(TraitsProvider.cancelEffectsTrait(Const.Traits.CURE_POISON, MobEffects.f_19614_));
        ret.add(TraitsProvider.cancelEffectsTrait(Const.Traits.CURE_WITHER, MobEffects.f_19615_));
        ret.add(TraitsProvider.damageTypeTrait(Const.Traits.CHILLED, 5, "chilled", 2).withGearTypeCondition(GearType.WEAPON, new GearType[0]));
        ret.add(TraitsProvider.damageTypeTrait(Const.Traits.HOLY, 5, "holy", 2).withGearTypeCondition(GearType.WEAPON, new GearType[0]));
        ret.add(new BlockMiningSpeedTraitBuilder(Const.Traits.GREEDY, 5, 0.2f, (TagKey<Block>)Tags.Blocks.ORES));
        return ret;
    }
}

