/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block.salvager;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Random;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.block.salvager.SalvagerContainer;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.crafting.recipe.salvage.SalvagingRecipe;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.setup.SgBlockEntities;
import net.silentchaos512.gear.setup.SgRecipes;
import net.silentchaos512.lib.tile.LockableSidedInventoryTileEntity;
import net.silentchaos512.lib.tile.SyncVariable;
import net.silentchaos512.lib.util.TimeUtils;
import net.silentchaos512.utils.MathUtils;

public class SalvagerTileEntity
extends LockableSidedInventoryTileEntity {
    static final int BASE_WORK_TIME = TimeUtils.ticksFromSeconds((float)(SilentGear.isDevBuild() ? 2.0f : 10.0f));
    private static final int INPUT_SLOT = 0;
    private static final int[] SLOTS_INPUT = new int[]{0};
    private static final int[] SLOTS_OUTPUT = IntStream.rangeClosed(1, 18).toArray();
    private static final int[] SLOTS_ALL = IntStream.rangeClosed(0, 18).toArray();
    public static final int INVENTORY_SIZE = SLOTS_INPUT.length + SLOTS_OUTPUT.length;
    @SyncVariable(name="progress")
    int progress = 0;
    private final ContainerData fields = new ContainerData(){

        public int m_6413_(int index) {
            return SalvagerTileEntity.this.progress;
        }

        public void m_8050_(int index, int value) {
            SalvagerTileEntity.this.progress = value;
        }

        public int m_6499_() {
            return 1;
        }
    };

    public SalvagerTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SgBlockEntities.SALVAGER.get(), INVENTORY_SIZE, pos, state);
    }

    @Nullable
    private SalvagingRecipe getRecipe() {
        if (this.f_58857_ == null) {
            return null;
        }
        return this.f_58857_.m_7465_().m_44015_((RecipeType)SgRecipes.SALVAGING_TYPE.get(), (Container)this, this.f_58857_).orElse(null);
    }

    public int m_6643_() {
        return INVENTORY_SIZE;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SalvagerTileEntity blockEntity) {
        ItemStack input = blockEntity.m_8020_(0);
        SalvagingRecipe recipe = blockEntity.getRecipe();
        if (recipe != null) {
            if (blockEntity.progress < BASE_WORK_TIME) {
                ++blockEntity.progress;
            }
            if (blockEntity.progress >= BASE_WORK_TIME && blockEntity.areAllOutputSlotsFree()) {
                for (ItemStack stack : blockEntity.getSalvagedPartsWithChance(recipe, input)) {
                    int slot = blockEntity.getFreeOutputSlot();
                    if (slot > 0) {
                        blockEntity.m_6836_(slot, stack);
                        continue;
                    }
                    SilentGear.LOGGER.warn("Item lost in salvager: {}", (Object)stack);
                }
                blockEntity.progress = 0;
                input.m_41774_(1);
                if (input.m_41619_()) {
                    blockEntity.m_6836_(0, ItemStack.f_41583_);
                }
            }
        } else {
            blockEntity.progress = 0;
        }
    }

    private Collection<ItemStack> getSalvagedPartsWithChance(SalvagingRecipe recipe, ItemStack stack) {
        double lossRate = SalvagerTileEntity.getLossRate(stack);
        SilentGear.LOGGER.debug("Loss rate for '{}': {}", (Object)stack, (Object)lossRate);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ItemStack part : recipe.getPossibleResults((Container)this)) {
            ItemStack copy = part.m_41777_();
            int count = copy.m_41613_();
            PartData partData = PartData.from(part);
            double partLossRate = partData != null ? partData.get().getSalvageLossRate(partData, stack, lossRate) : lossRate;
            for (int i = 0; i < count; ++i) {
                if (!MathUtils.tryPercentage((Random)SilentGear.RANDOM, (double)partLossRate)) continue;
                copy.m_41774_(1);
            }
            if (copy.m_41619_()) continue;
            builder.add((Object)copy);
        }
        return builder.build();
    }

    private static double getLossRate(ItemStack stack) {
        int maxDamage = stack.m_41776_();
        double min = (Double)Config.Common.salvagerMinLossRate.get();
        if (maxDamage == 0) {
            return min;
        }
        double ratio = (double)stack.m_41773_() / (double)maxDamage;
        return min + ratio * ((Double)Config.Common.salvagerMaxLossRate.get() - min);
    }

    private int getFreeOutputSlot() {
        for (int slot : SLOTS_OUTPUT) {
            if (!this.m_8020_(slot).m_41619_()) continue;
            return slot;
        }
        return -1;
    }

    private boolean areAllOutputSlotsFree() {
        for (int slot : SLOTS_OUTPUT) {
            if (this.m_8020_(slot).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public CompoundTag m_5995_() {
        CompoundTag tags = super.m_5995_();
        SyncVariable.Helper.writeSyncVars((Object)((Object)this), (CompoundTag)tags, (SyncVariable.Type)SyncVariable.Type.PACKET);
        return tags;
    }

    public int[] m_7071_(Direction side) {
        switch (side) {
            case DOWN: {
                return SLOTS_OUTPUT;
            }
            case UP: {
                return SLOTS_INPUT;
            }
        }
        return SLOTS_ALL;
    }

    public boolean m_7013_(int index, ItemStack stack) {
        if (stack.m_41619_() || SalvagerTileEntity.isOutputSlot(index)) {
            return false;
        }
        ItemStack current = this.m_8020_(index);
        if (!current.m_41619_() && !current.equals(stack, false)) {
            return false;
        }
        return SalvagerTileEntity.isInputSlot(index) || super.m_7013_(index, stack);
    }

    public boolean m_7155_(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return this.m_7013_(index, itemStackIn);
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return SalvagerTileEntity.isOutputSlot(index);
    }

    private static boolean isInputSlot(int index) {
        for (int k : SLOTS_INPUT) {
            if (index != k) continue;
            return true;
        }
        return false;
    }

    private static boolean isOutputSlot(int index) {
        for (int k : SLOTS_OUTPUT) {
            if (index != k) continue;
            return true;
        }
        return false;
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.silentgear.salvager");
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory playerInventory) {
        return new SalvagerContainer(id, playerInventory, (Container)this, this.fields);
    }
}

