/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.storage.rendering;

import com.ldtteam.structurize.Network;
import com.ldtteam.structurize.config.BlueprintRenderSettings;
import com.ldtteam.structurize.network.messages.SyncPreviewCacheToClient;
import com.ldtteam.structurize.storage.rendering.types.BlueprintPreviewData;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ServerPreviewDistributor {
    private static Map<UUID, Tuple<ServerPlayer, BlueprintRenderSettings>> registeredPlayers = new HashMap<UUID, Tuple<ServerPlayer, BlueprintRenderSettings>>();

    @SubscribeEvent
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        registeredPlayers.put(event.getEntity().m_20148_(), (Tuple<ServerPlayer, BlueprintRenderSettings>)new Tuple((Object)((ServerPlayer)event.getEntity()), (Object)BlueprintRenderSettings.instance));
    }

    @SubscribeEvent
    public static void onLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        registeredPlayers.remove(event.getEntity().m_20148_());
    }

    public static void distribute(BlueprintPreviewData renderingCache, Player player) {
        for (Tuple<ServerPlayer, BlueprintRenderSettings> entry : registeredPlayers.values()) {
            if (!((BlueprintRenderSettings)entry.m_14419_()).renderSettings.get("structurize.display.shared").booleanValue() || !((ServerPlayer)entry.m_14418_()).m_6084_() || player.m_9236_() != ((ServerPlayer)entry.m_14418_()).m_9236_() || player.m_20148_().equals(((ServerPlayer)entry.m_14418_()).m_20148_()) || !(((ServerPlayer)entry.m_14418_()).m_20183_().m_123331_((Vec3i)renderingCache.getPos()) < 16384.0) && !renderingCache.getPos().equals((Object)BlockPos.f_121853_)) continue;
            Network.getNetwork().sendToPlayer(new SyncPreviewCacheToClient(renderingCache, ((ServerPlayer)entry.m_14418_()).m_20148_().toString()), (ServerPlayer)entry.m_14418_());
        }
    }

    public static void register(UUID uuid, Tuple<ServerPlayer, BlueprintRenderSettings> settings) {
        registeredPlayers.put(uuid, settings);
    }
}

