/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.storage;

import com.google.common.collect.ImmutableList;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.storage.ISurvivalBlueprintHandler;
import com.ldtteam.structurize.util.PlacementSettings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;

public class SurvivalBlueprintHandlers {
    private static final Map<String, ISurvivalBlueprintHandler> handlers = new HashMap<String, ISurvivalBlueprintHandler>();
    private static ImmutableList<ISurvivalBlueprintHandler> survivalHandlers = ImmutableList.of();

    public static ISurvivalBlueprintHandler getHandler(String id) {
        return handlers.get(id);
    }

    public static List<ISurvivalBlueprintHandler> getHandlers() {
        return survivalHandlers;
    }

    public static void registerHandler(ISurvivalBlueprintHandler handler) {
        handlers.put(handler.getId(), handler);
        survivalHandlers = ImmutableList.copyOf(handlers.values());
    }

    public static List<ISurvivalBlueprintHandler> getMatchingHandlers(Blueprint blueprint, ClientLevel level, Player player, BlockPos pos, PlacementSettings settings) {
        ArrayList<ISurvivalBlueprintHandler> matchingHandlers = new ArrayList<ISurvivalBlueprintHandler>();
        for (ISurvivalBlueprintHandler handler : handlers.values()) {
            if (!handler.canHandle(blueprint, level, player, pos, settings)) continue;
            matchingHandlers.add(handler);
        }
        return matchingHandlers;
    }
}

