/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.structurize.network.messages.BlueprintSyncMessage;
import com.ldtteam.structurize.network.messages.IMessage;
import com.ldtteam.structurize.storage.BlueprintPlacementHandling;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class BuildToolPlacementMessage
implements IMessage {
    public final HandlerType type;
    public final String handlerId;
    public final String structurePackId;
    public final String blueprintPath;
    public final BlockPos pos;
    public final Rotation rotation;
    public final Mirror mirror;
    public Level world;
    public ServerPlayer player;
    public boolean clientPack = false;

    public BuildToolPlacementMessage(FriendlyByteBuf buf) {
        this.type = HandlerType.values()[buf.readInt()];
        this.handlerId = buf.m_130136_(Short.MAX_VALUE);
        this.structurePackId = buf.m_130136_(Short.MAX_VALUE);
        this.blueprintPath = buf.m_130136_(Short.MAX_VALUE);
        this.pos = buf.m_130135_();
        this.rotation = Rotation.values()[buf.readInt()];
        this.mirror = Mirror.values()[buf.readInt()];
    }

    public BuildToolPlacementMessage(HandlerType type, String handlerId, String structurePackId, String blueprintPath, BlockPos pos, Rotation rotation, Mirror mirror) {
        this.type = type;
        this.handlerId = handlerId;
        this.structurePackId = structurePackId;
        this.blueprintPath = blueprintPath;
        this.pos = pos;
        this.rotation = rotation;
        this.mirror = mirror;
    }

    public BuildToolPlacementMessage(BlueprintSyncMessage msg, ServerPlayer player, Level world) {
        this.type = msg.type;
        this.handlerId = msg.handlerId;
        this.structurePackId = msg.structurePackId;
        this.blueprintPath = msg.blueprintPath;
        this.pos = msg.pos;
        this.rotation = msg.rotation;
        this.mirror = msg.mirror;
        this.clientPack = true;
        this.player = player;
        this.world = world;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.type.ordinal());
        buf.m_130070_(this.handlerId);
        buf.m_130070_(this.structurePackId);
        buf.m_130070_(this.blueprintPath);
        buf.m_130064_(this.pos);
        buf.writeInt(this.rotation.ordinal());
        buf.writeInt(this.mirror.ordinal());
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        this.world = ctxIn.getSender().m_9236_();
        this.player = ctxIn.getSender();
        BlueprintPlacementHandling.handlePlacement(this);
    }

    public static enum HandlerType {
        Complete,
        Pretty,
        Survival;

    }
}

