/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.management;

import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.api.util.Shape;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.management.UUIDStorage;
import com.ldtteam.structurize.placement.StructurePlacementUtils;
import com.ldtteam.structurize.util.BlockUtils;
import com.ldtteam.structurize.util.ChangeStorage;
import com.ldtteam.structurize.util.ITickedWorldOperation;
import com.ldtteam.structurize.util.TickedWorldOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraftforge.server.ServerLifecycleHooks;

public final class Manager {
    private static boolean schematicDownloaded = false;
    private static Map<UUID, List<ChangeStorage>> changeQueue = new HashMap<UUID, List<ChangeStorage>>();
    private static final LinkedList<ITickedWorldOperation> scanToolOperationPool = new LinkedList();
    private static volatile UUID serverUUID = null;

    private Manager() {
    }

    public static void onWorldTick(ServerLevel world) {
        ITickedWorldOperation operation;
        if (!scanToolOperationPool.isEmpty() && (operation = scanToolOperationPool.peek()) != null && operation.apply(world)) {
            scanToolOperationPool.pop();
            if (!operation.isUndoRedo()) {
                Manager.addToUndoRedoCache(operation.getChangeStorage());
            }
        }
    }

    public static void addToQueue(ITickedWorldOperation operation) {
        scanToolOperationPool.addLast(operation);
    }

    public static void addToUndoRedoCache(ChangeStorage storage) {
        List storages = changeQueue.computeIfAbsent(storage.getPlayerID(), key -> new ArrayList());
        if (!storages.contains(storage)) {
            storages.add(0, storage);
            if (storages.size() >= (Integer)Structurize.getConfig().getServer().maxCachedChanges.get()) {
                storages.remove(storages.size() - 1);
            }
        }
    }

    public static List<ChangeStorage> getChangeStoragesForPlayer(UUID player) {
        return changeQueue.getOrDefault(player, new ArrayList());
    }

    public static void pasteStructure(ServerLevel server, BlockPos pos, int width, int length, int height, int frequency, String equation, Shape shape, ItemStack inputBlock, ItemStack inputFillBlock, boolean hollow, ServerPlayer player, Mirror mirror, Rotation rotation) {
        Blueprint blueprint = Manager.getStructureFromFormula(width, length, height, frequency, equation, shape, inputBlock, inputFillBlock, hollow);
        StructurePlacementUtils.loadAndPlaceStructureWithRotation((Level)server, blueprint, pos, rotation, mirror, true, player);
    }

    public static Blueprint getStructureFromFormula(int width, int length, int height, int frequency, String equation, Shape shape, ItemStack inputBlock, ItemStack inputFillBlock, boolean hollow) {
        BlockState mainBlock = BlockUtils.getBlockStateFromStack(inputBlock, Blocks.f_50074_.m_49966_());
        BlockState fillBlock = BlockUtils.getBlockStateFromStack(inputFillBlock, Blocks.f_50074_.m_49966_());
        Blueprint blueprint = shape == Shape.SPHERE || shape == Shape.HALF_SPHERE || shape == Shape.BOWL ? Manager.generateSphere(height / 2, mainBlock, fillBlock, hollow, shape) : (shape == Shape.CUBE ? Manager.generateCube(height, width, length, mainBlock, fillBlock, hollow) : (shape == Shape.WAVE ? Manager.generateWave(height, width, length, frequency, mainBlock, true) : (shape == Shape.WAVE_3D ? Manager.generateWave(height, width, length, frequency, mainBlock, false) : (shape == Shape.CYLINDER ? Manager.generateCylinder(height, width, mainBlock, fillBlock, hollow) : (shape == Shape.PYRAMID || shape == Shape.UPSIDE_DOWN_PYRAMID || shape == Shape.DIAMOND ? Manager.generatePyramid(height, mainBlock, fillBlock, hollow, shape) : (shape == Shape.CONE ? Manager.generateCone(height, width, mainBlock, fillBlock, hollow, shape) : Manager.generateRandomShape(height, width, length, equation, mainBlock)))))));
        return blueprint;
    }

    private static Blueprint generatePyramid(int inputHeight, BlockState block, BlockState fillBlock, boolean hollow, Shape shape) {
        int height = shape == Shape.DIAMOND ? inputHeight : inputHeight * 2;
        int hHeight = height / 2;
        HashMap<BlockPos, BlockState> posList = new HashMap<BlockPos, BlockState>();
        for (int y = 0; y < hHeight; ++y) {
            for (int x = 0; x < hHeight; ++x) {
                for (int z = 0; z < hHeight; ++z) {
                    BlockState blockToUse;
                    if (!(x == z && x >= y || x == y && x >= z) && (!(hollow ? y == z : y >= z) || y < x) || x * z > y * y) continue;
                    BlockState blockState = blockToUse = x == z && x >= y || x == y || y == z ? block : fillBlock;
                    if (shape == Shape.UPSIDE_DOWN_PYRAMID || shape == Shape.DIAMOND) {
                        Manager.addPosToList(new BlockPos(hHeight + x, y, hHeight + z), blockToUse, posList);
                        Manager.addPosToList(new BlockPos(hHeight + x, y, hHeight - z), blockToUse, posList);
                        Manager.addPosToList(new BlockPos(hHeight - x, y, hHeight + z), blockToUse, posList);
                        Manager.addPosToList(new BlockPos(hHeight - x, y, hHeight - z), blockToUse, posList);
                    }
                    if (shape != Shape.PYRAMID && shape != Shape.DIAMOND) continue;
                    Manager.addPosToList(new BlockPos(hHeight + x, -y + height - (shape == Shape.DIAMOND ? 2 : inputHeight), hHeight + z), blockToUse, posList);
                    Manager.addPosToList(new BlockPos(hHeight + x, -y + height - (shape == Shape.DIAMOND ? 2 : inputHeight), hHeight - z), blockToUse, posList);
                    Manager.addPosToList(new BlockPos(hHeight - x, -y + height - (shape == Shape.DIAMOND ? 2 : inputHeight), hHeight + z), blockToUse, posList);
                    Manager.addPosToList(new BlockPos(hHeight - x, -y + height - (shape == Shape.DIAMOND ? 2 : inputHeight), hHeight - z), blockToUse, posList);
                }
            }
        }
        Blueprint blueprint = new Blueprint((short)height, (short)(shape == Shape.DIAMOND ? height : inputHeight + 2), (short)height);
        posList.forEach(blueprint::addBlockState);
        return blueprint;
    }

    private static Blueprint generateCone(int inputHeight, int width, BlockState block, BlockState fillBlock, boolean hollow, Shape shape) {
        int height = shape == Shape.DIAMOND ? inputHeight : inputHeight * 2;
        HashMap<BlockPos, BlockState> posList = new HashMap<BlockPos, BlockState>();
        for (int x = 0; x < width; ++x) {
            for (int z = 0; z < width; ++z) {
                for (int y = 0; y < height; ++y) {
                    boolean shouldBeEmpty;
                    int sum = x * x + z * z;
                    int consideredWidth = width - y;
                    boolean bl = shouldBeEmpty = sum > consideredWidth * consideredWidth / 4 - consideredWidth;
                    if (sum >= consideredWidth * consideredWidth / 4 || hollow && !shouldBeEmpty || consideredWidth <= 0) continue;
                    BlockState blockToUse = shouldBeEmpty ? block : fillBlock;
                    Manager.addPosToList(new BlockPos(width + x, y, width + z), blockToUse, posList);
                    Manager.addPosToList(new BlockPos(width + x, y, width - z), blockToUse, posList);
                    Manager.addPosToList(new BlockPos(width - x, y, width + z), blockToUse, posList);
                    Manager.addPosToList(new BlockPos(width - x, y, width - z), blockToUse, posList);
                }
            }
        }
        Blueprint blueprint = new Blueprint((short)(width * 2), (short)height, (short)(width * 2));
        posList.forEach(blueprint::addBlockState);
        return blueprint;
    }

    private static Blueprint generateCube(int height, int width, int length, BlockState block, BlockState fillBlock, boolean hollow) {
        HashMap<BlockPos, BlockState> posList = new HashMap<BlockPos, BlockState>();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                for (int z = 0; z < length; ++z) {
                    if (x == 0 || x == width - 1 || y == 0 || y == height - 1 || z == 0 || z == length - 1) {
                        posList.put(new BlockPos(x, y, z), block);
                        continue;
                    }
                    if (hollow) continue;
                    posList.put(new BlockPos(x, y, z), fillBlock);
                }
            }
        }
        Blueprint blueprint = new Blueprint((short)width, (short)height, (short)length);
        posList.forEach(blueprint::addBlockState);
        return blueprint;
    }

    private static Blueprint generateSphere(int height, BlockState block, BlockState fillBlock, boolean hollow, Shape shape) {
        HashMap<BlockPos, BlockState> posList = new HashMap<BlockPos, BlockState>();
        for (int y = 0; y <= height + 1; ++y) {
            for (int x = 0; x <= height + 1; ++x) {
                for (int z = 0; z <= height + 1; ++z) {
                    BlockState blockToUse;
                    int sum = x * x + z * z + y * y;
                    if (sum >= height * height || hollow && sum <= height * height - 2 * height) continue;
                    BlockState blockState = blockToUse = sum > height * height - 2 * height ? block : fillBlock;
                    if (shape == Shape.HALF_SPHERE || shape == Shape.SPHERE) {
                        Manager.addPosToList(new BlockPos(height + x, height + y, height + z), blockToUse, posList);
                        Manager.addPosToList(new BlockPos(height + x, height + y, height - z), blockToUse, posList);
                        Manager.addPosToList(new BlockPos(height - x, height + y, height + z), blockToUse, posList);
                        Manager.addPosToList(new BlockPos(height - x, height + y, height - z), blockToUse, posList);
                    }
                    if (shape != Shape.BOWL && shape != Shape.SPHERE) continue;
                    Manager.addPosToList(new BlockPos(height + x, height - y, height + z), blockToUse, posList);
                    Manager.addPosToList(new BlockPos(height + x, height - y, height - z), blockToUse, posList);
                    Manager.addPosToList(new BlockPos(height - x, height - y, height + z), blockToUse, posList);
                    Manager.addPosToList(new BlockPos(height - x, height - y, height - z), blockToUse, posList);
                }
            }
        }
        Blueprint blueprint = new Blueprint((short)((height + 2) * 2), (short)((height + 2) * 2), (short)((height + 2) * 2));
        posList.forEach(blueprint::addBlockState);
        return blueprint;
    }

    private static Blueprint generateCylinder(int height, int width, BlockState block, BlockState fillBlock, boolean hollow) {
        HashMap<BlockPos, BlockState> posList = new HashMap<BlockPos, BlockState>();
        for (int x = 0; x < width; ++x) {
            for (int z = 0; z < width; ++z) {
                for (int y = 0; y < height; ++y) {
                    boolean shouldBeEmpty;
                    int sum = x * x + z * z;
                    boolean bl = shouldBeEmpty = sum > width * width / 4 - width;
                    if (sum >= width * width / 4 || hollow && !shouldBeEmpty) continue;
                    BlockState blockToUse = shouldBeEmpty ? block : fillBlock;
                    Manager.addPosToList(new BlockPos(width + x, y, width + z), blockToUse, posList);
                    Manager.addPosToList(new BlockPos(width + x, y, width - z), blockToUse, posList);
                    Manager.addPosToList(new BlockPos(width - x, y, width + z), blockToUse, posList);
                    Manager.addPosToList(new BlockPos(width - x, y, width - z), blockToUse, posList);
                }
            }
        }
        Blueprint blueprint = new Blueprint((short)(width * 2), (short)height, (short)(width * 2));
        posList.forEach(blueprint::addBlockState);
        return blueprint;
    }

    private static Blueprint generateWave(int height, int width, int length, int frequency, BlockState block, boolean flat) {
        HashMap<BlockPos, BlockState> posList = new HashMap<BlockPos, BlockState>();
        for (int x = 0; x < length; ++x) {
            for (int z = 0; z < width; ++z) {
                double yVal = (double)(flat ? 0 : z) + (double)frequency * Math.sin((double)x / (double)height);
                Manager.addPosToList(BlockPos.m_274561_((double)x, (double)(yVal + (double)frequency), (double)((flat ? 0 : width) + z)), block, posList);
                if (flat) continue;
                Manager.addPosToList(BlockPos.m_274561_((double)x, (double)(yVal + (double)frequency), (double)(width - z)), block, posList);
                Manager.addPosToList(BlockPos.m_274561_((double)x, (double)(yVal + (double)width - 1.0 + (double)frequency), (double)(width + z - width + 1)), block, posList);
                Manager.addPosToList(BlockPos.m_274561_((double)x, (double)(yVal + (double)width - 1.0 + (double)frequency), (double)(width - z + width - 1)), block, posList);
            }
        }
        Blueprint blueprint = new Blueprint((short)length, (short)(frequency * 2 + 1 + (!flat ? width * 2 : 0)), (short)(width * 2 + 1));
        posList.forEach(blueprint::addBlockState);
        return blueprint;
    }

    public static Blueprint generateRandomShape(int height, int width, int length, String equation, BlockState block) {
        return null;
    }

    private static void addPosToList(BlockPos blockPos, BlockState blockToUse, Map<BlockPos, BlockState> posList) {
        if (!posList.containsKey(blockPos)) {
            posList.put(blockPos, blockToUse);
        }
    }

    public static void undo(Player player, int operationID) {
        List<ChangeStorage> list = changeQueue.get(player.m_20148_());
        if (list == null || list.isEmpty()) {
            player.m_5661_((Component)Component.m_237115_((String)"structurize.gui.undoredo.undo.notfound"), false);
            return;
        }
        Iterator<ChangeStorage> iterator = list.iterator();
        while (iterator.hasNext()) {
            ChangeStorage storage = iterator.next();
            if (storage.getID() != operationID) continue;
            if (!storage.isDone()) {
                player.m_5661_((Component)Component.m_237110_((String)"structurize.gui.undoredo.undo.inprogress", (Object[])new Object[]{storage.getOperation()}), false);
                return;
            }
            player.m_5661_((Component)Component.m_237110_((String)"structurize.gui.undoredo.undo.add", (Object[])new Object[]{storage.getOperation()}), false);
            Manager.addToQueue(new TickedWorldOperation(storage, player, TickedWorldOperation.OperationType.UNDO));
            if (storage.getOperation().indexOf(TickedWorldOperation.OperationType.UNDO.toString()) == 0) {
                iterator.remove();
            }
            return;
        }
        player.m_5661_((Component)Component.m_237115_((String)"structurize.gui.undoredo.undo.notfound"), false);
    }

    public static void redo(Player player, int operationID) {
        List<ChangeStorage> list = changeQueue.get(player.m_20148_());
        if (list == null || list.isEmpty()) {
            player.m_5661_((Component)Component.m_237115_((String)"structurize.gui.undoredo.redo.notfound"), false);
            return;
        }
        for (ChangeStorage storage : list) {
            if (storage.getID() != operationID) continue;
            if (!storage.isDone()) {
                player.m_5661_((Component)Component.m_237110_((String)"structurize.gui.undoredo.redo.inprogress", (Object[])new Object[]{storage.getOperation()}), false);
                return;
            }
            player.m_5661_((Component)Component.m_237110_((String)"structurize.gui.undoredo.redo.add", (Object[])new Object[]{storage.getOperation()}), false);
            Manager.addToQueue(new TickedWorldOperation(storage, player, TickedWorldOperation.OperationType.REDO));
            return;
        }
        player.m_5661_((Component)Component.m_237115_((String)"structurize.gui.undoredo.redo.notfound"), false);
    }

    public static UUID getServerUUID() {
        if (serverUUID == null) {
            return Manager.generateOrRetrieveUUID();
        }
        return serverUUID;
    }

    private static UUID generateOrRetrieveUUID() {
        DimensionDataStorage storage = ServerLifecycleHooks.getCurrentServer().m_129783_().m_8895_();
        UUIDStorage instance = (UUIDStorage)storage.m_164861_(UUIDStorage::new, UUIDStorage::new, "structurize_UUID");
        if (serverUUID == null) {
            Manager.setServerUUID(UUID.randomUUID());
            Log.getLogger().info(String.format("New Server UUID %s", serverUUID));
        }
        storage.m_164855_("structurize_UUID", (SavedData)instance);
        return serverUUID;
    }

    public static void setServerUUID(UUID uuid) {
        serverUUID = uuid;
    }

    public static boolean isSchematicDownloaded() {
        return schematicDownloaded;
    }

    public static void setSchematicDownloaded(boolean downloaded) {
        schematicDownloaded = downloaded;
    }
}

