/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.client;

import com.ldtteam.structurize.blockentities.BlockEntityTagSubstitution;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.blueprints.v1.BlueprintUtils;
import com.ldtteam.structurize.client.BlueprintBlockAccess;
import com.ldtteam.structurize.client.ChunkOffsetBufferBuilderWrapper;
import com.ldtteam.structurize.config.BlueprintRenderSettings;
import com.ldtteam.structurize.storage.rendering.types.BlueprintPreviewData;
import com.ldtteam.structurize.util.BlockInfo;
import com.ldtteam.structurize.util.BlockUtils;
import com.ldtteam.structurize.util.BlueprintMissHitResult;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ChunkBufferBuilderPack;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import net.minecraft.world.level.block.entity.EnchantmentTableBlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlueprintRenderer
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlueprintRenderer.class);
    private static final Supplier<Map<RenderType, VertexBuffer>> blockVertexBuffersFactory = () -> RenderType.m_110506_().stream().collect(Collectors.toMap(type -> type, type -> new VertexBuffer(VertexBuffer.Usage.STATIC)));
    private static final RenderBuffers renderBuffers = new RenderBuffers();
    private final BlueprintBlockAccess blockAccess;
    private List<Entity> entities;
    private List<BlockEntity> tileEntities;
    private Map<RenderType, VertexBuffer> vertexBuffers;
    private long lastGameTime;

    public static BlueprintRenderer buildRendererForBlueprint(Blueprint blueprint) {
        BlueprintBlockAccess blockAccess = new BlueprintBlockAccess(blueprint);
        return new BlueprintRenderer(blockAccess);
    }

    private BlueprintRenderer(BlueprintBlockAccess blockAccess) {
        this.blockAccess = blockAccess;
    }

    public void updateBlueprint(BlueprintPreviewData previewData) {
        if (this.blockAccess.getBlueprint() != previewData.getBlueprint() && this.blockAccess.getBlueprint().hashCode() == previewData.getBlueprint().hashCode()) {
            this.blockAccess.setBlueprint(previewData.getBlueprint());
        }
    }

    private void init(BlockPos anchorPos) {
        Blueprint blueprint = this.blockAccess.getBlueprint();
        List<BlockInfo> blocks = blueprint.getBlockInfoAsList();
        HashMap<BlockPos, ModelData> teModelData = new HashMap<BlockPos, ModelData>();
        Minecraft mc = Minecraft.m_91087_();
        BlockRenderDispatcher blockRendererDispatcher = mc.m_91289_();
        RandomSource random = RandomSource.m_216327_();
        ClientLevel serverLevel = mc.m_91091_() ? mc.m_91092_().m_6846_().m_11259_(mc.f_91074_.m_20148_()).m_9236_() : null;
        BlockState defaultFluidState = BlockUtils.getFluidForDimension((Level)(serverLevel == null ? mc.f_91073_ : serverLevel));
        this.clearVertexBuffers();
        this.entities = BlueprintUtils.instantiateEntities(blueprint, this.blockAccess);
        this.tileEntities = new ArrayList<BlockEntity>(BlueprintUtils.instantiateTileEntities(blueprint, this.blockAccess, teModelData));
        PoseStack matrixStack = new PoseStack();
        OurChunkBufferBuilderPack newBuffers = new OurChunkBufferBuilderPack();
        RenderType[] blockRenderTypes = (RenderType[])RenderType.m_110506_().toArray(RenderType[]::new);
        for (BlockInfo blockInfo : blocks) {
            try {
                ChunkOffsetBufferBuilderWrapper buffer;
                FluidState fluidState;
                BlockPos blockPos = blockInfo.getPos();
                BlockState state = blockInfo.getState();
                if (!BlueprintRenderSettings.instance.renderSettings.get("structurize.render.placeholders").booleanValue()) {
                    if (state.m_60734_() == ModBlocks.blockSubstitution.get()) {
                        state = Blocks.f_50016_.m_49966_();
                    }
                    if (state.m_60734_() == ModBlocks.blockTagSubstitution.get()) {
                        Optional<BlockEntity> tagTE = this.tileEntities.stream().filter(te -> te.m_58899_().equals((Object)blockPos) && te instanceof BlockEntityTagSubstitution).findFirst();
                        if (tagTE.isPresent()) {
                            BlockEntityTagSubstitution.ReplacementBlock replacement = ((BlockEntityTagSubstitution)tagTE.get()).getReplacement();
                            state = replacement.getBlockState();
                            this.tileEntities.remove(tagTE.get());
                            Optional.ofNullable(replacement.createBlockEntity(blockPos)).ifPresent(e -> {
                                e.m_142339_((Level)this.blockAccess);
                                teModelData.put(blockPos, e.getModelData());
                                this.tileEntities.add((BlockEntity)e);
                            });
                        } else {
                            state = Blocks.f_50016_.m_49966_();
                        }
                    }
                    if (state.m_60734_() == ModBlocks.blockFluidSubstitution.get()) {
                        state = defaultFluidState;
                    }
                    if (SharedConstants.f_136183_ && serverLevel != null && state.m_60734_() == ModBlocks.blockSolidSubstitution.get() && (state = BlockUtils.getWorldgenBlock((Level)serverLevel, anchorPos.m_121955_((Vec3i)blockPos), blueprint.getRawBlockStateFunction().compose(b -> b.m_121996_((Vec3i)anchorPos)))) == null) {
                        state = blockInfo.getState();
                    }
                }
                if (!(fluidState = state.m_60819_()).m_76178_()) {
                    RenderType renderType = ItemBlockRenderTypes.m_109287_((FluidState)fluidState);
                    int chunkOffsetX = blockPos.m_123341_() - (blockPos.m_123341_() & 0xF);
                    int chunkOffsetY = blockPos.m_123342_() - (blockPos.m_123342_() & 0xF);
                    int chunkOffsetZ = blockPos.m_123343_() - (blockPos.m_123343_() & 0xF);
                    buffer = ChunkOffsetBufferBuilderWrapper.setupGlobalInstance(newBuffers.m_108839_(renderType), chunkOffsetX, chunkOffsetY, chunkOffsetZ);
                    blockRendererDispatcher.m_234363_(blockPos, (BlockAndTintGetter)this.blockAccess, (VertexConsumer)buffer, state, fluidState);
                }
                if (state.m_60799_() == RenderShape.INVISIBLE) continue;
                BakedModel blockModel = blockRendererDispatcher.m_110910_(state);
                @NotNull ModelData modelData = blockModel.getModelData((BlockAndTintGetter)this.blockAccess, blockPos, state, teModelData.getOrDefault(blockPos, ModelData.EMPTY));
                matrixStack.m_85836_();
                matrixStack.m_252880_((float)blockPos.m_123341_(), (float)blockPos.m_123342_(), (float)blockPos.m_123343_());
                for (RenderType renderType : blockModel.getRenderTypes(state, random, modelData)) {
                    buffer = newBuffers.m_108839_(renderType);
                    blockRendererDispatcher.renderBatched(state, blockPos, (BlockAndTintGetter)this.blockAccess, matrixStack, (VertexConsumer)buffer, true, random, modelData, renderType);
                    renderType.m_110188_();
                }
                matrixStack.m_85849_();
            }
            catch (ReportedException e2) {
                LOGGER.error("Error while trying to render structure part: " + e2.getMessage(), e2.getCause());
            }
        }
        this.vertexBuffers = blockVertexBuffersFactory.get();
        for (RenderType renderType : blockRenderTypes) {
            BufferBuilder.RenderedBuffer newBuffer = newBuffers.m_108839_(renderType).m_231168_();
            if (newBuffer == null) {
                this.vertexBuffers.remove(renderType);
                continue;
            }
            VertexBuffer vertexBuffer = this.vertexBuffers.get(renderType);
            vertexBuffer.m_85921_();
            vertexBuffer.m_231221_(newBuffer);
        }
        newBuffers.m_108838_();
        VertexBuffer.m_85931_();
    }

    public void draw(BlueprintPreviewData previewData, BlockPos pos, RenderLevelStageEvent ctx) {
        Minecraft mc = Minecraft.m_91087_();
        long gameTime = mc.f_91073_.m_46467_();
        PoseStack matrixStack = ctx.getPoseStack();
        float partialTicks = ctx.getPartialTick();
        mc.m_91307_().m_6180_("struct_render_init");
        this.updateBlueprint(previewData);
        BlockPos anchorPos = pos.m_121996_((Vec3i)this.blockAccess.getBlueprint().getPrimaryBlockOffset());
        this.blockAccess.setWorldPos(anchorPos);
        AABB blueprintAABB = new AABB(BlockPos.f_121853_).m_82363_((double)(this.blockAccess.getBlueprint().getSizeX() - 1), (double)(this.blockAccess.getBlueprint().getSizeY() - 1), (double)(this.blockAccess.getBlueprint().getSizeZ() - 1)).m_82338_(anchorPos);
        if (!ctx.getFrustum().m_113029_(blueprintAABB)) {
            return;
        }
        if (this.vertexBuffers == null) {
            this.init(anchorPos);
        }
        mc.m_91307_().m_6182_("struct_render_prepare");
        Vec3 viewPosition = mc.f_91063_.m_109153_().m_90583_();
        Vec3 realRenderRootVecd = Vec3.m_82528_((Vec3i)anchorPos).m_82546_(viewPosition);
        Vector3f realRenderRootVecf = realRenderRootVecd.m_252839_();
        Level dispLevel = mc.m_167982_().f_112248_;
        Camera dispCamera = mc.m_167982_().f_112249_;
        HitResult beHitResult = mc.m_167982_().f_112250_;
        Entity ePickEntity = mc.m_91290_().f_114359_;
        Camera ourCamera = new Camera();
        ourCamera.m_90575_((BlockGetter)this.blockAccess, dispCamera.m_90592_(), !mc.f_91066_.m_92176_().m_90612_(), mc.f_91066_.m_92176_().m_90613_(), partialTicks);
        ourCamera.m_90581_(viewPosition.m_82492_((double)anchorPos.m_123341_(), (double)anchorPos.m_123342_(), (double)anchorPos.m_123343_()));
        mc.m_167982_().m_173564_((Level)this.blockAccess, ourCamera, (HitResult)BlueprintMissHitResult.MISS);
        mc.m_91290_().m_114408_((Level)this.blockAccess, ourCamera, mc.f_91076_);
        Frustum blueprintLocalFrustum = new Frustum(ctx.getFrustum());
        blueprintLocalFrustum.m_113002_(ourCamera.m_90583_().m_7096_(), ourCamera.m_90583_().m_7098_(), ourCamera.m_90583_().m_7094_());
        matrixStack.m_85836_();
        matrixStack.m_85837_(viewPosition.m_7096_(), viewPosition.m_7098_(), viewPosition.m_7094_());
        Matrix4f mvMatrix = matrixStack.m_85850_().m_252922_();
        Lighting.m_252756_((Matrix4f)mvMatrix);
        FogRenderer.m_234172_((Camera)mc.f_91063_.m_109153_(), (FogRenderer.FogMode)FogRenderer.FogMode.FOG_TERRAIN, (float)Math.max(mc.f_91063_.m_109152_(), 32.0f), (mc.f_91073_.m_104583_().m_5781_(Mth.m_14107_((double)viewPosition.m_7096_()), Mth.m_14107_((double)viewPosition.m_7098_())) || mc.f_91065_.m_93090_().m_93715_() ? 1 : 0) != 0, (float)partialTicks);
        mc.m_91307_().m_6182_("struct_render_blocks");
        this.renderBlockLayer(RenderType.m_110451_(), mvMatrix, realRenderRootVecf);
        mc.m_91304_().m_119428_(InventoryMenu.f_39692_).setBlurMipmap(false, (Integer)mc.f_91066_.m_232119_().m_231551_() > 0);
        this.renderBlockLayer(RenderType.m_110457_(), mvMatrix, realRenderRootVecf);
        mc.m_91304_().m_119428_(InventoryMenu.f_39692_).restoreLastBlurMipmap();
        this.renderBlockLayer(RenderType.m_110463_(), mvMatrix, realRenderRootVecf);
        mc.m_91307_().m_6182_("struct_render_entities");
        MultiBufferSource.BufferSource renderBufferSource = renderBuffers.m_110104_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(realRenderRootVecd.m_7096_(), realRenderRootVecd.m_7098_(), realRenderRootVecd.m_7094_());
        for (Entity entity : this.entities) {
            if (!mc.m_91290_().m_114397_(entity, blueprintLocalFrustum, ourCamera.m_90583_().m_7096_(), ourCamera.m_90583_().m_7098_(), ourCamera.m_90583_().m_7094_())) continue;
            if (gameTime != this.lastGameTime && entity instanceof EndCrystal) {
                EndCrystal crystal = (EndCrystal)entity;
                ++crystal.f_31032_;
            }
            try {
                mc.m_91290_().m_114384_(entity, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), entity.m_146908_(), partialTicks, matrixStack, (MultiBufferSource)renderBufferSource, LightTexture.m_109885_((int)15, (int)15));
            }
            catch (ClassCastException crystal) {}
        }
        matrixStack.m_85849_();
        mc.m_91307_().m_6182_("struct_render_entities_finish");
        renderBufferSource.m_173043_();
        renderBufferSource.m_109912_(RenderType.m_110446_((ResourceLocation)InventoryMenu.f_39692_));
        renderBufferSource.m_109912_(RenderType.m_110452_((ResourceLocation)InventoryMenu.f_39692_));
        renderBufferSource.m_109912_(RenderType.m_110458_((ResourceLocation)InventoryMenu.f_39692_));
        renderBufferSource.m_109912_(RenderType.m_110476_((ResourceLocation)InventoryMenu.f_39692_));
        mc.m_91307_().m_6182_("struct_render_blockentities");
        for (BlockEntity tileEntity : this.tileEntities) {
            if (!blueprintLocalFrustum.m_113029_(tileEntity.getRenderBoundingBox())) continue;
            BlockPos tePos = tileEntity.m_58899_();
            Vec3 realRenderTePos = realRenderRootVecd.m_82520_((double)tePos.m_123341_(), (double)tePos.m_123342_(), (double)tePos.m_123343_());
            if (gameTime != this.lastGameTime) {
                if (tileEntity instanceof SpawnerBlockEntity) {
                    SpawnerBlockEntity spawner = (SpawnerBlockEntity)tileEntity;
                    SpawnerBlockEntity.m_155754_((Level)mc.f_91073_, (BlockPos)anchorPos.m_121955_((Vec3i)tePos), (BlockState)this.blockAccess.m_8055_(tePos), (SpawnerBlockEntity)spawner);
                } else if (tileEntity instanceof EnchantmentTableBlockEntity) {
                    EnchantmentTableBlockEntity enchTable = (EnchantmentTableBlockEntity)tileEntity;
                    EnchantmentTableBlockEntity.m_155503_((Level)mc.f_91073_, (BlockPos)anchorPos.m_121955_((Vec3i)tePos), (BlockState)this.blockAccess.m_8055_(tePos), (EnchantmentTableBlockEntity)enchTable);
                } else if (tileEntity instanceof CampfireBlockEntity) {
                    CampfireBlockEntity campfire = (CampfireBlockEntity)tileEntity;
                    bs = this.blockAccess.m_8055_(tePos);
                    if (bs.m_60734_() instanceof CampfireBlock && ((Boolean)bs.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) {
                        CampfireBlockEntity.m_155318_((Level)mc.f_91073_, (BlockPos)anchorPos.m_121955_((Vec3i)tePos), (BlockState)bs, (CampfireBlockEntity)campfire);
                    }
                } else if (tileEntity instanceof SkullBlockEntity) {
                    SkullBlockEntity skull = (SkullBlockEntity)tileEntity;
                    bs = this.blockAccess.m_8055_(tePos);
                    if (bs.m_60734_() instanceof SkullBlock && bs.m_60713_(Blocks.f_50320_) || bs.m_60713_(Blocks.f_50321_)) {
                        SkullBlockEntity.m_261318_((Level)mc.f_91073_, (BlockPos)anchorPos.m_121955_((Vec3i)tePos), (BlockState)bs, (SkullBlockEntity)skull);
                    }
                }
            }
            matrixStack.m_85836_();
            matrixStack.m_85837_(realRenderTePos.f_82479_, realRenderTePos.f_82480_, realRenderTePos.f_82481_);
            mc.m_167982_().m_112267_(tileEntity, partialTicks, matrixStack, (MultiBufferSource)renderBufferSource);
            matrixStack.m_85849_();
        }
        mc.m_91307_().m_6182_("struct_render_blockentities_finish");
        renderBufferSource.m_109912_(RenderType.m_110451_());
        renderBufferSource.m_109912_(RenderType.m_173239_());
        renderBufferSource.m_109912_(RenderType.m_173242_());
        renderBufferSource.m_109912_(Sheets.m_110789_());
        renderBufferSource.m_109912_(Sheets.m_110790_());
        renderBufferSource.m_109912_(Sheets.m_110785_());
        renderBufferSource.m_109912_(Sheets.m_110786_());
        renderBufferSource.m_109912_(Sheets.m_110787_());
        renderBufferSource.m_109912_(Sheets.m_110788_());
        renderBuffers.m_110109_().m_109928_();
        renderBufferSource.m_173043_();
        renderBufferSource.m_109912_(Sheets.m_110792_());
        renderBufferSource.m_109912_(Sheets.m_110762_());
        renderBufferSource.m_109912_(Sheets.m_110782_());
        renderBufferSource.m_109912_(RenderType.m_110481_());
        renderBufferSource.m_109912_(RenderType.m_110484_());
        renderBufferSource.m_109912_(RenderType.m_110490_());
        renderBufferSource.m_109912_(RenderType.m_110493_());
        renderBufferSource.m_109912_(RenderType.m_110487_());
        renderBufferSource.m_109912_(RenderType.m_110496_());
        renderBufferSource.m_109912_(RenderType.m_110499_());
        renderBufferSource.m_109912_(RenderType.m_110478_());
        renderBuffers.m_110108_().m_109911_();
        mc.m_91307_().m_6182_("struct_render_blocks2");
        this.renderBlockLayer(RenderType.m_110466_(), mvMatrix, realRenderRootVecf);
        renderBufferSource.m_109912_(RenderType.m_110504_());
        renderBufferSource.m_109911_();
        this.renderBlockLayer(RenderType.m_110503_(), mvMatrix, realRenderRootVecf);
        matrixStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
        Lighting.m_252756_((Matrix4f)matrixStack.m_85850_().m_252922_());
        FogRenderer.m_109017_();
        mc.m_167982_().m_173564_(dispLevel, dispCamera, beHitResult);
        mc.m_91290_().m_114408_(dispLevel, dispCamera, ePickEntity);
        this.lastGameTime = gameTime;
        mc.m_91307_().m_7238_();
    }

    private void clearVertexBuffers() {
        if (this.vertexBuffers != null) {
            this.vertexBuffers.values().forEach(VertexBuffer::close);
            this.vertexBuffers = null;
        }
    }

    @Override
    public void close() {
        this.clearVertexBuffers();
    }

    private void renderBlockLayer(RenderType layerRenderType, Matrix4f mvMatrix, Vector3f realRenderRootPos) {
        VertexBuffer vertexBuffer = this.vertexBuffers.get(layerRenderType);
        if (vertexBuffer == null) {
            return;
        }
        layerRenderType.m_110185_();
        ShaderInstance shaderinstance = RenderSystem.getShader();
        for (int k = 0; k < 12; ++k) {
            shaderinstance.m_173350_("Sampler" + k, (Object)RenderSystem.getShaderTexture((int)k));
        }
        if (shaderinstance.f_173308_ != null) {
            shaderinstance.f_173308_.m_5679_(mvMatrix);
        }
        if (shaderinstance.f_173309_ != null) {
            shaderinstance.f_173309_.m_5679_(RenderSystem.getProjectionMatrix());
        }
        if (shaderinstance.f_173312_ != null) {
            shaderinstance.f_173312_.m_5941_(RenderSystem.getShaderColor());
        }
        if (shaderinstance.f_267422_ != null) {
            shaderinstance.f_267422_.m_5985_(RenderSystem.getShaderGlintAlpha());
        }
        if (shaderinstance.f_173315_ != null) {
            shaderinstance.f_173315_.m_5985_(RenderSystem.getShaderFogStart());
        }
        if (shaderinstance.f_173316_ != null) {
            shaderinstance.f_173316_.m_5985_(RenderSystem.getShaderFogEnd());
        }
        if (shaderinstance.f_173317_ != null) {
            shaderinstance.f_173317_.m_5941_(RenderSystem.getShaderFogColor());
        }
        if (shaderinstance.f_202432_ != null) {
            shaderinstance.f_202432_.m_142617_(RenderSystem.getShaderFogShape().m_202324_());
        }
        if (shaderinstance.f_173310_ != null) {
            shaderinstance.f_173310_.m_5679_(RenderSystem.getTextureMatrix());
        }
        if (shaderinstance.f_173319_ != null) {
            shaderinstance.f_173319_.m_5985_(RenderSystem.getShaderGameTime());
        }
        RenderSystem.setupShaderLights((ShaderInstance)shaderinstance);
        shaderinstance.m_173363_();
        Uniform uniform = shaderinstance.f_173320_;
        if (uniform != null) {
            uniform.m_142276_(realRenderRootPos);
            uniform.m_85633_();
        }
        vertexBuffer.m_85921_();
        vertexBuffer.m_166882_();
        if (uniform != null) {
            uniform.m_142276_(new Vector3f(0.0f, 0.0f, 0.0f));
        }
        shaderinstance.m_173362_();
        VertexBuffer.m_85931_();
        layerRenderType.m_110188_();
    }

    private static class OurChunkBufferBuilderPack
    extends ChunkBufferBuilderPack {
        private OurChunkBufferBuilderPack() {
        }

        public BufferBuilder m_108839_(RenderType renderType) {
            BufferBuilder buffer = super.m_108839_(renderType);
            if (!buffer.m_85732_()) {
                buffer.m_166779_(renderType.m_173186_(), renderType.m_110508_());
            }
            return buffer;
        }
    }
}

