/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.blueprints.v1;

import com.ldtteam.structurize.api.util.BlockPosUtil;
import com.ldtteam.structurize.api.util.ItemStackUtils;
import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.blockentities.BlockEntityTagSubstitution;
import com.ldtteam.structurize.blockentities.ModBlockEntities;
import com.ldtteam.structurize.blockentities.interfaces.IBlueprintDataProviderBE;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.blocks.interfaces.IAnchorBlock;
import com.ldtteam.structurize.blocks.schematic.BlockSubstitution;
import com.ldtteam.structurize.util.BlockInfo;
import com.ldtteam.structurize.util.BlockUtils;
import com.ldtteam.structurize.util.BlueprintPositionInfo;
import com.ldtteam.structurize.util.RotationMirror;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Blueprint {
    private static final String ENTITY_POS = "Pos";
    private final List<String> requiredMods;
    private short sizeX;
    private short sizeY;
    private short sizeZ;
    private short palleteSize;
    private String fileName;
    private Path filePath;
    private String packName;
    private List<BlockState> palette;
    private String name;
    private String[] architects;
    private String[] missingMods;
    private short[][][] structure;
    private CompoundTag[][][] tileEntities;
    private CompoundTag[] entities = new CompoundTag[0];
    private List<BlockInfo> cacheBlockInfo = null;
    private Map<BlockPos, BlockInfo> cacheBlockInfoMap = null;
    private Map<BlockPos, CompoundTag[]> cacheEntitiesMap = null;
    private BlockPos cachePrimaryOffset = null;
    private RotationMirror rotationMirror = RotationMirror.NONE;

    public Blueprint(short sizeX, short sizeY, short sizeZ, short palleteSize, List<BlockState> pallete, short[][][] structure, CompoundTag[] tileEntities, List<String> requiredMods) {
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
        this.palleteSize = palleteSize;
        this.palette = pallete;
        this.structure = structure;
        this.tileEntities = new CompoundTag[sizeY][sizeZ][sizeX];
        for (CompoundTag te : tileEntities) {
            if (te == null) continue;
            this.tileEntities[te.m_128448_((String)"y")][te.m_128448_((String)"z")][te.m_128448_((String)"x")] = te;
        }
        this.requiredMods = requiredMods;
    }

    public Blueprint(short sizeX, short sizeY, short sizeZ) {
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
        this.structure = new short[sizeY][sizeZ][sizeX];
        this.tileEntities = new CompoundTag[sizeY][sizeZ][sizeX];
        this.requiredMods = new ArrayList<String>();
        this.palette = new ArrayList<BlockState>();
        this.palette.add(0, ((BlockSubstitution)((Object)ModBlocks.blockSubstitution.get())).m_49966_());
        this.palleteSize = 1;
    }

    public short getSizeX() {
        return this.sizeX;
    }

    public short getSizeY() {
        return this.sizeY;
    }

    public short getSizeZ() {
        return this.sizeZ;
    }

    public short getPalleteSize() {
        return this.palleteSize;
    }

    public BlockState[] getPalette() {
        return this.palette.toArray(new BlockState[0]);
    }

    public void addBlockState(BlockPos pos, BlockState state) {
        int index = -1;
        for (int i = 0; i < this.palette.size(); ++i) {
            if (!this.palette.get(i).equals(state)) continue;
            index = i;
            break;
        }
        if (index == -1) {
            index = this.palleteSize;
            this.palleteSize = (short)(this.palleteSize + 1);
            this.palette.add(state);
        }
        this.structure[pos.m_123342_()][pos.m_123343_()][pos.m_123341_()] = (short)index;
        this.cacheReset(true);
    }

    public short[][][] getStructure() {
        return this.structure;
    }

    public CompoundTag[][][] getTileEntities() {
        return this.tileEntities;
    }

    public CompoundTag[] getEntities() {
        return this.entities;
    }

    public void setEntities(CompoundTag[] entities) {
        this.entities = entities;
    }

    public List<String> getRequiredMods() {
        return this.requiredMods;
    }

    public String getName() {
        return this.name;
    }

    public Blueprint setName(String name) {
        this.name = name;
        return this;
    }

    public Blueprint setFileName(String name) {
        this.fileName = name;
        return this;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Blueprint setFilePath(Path path) {
        this.filePath = path;
        return this;
    }

    public Blueprint setPackName(String packName) {
        this.packName = packName;
        return this;
    }

    public Path getFilePath() {
        return this.filePath;
    }

    public String getPackName() {
        return this.packName;
    }

    public String[] getArchitects() {
        return this.architects;
    }

    public void setArchitects(String[] architects) {
        this.architects = architects;
    }

    public String[] getMissingMods() {
        return this.missingMods;
    }

    public Blueprint setMissingMods(String ... missingMods) {
        this.missingMods = missingMods;
        return this;
    }

    public final List<CompoundTag> getEntitiesAsList() {
        return Arrays.stream(this.entities).collect(Collectors.toList());
    }

    public final List<BlockInfo> getBlockInfoAsList() {
        if (this.cacheBlockInfo == null) {
            this.buildBlockInfoCaches();
        }
        return this.cacheBlockInfo;
    }

    public final Map<BlockPos, BlockInfo> getBlockInfoAsMap() {
        if (this.cacheBlockInfoMap == null) {
            this.buildBlockInfoCaches();
        }
        return this.cacheBlockInfoMap;
    }

    public final Map<BlockPos, CompoundTag[]> getCachedEntitiesAsMap() {
        if (this.cacheEntitiesMap == null) {
            this.buildBlockInfoCaches();
        }
        return this.cacheEntitiesMap;
    }

    @Nullable
    public CompoundTag getTileEntityData(BlockPos worldPos, BlockPos structurePos) {
        if (!this.getBlockInfoAsMap().containsKey(structurePos) || !this.getBlockInfoAsMap().get(structurePos).hasTileEntityData()) {
            return null;
        }
        CompoundTag te = this.getBlockInfoAsMap().get(structurePos).getTileEntityData().m_6426_();
        BlockPos tePos = structurePos.m_121955_((Vec3i)worldPos);
        te.m_128405_("x", tePos.m_123341_());
        te.m_128405_("y", tePos.m_123342_());
        te.m_128405_("z", tePos.m_123343_());
        return te;
    }

    @Nullable
    public Item getItem(BlockPos pos) {
        @Nullable BlockInfo info = this.getBlockInfoAsMap().getOrDefault(pos, null);
        if (info == null || info.getState() == null || info.getState().m_60795_() || BlockUtils.isLiquidOnlyBlock(info.getState().m_60734_())) {
            return null;
        }
        ItemStack stack = BlockUtils.getItemStackFromBlockState(info.getState());
        if (!ItemStackUtils.isEmpty(stack)) {
            return stack.m_41720_();
        }
        return null;
    }

    private void buildBlockInfoCaches() {
        this.cacheBlockInfo = new ArrayList<BlockInfo>(this.getVolume());
        this.cacheBlockInfoMap = new HashMap<BlockPos, BlockInfo>(this.getVolume());
        this.cacheEntitiesMap = new HashMap<BlockPos, CompoundTag[]>(this.getEntities().length);
        for (short y = 0; y < this.sizeY; y = (short)(y + 1)) {
            for (short z = 0; z < this.sizeZ; z = (short)(z + 1)) {
                for (short x = 0; x < this.sizeX; x = (short)(x + 1)) {
                    BlockPos tempPos = new BlockPos((int)x, (int)y, (int)z);
                    BlockInfo blockInfo = new BlockInfo(tempPos, this.palette.get(this.structure[y][z][x] & 0xFFFF), this.tileEntities[y][z][x]);
                    this.cacheBlockInfo.add(blockInfo);
                    this.cacheBlockInfoMap.put(tempPos, blockInfo);
                    this.cacheEntitiesMap.put(tempPos, (CompoundTag[])Arrays.stream(this.getEntities()).filter(data -> data != null && Blueprint.isAtPos(data, tempPos)).toArray(CompoundTag[]::new));
                }
            }
        }
    }

    public void setCachePrimaryOffset(BlockPos cachePrimaryOffset) {
        this.cachePrimaryOffset = cachePrimaryOffset;
    }

    public final BlockPos getPrimaryBlockOffset() {
        if (this.cachePrimaryOffset == null) {
            this.cachePrimaryOffset = this.findPrimaryBlockOffset();
        }
        return this.cachePrimaryOffset;
    }

    private BlockPos findPrimaryBlockOffset() {
        List<BlockInfo> list = this.getBlockInfoAsList().stream().filter(blockInfo -> blockInfo.getState().m_60734_() instanceof IAnchorBlock || blockInfo.hasTileEntityData() && blockInfo.getTileEntityData().m_128441_("blueprintDataProvider")).toList();
        if (list.size() != 1) {
            return new BlockPos(this.getSizeX() / 2, 0, this.getSizeZ() / 2);
        }
        return list.get(0).getPos();
    }

    private void cacheReset(boolean resetPrimaryOffset) {
        this.cacheBlockInfo = null;
        if (resetPrimaryOffset) {
            this.cachePrimaryOffset = null;
        }
        this.cacheBlockInfoMap = null;
        this.cacheEntitiesMap = null;
    }

    public void setRotationMirror(RotationMirror rotationMirror, Level level) {
        this.setRotationMirrorRelative(this.rotationMirror.calcDifferenceTowards(rotationMirror), level);
    }

    public void setRotationMirrorRelative(RotationMirror transformBy, Level level) {
        short newSizeX;
        BlockPos primaryOffset = this.getPrimaryBlockOffset();
        short newSizeY = this.sizeY;
        short newSizeZ = switch (transformBy.rotation()) {
            case Rotation.COUNTERCLOCKWISE_90, Rotation.CLOCKWISE_90 -> {
                newSizeX = this.sizeZ;
                yield this.sizeX;
            }
            default -> {
                newSizeX = this.sizeX;
                yield this.sizeZ;
            }
        };
        short[][][] newStructure = new short[newSizeY][newSizeZ][newSizeX];
        CompoundTag[] newEntities = new CompoundTag[this.entities.length];
        CompoundTag[][][] newTileEntities = new CompoundTag[newSizeY][newSizeZ][newSizeX];
        ArrayList<BlockState> palette = new ArrayList<BlockState>();
        for (int i = 0; i < this.palette.size(); ++i) {
            palette.add(i, this.palette.get(i).m_60715_(transformBy.mirror()).m_60717_(transformBy.rotation()));
        }
        BlockPos extremes = transformBy.applyToPos(new BlockPos((int)this.sizeX, (int)this.sizeY, (int)this.sizeZ));
        int minX = extremes.m_123341_() < 0 ? -extremes.m_123341_() - 1 : 0;
        int minY = extremes.m_123342_() < 0 ? -extremes.m_123342_() - 1 : 0;
        int minZ = extremes.m_123343_() < 0 ? -extremes.m_123343_() - 1 : 0;
        this.palette = palette;
        for (short x = 0; x < this.sizeX; x = (short)(x + 1)) {
            for (short y = 0; y < this.sizeY; y = (short)(y + 1)) {
                for (short z = 0; z < this.sizeZ; z = (short)(z + 1)) {
                    short value = this.structure[y][z][x];
                    BlockState state = (BlockState)palette.get(value & 0xFFFF);
                    if (state.m_60734_() == Blocks.f_50454_) continue;
                    BlockPos tempPos = transformBy.applyToPos(new BlockPos((int)x, (int)y, (int)z)).m_7918_(minX, minY, minZ);
                    newStructure[tempPos.m_123342_()][tempPos.m_123343_()][tempPos.m_123341_()] = value;
                    CompoundTag compound = this.tileEntities[y][z][x];
                    if (compound != null) {
                        compound.m_128405_("x", tempPos.m_123341_());
                        compound.m_128405_("y", tempPos.m_123342_());
                        compound.m_128405_("z", tempPos.m_123343_());
                        if (compound.m_128461_("id").equals(ModBlockEntities.TAG_SUBSTITUTION.getId().toString())) {
                            BlockEntityTagSubstitution.ReplacementBlock replacement = new BlockEntityTagSubstitution.ReplacementBlock(compound);
                            replacement = replacement.rotateWithMirror(tempPos, transformBy, level);
                            replacement.write(compound);
                        }
                        if (compound.m_128441_("blueprintDataProvider")) {
                            CompoundTag dataCompound = compound.m_128469_("blueprintDataProvider");
                            Map<BlockPos, List<String>> tagPosMap = IBlueprintDataProviderBE.readTagPosMapFrom(dataCompound);
                            HashMap<BlockPos, List<String>> newTagPosMap = new HashMap<BlockPos, List<String>>();
                            for (Map.Entry<BlockPos, List<String>> entry : tagPosMap.entrySet()) {
                                newTagPosMap.put(transformBy.applyToPos(entry.getKey()), entry.getValue());
                            }
                            IBlueprintDataProviderBE.writeMapToCompound(dataCompound, newTagPosMap);
                            BlockPosUtil.writeToNBT(dataCompound, "corner1", transformBy.applyToPos(BlockPosUtil.readFromNBT(dataCompound, "corner1")));
                            BlockPosUtil.writeToNBT(dataCompound, "corner2", transformBy.applyToPos(BlockPosUtil.readFromNBT(dataCompound, "corner2")));
                        }
                    }
                    newTileEntities[tempPos.m_123342_()][tempPos.m_123343_()][tempPos.m_123341_()] = compound;
                }
            }
        }
        for (int i = 0; i < this.entities.length; ++i) {
            CompoundTag entitiesCompound = this.entities[i];
            if (entitiesCompound == null) continue;
            newEntities[i] = Blueprint.transformEntityInfoWithSettings(entitiesCompound, level, new BlockPos(minX, minY, minZ), transformBy);
        }
        this.setCachePrimaryOffset(transformBy.applyToPos(primaryOffset).m_7918_(minX, minY, minZ));
        this.sizeX = newSizeX;
        this.sizeY = newSizeY;
        this.sizeZ = newSizeZ;
        this.structure = newStructure;
        this.entities = newEntities;
        this.tileEntities = newTileEntities;
        this.rotationMirror = this.rotationMirror.add(transformBy);
        this.cacheReset(false);
    }

    @Deprecated(since="1.20", forRemoval=true)
    public void rotateWithMirror(Rotation localRotation, Mirror localMirror, Level world) {
        this.setRotationMirrorRelative(RotationMirror.of(localRotation, localMirror), world);
    }

    private static CompoundTag transformEntityInfoWithSettings(CompoundTag entityInfo, Level world, BlockPos pos, RotationMirror rotationMirror) {
        Entity finalEntity;
        Optional type = EntityType.m_20637_((CompoundTag)entityInfo);
        if (type.isPresent() && (finalEntity = ((EntityType)type.get()).m_20615_(world)) != null) {
            try {
                Vec3 vec3;
                finalEntity.deserializeNBT(entityInfo);
                if (finalEntity instanceof HangingEntity) {
                    HangingEntity hang = (HangingEntity)finalEntity;
                    vec3 = Vec3.m_82512_((Vec3i)hang.m_31748_());
                } else {
                    vec3 = finalEntity.m_20182_();
                }
                Vec3 entityVec = rotationMirror.applyToPos(vec3).m_82549_(Vec3.m_82528_((Vec3i)pos));
                finalEntity.m_146922_(finalEntity.m_6961_(rotationMirror.mirror()));
                finalEntity.m_146922_(finalEntity.m_7890_(rotationMirror.rotation()));
                finalEntity.m_7678_(entityVec.f_82479_, entityVec.f_82480_, entityVec.f_82481_, finalEntity.m_146908_(), finalEntity.m_146909_());
                return finalEntity.serializeNBT();
            }
            catch (Exception ex) {
                Log.getLogger().error("Entity: " + ((EntityType)type.get()).m_20675_() + " failed to load. ", (Throwable)ex);
                return null;
            }
        }
        return null;
    }

    private int getVolume() {
        return this.sizeX * this.sizeY * this.sizeZ;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.fileName == null ? 0 : this.fileName.hashCode());
        result = 31 * result + (this.filePath == null ? 0 : this.filePath.hashCode());
        result = 31 * result + (this.packName == null ? 0 : this.packName.hashCode());
        result = 31 * result + this.palleteSize;
        result = 31 * result + this.entities.length;
        result = 31 * result + this.tileEntities.length;
        result = 31 * result + this.getVolume();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Blueprint)) {
            return false;
        }
        Blueprint other = (Blueprint)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.fileName, other.fileName) && Objects.equals(this.filePath, other.filePath) && Objects.equals(this.packName, other.packName) && this.palleteSize == other.palleteSize && this.entities.length == other.entities.length && this.tileEntities.length == other.tileEntities.length && this.getVolume() == other.getVolume();
    }

    @Deprecated(since="1.20", forRemoval=true)
    public void setRenderSource(BlockPos pos) {
    }

    public BlueprintPositionInfo getBluePrintPositionInfo(BlockPos pos, boolean includeEntities) {
        return new BlueprintPositionInfo(pos, this.getBlockInfoAsMap().get(pos), includeEntities ? this.getCachedEntitiesAsMap().getOrDefault(pos, new CompoundTag[0]) : new CompoundTag[]{});
    }

    private static boolean isAtPos(CompoundTag entityData, BlockPos pos) {
        ListTag list = entityData.m_128437_(ENTITY_POS, 6);
        int x = (int)list.m_128772_(0);
        int y = (int)list.m_128772_(1);
        int z = (int)list.m_128772_(2);
        return new BlockPos(x, y, z).equals((Object)pos);
    }

    public BlockState getBlockState(BlockPos pos) {
        return this.getBlockInfoAsMap().get(pos).getState();
    }

    @Nullable
    public BlockState getRawBlockState(BlockPos pos) {
        BlockInfo blockInfo = this.getBlockInfoAsMap().get(pos);
        return blockInfo == null ? null : blockInfo.getState();
    }

    public Function<BlockPos, BlockState> getRawBlockStateFunction() {
        return this::getRawBlockState;
    }

    public String toString() {
        return "Blueprint [size=[" + this.sizeX + ", " + this.sizeY + ", " + this.sizeZ + "], fileName=" + this.fileName + ", filePath=" + this.filePath + ", packName=" + this.packName + ", name=" + this.name + ", rotMir=" + this.rotationMirror + "]";
    }
}

