/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.blockentities;

import com.ldtteam.structurize.blockentities.ModBlockEntities;
import com.ldtteam.structurize.blockentities.interfaces.IBlueprintDataProviderBE;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.util.RotationMirror;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockEntityTagSubstitution
extends BlockEntity
implements IBlueprintDataProviderBE {
    private String schematicName = "";
    private BlockPos corner1 = BlockPos.f_121853_;
    private BlockPos corner2 = BlockPos.f_121853_;
    private Map<BlockPos, List<String>> tagPosMap = new HashMap<BlockPos, List<String>>();
    private String packName;
    private String inPackPath;
    private ReplacementBlock replacement = new ReplacementBlock(new CompoundTag());

    public BlockEntityTagSubstitution(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.TAG_SUBSTITUTION.get(), pos, state);
    }

    @Override
    public String getSchematicName() {
        return this.schematicName;
    }

    @Override
    public void setSchematicName(String name) {
        this.schematicName = name;
    }

    @Override
    public Map<BlockPos, List<String>> getPositionedTags() {
        return this.tagPosMap;
    }

    @Override
    public void setPositionedTags(Map<BlockPos, List<String>> positionedTags) {
        this.tagPosMap = positionedTags;
        this.m_6596_();
    }

    @Override
    public Tuple<BlockPos, BlockPos> getSchematicCorners() {
        if (this.corner1 == BlockPos.f_121853_ || this.corner2 == BlockPos.f_121853_) {
            return new Tuple((Object)this.f_58858_, (Object)this.f_58858_);
        }
        return new Tuple((Object)this.corner1, (Object)this.corner2);
    }

    @Override
    public void setSchematicCorners(BlockPos pos1, BlockPos pos2) {
        this.corner1 = pos1;
        this.corner2 = pos2;
    }

    @Override
    public BlockPos getTilePos() {
        return this.f_58858_;
    }

    @NotNull
    public ReplacementBlock getReplacement() {
        return this.replacement;
    }

    public void m_142466_(@NotNull CompoundTag compound) {
        super.m_142466_(compound);
        IBlueprintDataProviderBE.super.readSchematicDataFromNBT(compound);
        this.replacement = new ReplacementBlock(compound);
    }

    public void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        this.writeSchematicDataToNBT(compound);
        this.replacement.write(compound);
    }

    @Override
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Override
    public void setPackName(String packName) {
        this.packName = packName;
    }

    @Override
    public void setBlueprintPath(String inPackPath) {
        this.inPackPath = inPackPath;
    }

    @Override
    public String getPackName() {
        return this.packName;
    }

    @Override
    public String getBlueprintPath() {
        return this.inPackPath;
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        this.m_142466_(packet.m_131708_());
    }

    public static class ReplacementBlock {
        private static final String TAG_REPLACEMENT = "replacement";
        private final BlockState blockstate;
        private final CompoundTag blockentitytag;
        private final ItemStack itemstack;
        @Nullable
        private BlockEntity cachedBlockentity;

        public ReplacementBlock(@NotNull BlockState blockstate, @Nullable BlockEntity blockentity, @NotNull ItemStack itemstack) {
            this.blockstate = blockstate;
            this.blockentitytag = blockentity == null ? new CompoundTag() : blockentity.m_187480_();
            this.itemstack = itemstack;
        }

        public ReplacementBlock(@NotNull BlockState blockstate, @Nullable CompoundTag blockentity, @NotNull ItemStack itemstack) {
            this.blockstate = blockstate;
            this.blockentitytag = blockentity == null ? new CompoundTag() : blockentity.m_6426_();
            this.itemstack = itemstack;
        }

        public ReplacementBlock(@NotNull CompoundTag tag) {
            CompoundTag replacement = tag.m_128469_(TAG_REPLACEMENT);
            this.blockstate = NbtUtils.m_247651_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), (CompoundTag)replacement.m_128469_("b"));
            this.blockentitytag = replacement.m_128469_("e");
            this.itemstack = replacement.m_128441_("i") ? ItemStack.m_41712_((CompoundTag)replacement.m_128469_("i")) : ItemStack.f_41583_;
        }

        public boolean isEmpty() {
            return this.blockstate.m_60795_();
        }

        @NotNull
        public BlockState getBlockState() {
            return this.blockstate;
        }

        @NotNull
        public CompoundTag getBlockEntityTag() {
            return this.blockentitytag;
        }

        @NotNull
        public ItemStack getItemStack() {
            return this.itemstack;
        }

        @Nullable
        public BlockEntity getBlockEntity(BlockPos pos) {
            if (this.cachedBlockentity == null) {
                this.cachedBlockentity = this.createBlockEntity(pos);
            }
            return this.cachedBlockentity;
        }

        @Nullable
        public BlockEntity createBlockEntity(BlockPos pos) {
            return this.blockentitytag.m_128456_() ? null : BlockEntity.m_155241_((BlockPos)pos, (BlockState)this.blockstate, (CompoundTag)this.blockentitytag);
        }

        @NotNull
        public CompoundTag write(@NotNull CompoundTag tag) {
            if (this.isEmpty()) {
                tag.m_128473_(TAG_REPLACEMENT);
            } else {
                CompoundTag replacement = new CompoundTag();
                replacement.m_128365_("b", (Tag)NbtUtils.m_129202_((BlockState)this.blockstate));
                if (this.blockentitytag.m_128456_()) {
                    replacement.m_128473_("e");
                } else {
                    replacement.m_128365_("e", (Tag)this.blockentitytag);
                }
                replacement.m_128365_("i", (Tag)this.itemstack.serializeNBT());
                tag.m_128365_(TAG_REPLACEMENT, (Tag)replacement);
            }
            return tag;
        }

        @NotNull
        public Blueprint createBlueprint() {
            Blueprint blueprint = new Blueprint(1, 1, 1);
            blueprint.addBlockState(BlockPos.f_121853_, this.getBlockState());
            blueprint.getTileEntities()[0][0][0] = this.getBlockEntityTag().m_128456_() ? null : this.getBlockEntityTag().m_6426_();
            return blueprint;
        }

        @Deprecated(since="1.20", forRemoval=true)
        @NotNull
        public ReplacementBlock rotateWithMirror(@NotNull BlockPos pos, @NotNull Rotation localRotation, @NotNull Mirror localMirror, @NotNull Level world) {
            Blueprint blueprint = this.createBlueprint();
            blueprint.rotateWithMirror(localRotation, localMirror, world);
            BlockState newBlockState = blueprint.getBlockState(BlockPos.f_121853_);
            CompoundTag newBlockData = blueprint.getTileEntityData(pos, BlockPos.f_121853_);
            return new ReplacementBlock(newBlockState, newBlockData, this.getItemStack());
        }

        public ReplacementBlock rotateWithMirror(BlockPos pos, RotationMirror rotationMirror, Level level) {
            Blueprint blueprint = this.createBlueprint();
            blueprint.setRotationMirrorRelative(rotationMirror, level);
            BlockState newBlockState = blueprint.getBlockState(BlockPos.f_121853_);
            CompoundTag newBlockData = blueprint.getTileEntityData(pos, BlockPos.f_121853_);
            return new ReplacementBlock(newBlockState, newBlockData, this.getItemStack());
        }
    }
}

