/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.block;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockShape {
    private final VoxelShape shape;

    public static BlockShape create(AABB box) {
        return new BlockShape(box);
    }

    public static BlockShape create(VoxelShape box) {
        return new BlockShape(box);
    }

    public static BlockShape create(double x1, double y1, double z1, double x2, double y2, double z2) {
        return BlockShape.create(Shapes.m_83048_((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2));
    }

    public static BlockShape createBlockShape(double x1, double y1, double z1, double x2, double y2, double z2) {
        return BlockShape.create(Shapes.m_83048_((double)(x1 / 16.0), (double)(y1 / 16.0), (double)(z1 / 16.0), (double)(x2 / 16.0), (double)(y2 / 16.0), (double)(z2 / 16.0)));
    }

    public static BlockShape or(BlockShape shape, BlockShape ... shapes) {
        return new BlockShape(Shapes.m_83124_((VoxelShape)shape.shape, (VoxelShape[])((VoxelShape[])Arrays.stream(shapes).map(s -> s.shape).toArray(VoxelShape[]::new))));
    }

    public static BlockShape fullCube() {
        return new BlockShape(Shapes.m_83144_());
    }

    public static BlockShape empty() {
        return new BlockShape(Shapes.m_83040_());
    }

    public static boolean intersects(BlockShape shape1, BlockShape shape2) {
        return shape1.intersects(shape2);
    }

    public BlockShape(VoxelShape shape) {
        this.shape = shape;
    }

    public BlockShape(AABB shape) {
        this(Shapes.m_83064_((AABB)shape));
    }

    public BlockShape(List<AABB> shapes) {
        this(Shapes.m_83124_((VoxelShape)Shapes.m_83040_(), (VoxelShape[])((VoxelShape[])shapes.stream().map(Shapes::m_83064_).toArray(VoxelShape[]::new))));
    }

    public List<AABB> toBoxes() {
        return this.shape.m_83299_();
    }

    public void forEachBox(Consumer<AABB> action) {
        this.toBoxes().forEach(action);
    }

    public void forEachEdge(LineConsumer action) {
        this.shape.m_83224_(action::apply);
    }

    public void forEachCorner(PointConsumer action) {
        this.shape.m_83286_((x1, y1, z1, x2, y2, z2) -> {
            action.apply(x1, y1, z1);
            action.apply(x2, y1, z1);
            action.apply(x1, y1, z2);
            action.apply(x2, y1, z2);
            action.apply(x1, y2, z1);
            action.apply(x2, y2, z1);
            action.apply(x1, y2, z2);
            action.apply(x2, y2, z2);
        });
    }

    public AABB simplify() {
        return this.shape.m_83215_();
    }

    public double getStart(Direction.Axis axis) {
        return this.shape.m_83288_(axis);
    }

    public double getEnd(Direction.Axis axis) {
        return this.shape.m_83297_(axis);
    }

    public double minX() {
        return this.getStart(Direction.Axis.X);
    }

    public double minY() {
        return this.getStart(Direction.Axis.Y);
    }

    public double minZ() {
        return this.getStart(Direction.Axis.Z);
    }

    public double maxX() {
        return this.getEnd(Direction.Axis.X);
    }

    public double maxY() {
        return this.getEnd(Direction.Axis.Y);
    }

    public double maxZ() {
        return this.getEnd(Direction.Axis.Z);
    }

    public boolean isEmpty() {
        return this.shape.m_83281_();
    }

    public BlockShape offset(double x, double y, double z) {
        return new BlockShape(this.shape.m_83216_(x, y, z));
    }

    public BlockShape offset(BlockPos pos) {
        return new BlockShape(this.shape.m_83216_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()));
    }

    public BlockShape offset(Direction direction) {
        return this.offset(direction.m_122429_(), direction.m_122430_(), direction.m_122431_());
    }

    public boolean intersects(BlockShape shape) {
        if (this.isEmpty() || shape.isEmpty()) {
            return false;
        }
        return this.maxX() > shape.minX() && this.minX() < shape.maxX() && this.maxY() > shape.minY() && this.minY() < shape.maxY() && this.maxZ() > shape.minZ() && this.minZ() < shape.maxZ();
    }

    public BlockShape grow(double amount) {
        return this.transformBoxes(box -> box.m_82400_(amount));
    }

    public BlockShape shrink(double amount) {
        return this.transformBoxes(box -> box.m_82406_(amount));
    }

    public BlockShape flip(Direction.Axis axis) {
        return this.transformBoxes(box -> new AABB(axis == Direction.Axis.X ? 1.0 - box.f_82288_ : box.f_82288_, axis == Direction.Axis.Y ? 1.0 - box.f_82289_ : box.f_82289_, axis == Direction.Axis.Z ? 1.0 - box.f_82290_ : box.f_82290_, axis == Direction.Axis.X ? 1.0 - box.f_82291_ : box.f_82291_, axis == Direction.Axis.Y ? 1.0 - box.f_82292_ : box.f_82292_, axis == Direction.Axis.Z ? 1.0 - box.f_82293_ : box.f_82293_));
    }

    public BlockShape rotate(Direction.Axis axis) {
        if (axis == null) {
            throw new IllegalArgumentException("axis must not be null!");
        }
        if (axis == Direction.Axis.X) {
            return this.transformBoxes(box -> new AABB(box.f_82288_, box.f_82290_, -box.f_82289_ + 1.0, box.f_82291_, box.f_82293_, -box.f_82292_ + 1.0));
        }
        if (axis == Direction.Axis.Y) {
            return this.transformBoxes(box -> new AABB(-box.f_82290_ + 1.0, box.f_82289_, box.f_82288_, -box.f_82293_ + 1.0, box.f_82292_, box.f_82291_));
        }
        if (axis == Direction.Axis.Z) {
            return this.transformBoxes(box -> new AABB(box.f_82289_, -box.f_82288_ + 1.0, box.f_82290_, box.f_82292_, -box.f_82291_ + 1.0, box.f_82293_));
        }
        return null;
    }

    private BlockShape transformBoxes(Function<AABB, AABB> transformer) {
        return new BlockShape(this.toBoxes().stream().map(transformer::apply).collect(Collectors.toList()));
    }

    @Deprecated
    public VoxelShape getUnderlying() {
        return this.shape;
    }

    public static interface LineConsumer {
        public void apply(double var1, double var3, double var5, double var7, double var9, double var11);
    }

    public static interface PointConsumer {
        public void apply(double var1, double var3, double var5);
    }
}

