/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adfinders.finder;

import com.endertech.common.Args;
import com.endertech.minecraft.forge.blocks.BlockStatesSet;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adfinders.AdFinders;
import java.util.Objects;
import net.minecraft.world.level.block.state.BlockState;

public class Target {
    public static final Target EMPTY = new Target(UnitId.EMPTY, ColorARGB.DEFAULT, "");
    private final UnitId id;
    private final ColorARGB color;
    private final String name;

    protected Target(UnitId id, ColorARGB color, String name) {
        this.id = id;
        this.color = color;
        this.name = name;
    }

    public static Target from(UnitId id, ColorARGB color, String name) {
        return new Target(id, color, name);
    }

    public static Target from(String definition) {
        if (definition.isEmpty()) {
            return EMPTY;
        }
        String[] args = Args.split((String)definition);
        try {
            UnitId id = UnitId.from((String)args[0]);
            ColorARGB color = ColorARGB.from((String)args[1]);
            String name = args.length > 2 ? args[2] : id.getRegName();
            return Target.from(id, color, name);
        }
        catch (Exception e) {
            AdFinders.getInstance().getLogger().error("Wrong target info in string: '{}'", (Object)definition);
            return EMPTY;
        }
    }

    public static String definition(UnitId blockId, ColorARGB color, String name) {
        return Args.join((Object[])new Object[]{blockId.toString(), color.getHexARGB(), name});
    }

    public UnitId getId() {
        return this.id;
    }

    public ColorARGB getColor() {
        return this.color;
    }

    public String getName() {
        return this.name;
    }

    public boolean exists() {
        if (this == EMPTY) {
            return false;
        }
        BlockStatesSet states = this.getId().getAllMatchedBlockStates();
        return states != null && !states.isEmpty();
    }

    public boolean matches(BlockState state) {
        return this.getId().matches(state);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Target) {
            Target target = (Target)obj;
            return target.getId().equals((Object)this.getId()) && target.getColor().equals((Object)this.getColor()) && target.getName().equals(this.getName());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getColor(), this.getName());
    }

    public String toString() {
        return Target.class.getSimpleName() + Args.group((Object[])new Object[]{this.getId(), this.getColor(), this.getName()});
    }
}

