/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adfinders.finder;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.client.renderer.GlassMeterRenderer;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.mods.adfinders.finder.Arrows;
import com.endertech.minecraft.mods.adfinders.finder.FinderState;
import com.endertech.minecraft.mods.adfinders.finder.Needle;
import com.endertech.minecraft.mods.adfinders.init.FinderType;
import com.endertech.minecraft.mods.adfinders.items.Finder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class Renderer
extends GlassMeterRenderer {
    public Renderer(BlockEntityRenderDispatcher dispatcher, EntityModelSet modelSet) {
        super(dispatcher, modelSet);
    }

    protected void renderIndicators(ItemStack stack, PoseStack matrix, MultiBufferSource buffer) {
        FinderState state = Finder.findStateFor(stack).orElse(null);
        if (state == null) {
            return;
        }
        matrix.m_85836_();
        matrix.m_252880_(0.5f, 0.5f, 0.5f);
        matrix.m_252880_(0.0f, 0.0f, -0.04f);
        Entity carrier = state.getCarrier();
        Vect3d startPos = ForgeEntity.getCenterPosition((Entity)carrier);
        float rotationYaw = carrier.m_146908_();
        if (carrier instanceof LivingEntity) {
            Minecraft mc = Minecraft.m_91087_();
            if (carrier != mc.f_91074_ || mc.f_91066_.m_92176_() != CameraType.FIRST_PERSON) {
                rotationYaw = ((LivingEntity)carrier).f_20883_;
            }
        }
        FinderType finder = state.getFinder().getType();
        VertexConsumer builder = buffer.m_6299_(this.getRenderType());
        float offset = 0.0f;
        for (Arrows.Arrow arrow : state.getArrows().values()) {
            if (arrow == null) continue;
            matrix.m_252880_(0.0f, 0.0f, offset);
            arrow.draw(builder, matrix, ((Double)finder.arrowSize.get()).floatValue());
            matrix.m_252880_(0.0f, 0.0f, -offset);
        }
        offset = 0.001f;
        matrix.m_252880_(0.0f, 0.0f, offset);
        for (Needle needle : state.getNeedles()) {
            CommonMath.Angle angle = needle.getAngle(startPos, rotationYaw);
            matrix.m_252880_(0.0f, 0.0f, offset);
            needle.draw(builder, matrix, angle, ((Double)finder.needleLength.get()).floatValue(), ((Double)finder.needleWidth.get()).floatValue());
            matrix.m_252880_(0.0f, 0.0f, -offset);
            offset += 0.001f;
        }
        matrix.m_85849_();
    }
}

