/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adfinders.finder;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.mods.adfinders.finder.Indicator;
import com.endertech.minecraft.mods.adfinders.finder.TargetLocation;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

public enum Arrows {
    OVERHEAD(0.0, 1),
    UNDERFOOT(180.0, -1);

    private final CommonMath.Angle angle;
    public final int step;

    private Arrows(double degrees, int step) {
        this.angle = CommonMath.Angle.fromDegrees((double)degrees);
        this.step = step;
    }

    public Arrow create(ColorARGB color, TargetLocation location) {
        return new Arrow(color, location, this.angle);
    }

    static class Arrow
    extends Indicator {
        private final CommonMath.Angle angle;

        public Arrow(ColorARGB color, TargetLocation location, CommonMath.Angle angle) {
            super(color, location);
            this.angle = angle;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void draw(VertexConsumer builder, PoseStack matrix, float size) {
            matrix.m_85836_();
            matrix.m_252781_(new Quaternionf().rotateZ((float)this.angle.getRadians()));
            this.addVertex(builder, matrix, 0.0f, size, 0.5f, 0.0f);
            this.addVertex(builder, matrix, -size, size / 2.0f, 0.0f, 1.0f);
            this.addVertex(builder, matrix, size, size / 2.0f, 1.0f, 1.0f);
            this.addVertex(builder, matrix, size, size / 2.0f, 1.0f, 1.0f);
            matrix.m_85849_();
        }
    }
}

