/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.solcarrot.tracking;

import com.cazsius.solcarrot.SOLCarrotConfig;
import com.cazsius.solcarrot.tracking.FoodList;
import com.cazsius.solcarrot.tracking.ProgressInfo;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="solcarrot")
public final class MaxHealthHandler {
    private static final boolean HAS_FIRST_AID = ModList.get().isLoaded("firstaid");
    private static final UUID MILESTONE_HEALTH_MODIFIER_ID = UUID.fromString("b20d3436-0d39-4868-96ab-d0a4856e68c6");

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        MaxHealthHandler.updateFoodHPModifier(event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        AttributeModifier prevModifier = MaxHealthHandler.getHealthModifier(event.getOriginal());
        if (prevModifier == null) {
            return;
        }
        MaxHealthHandler.updateHealthModifier(event.getEntity(), prevModifier);
    }

    public static boolean updateFoodHPModifier(Player player) {
        if (player.m_9236_().f_46443_) {
            return false;
        }
        AttributeModifier prevModifier = MaxHealthHandler.getHealthModifier(player);
        int healthPenalty = 2 * (SOLCarrotConfig.getBaseHearts() - 10);
        ProgressInfo progressInfo = FoodList.get(player).getProgressInfo();
        int milestonesAchieved = progressInfo.milestonesAchieved();
        int addedHealthFromFood = milestonesAchieved * 2 * SOLCarrotConfig.getHeartsPerMilestone();
        double totalHealthModifier = healthPenalty + addedHealthFromFood;
        boolean hasChanged = prevModifier == null || prevModifier.m_22218_() != totalHealthModifier;
        AttributeModifier modifier = new AttributeModifier(MILESTONE_HEALTH_MODIFIER_ID, "Health Gained from Trying New Foods", totalHealthModifier, AttributeModifier.Operation.ADDITION);
        MaxHealthHandler.updateHealthModifier(player, modifier);
        return hasChanged;
    }

    @Nullable
    private static AttributeModifier getHealthModifier(Player player) {
        return MaxHealthHandler.maxHealthAttribute(player).m_22111_(MILESTONE_HEALTH_MODIFIER_ID);
    }

    private static void updateHealthModifier(Player player, AttributeModifier modifier) {
        float oldMax = player.m_21233_();
        AttributeInstance attribute = MaxHealthHandler.maxHealthAttribute(player);
        attribute.m_22130_(modifier);
        attribute.m_22125_(modifier);
        float newHealth = player.m_21223_() * player.m_21233_() / oldMax;
        if (!HAS_FIRST_AID) {
            player.m_21153_(1.0f);
        }
        player.m_21153_(newHealth);
    }

    private static AttributeInstance maxHealthAttribute(Player player) {
        return Objects.requireNonNull(player.m_21051_(Attributes.f_22276_));
    }

    private MaxHealthHandler() {
    }
}

