/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.solcarrot.tracking;

import com.cazsius.solcarrot.SOLCarrotConfig;
import com.cazsius.solcarrot.lib.Localization;
import com.cazsius.solcarrot.tracking.CapabilityHandler;
import com.cazsius.solcarrot.tracking.FoodList;
import com.cazsius.solcarrot.tracking.MaxHealthHandler;
import com.cazsius.solcarrot.tracking.ProgressInfo;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.GameType;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="solcarrot")
public final class FoodTracker {
    @SubscribeEvent
    public static void onFoodEaten(LivingEntityUseItemEvent.Finish event) {
        boolean isInSurvival;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.m_9236_().f_46443_) {
            return;
        }
        ServerLevel world = (ServerLevel)player.m_9236_();
        ServerPlayer serverPlayer = (ServerPlayer)player;
        boolean bl = isInSurvival = serverPlayer.f_8941_.m_9290_() == GameType.SURVIVAL;
        if (SOLCarrotConfig.limitProgressionToSurvival() && !isInSurvival) {
            return;
        }
        Item usedItem = event.getItem().m_41720_();
        if (!usedItem.m_41472_()) {
            return;
        }
        FoodList foodList = FoodList.get(player);
        boolean hasTriedNewFood = foodList.addFood(usedItem);
        boolean newMilestoneReached = MaxHealthHandler.updateFoodHPModifier(player);
        CapabilityHandler.syncFoodList(player);
        ProgressInfo progressInfo = foodList.getProgressInfo();
        if (newMilestoneReached) {
            if (SOLCarrotConfig.shouldPlayMilestoneSounds()) {
                world.m_5594_(null, player.m_20183_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            if (SOLCarrotConfig.shouldSpawnMilestoneParticles()) {
                FoodTracker.spawnParticles(world, player, (ParticleOptions)ParticleTypes.f_123750_, 12);
                if (progressInfo.hasReachedMax()) {
                    FoodTracker.spawnParticles(world, player, (ParticleOptions)ParticleTypes.f_123748_, 16);
                }
            }
            MutableComponent heartsDescription = Localization.localizedQuantityComponent("message", "hearts", SOLCarrotConfig.getHeartsPerMilestone());
            if (SOLCarrotConfig.shouldShowProgressAboveHotbar()) {
                String messageKey = progressInfo.hasReachedMax() ? "finished.hotbar" : "milestone_achieved";
                player.m_5661_((Component)Localization.localizedComponent("message", messageKey, heartsDescription), true);
            } else {
                FoodTracker.showChatMessage(player, ChatFormatting.DARK_AQUA, (Component)Localization.localizedComponent("message", "milestone_achieved", heartsDescription));
                if (progressInfo.hasReachedMax()) {
                    FoodTracker.showChatMessage(player, ChatFormatting.GOLD, (Component)Localization.localizedComponent("message", "finished.chat", new Object[0]));
                }
            }
        } else if (hasTriedNewFood && SOLCarrotConfig.shouldSpawnIntermediateParticles()) {
            FoodTracker.spawnParticles(world, player, (ParticleOptions)ParticleTypes.f_123810_, 12);
        }
    }

    private static void spawnParticles(ServerLevel world, Player player, ParticleOptions type, int count) {
        world.m_8767_(type, player.m_20185_(), player.m_20186_() + (double)player.m_20192_(), player.m_20189_(), count, 0.5, 0.5, 0.5, 0.0);
    }

    private static void showChatMessage(Player player, ChatFormatting color, Component message) {
        MutableComponent component = Localization.localizedComponent("message", "chat_wrapper", message).m_130940_(color);
        player.m_5661_((Component)component, false);
    }

    private FoodTracker() {
    }
}

