/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration.forge.quark;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.common.block.blocks.JarBlock;
import net.mehvahdjukaar.supplementaries.integration.CompatObjects;
import net.mehvahdjukaar.supplementaries.integration.forge.QuarkCompatImpl;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.addons.oddities.block.TinyPotatoBlock;
import vazkii.quark.addons.oddities.block.be.TinyPotatoBlockEntity;
import vazkii.quark.addons.oddities.module.TinyPotatoModule;
import vazkii.quark.base.module.ModuleLoader;

public class TaterInAJarBlock
extends TinyPotatoBlock {
    private static final VoxelShape SHAPE = JarBlock.SHAPE;

    public TaterInAJarBlock() {
        super(ModuleLoader.INSTANCE.getModuleInstance(TinyPotatoModule.class));
        try {
            Field f2 = ObfuscationReflectionHelper.findField(RegistryHelper.class, (String)"modData");
            f2.setAccessible(true);
            Map data = (Map)f2.get(null);
            data.remove("supplementaries");
            data.remove("suppsquared");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        return ModSounds.JAR;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation direction) {
        return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)direction.m_55954_((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)));
    }

    @NotNull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @NotNull
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new Tile(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof Tile) {
            Tile tile = (Tile)blockEntity;
            tile.interact(player, hand, player.m_21120_(hand), hit.m_82434_());
            if (world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                AABB box = SHAPE.m_83215_();
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123792_, (double)pos.m_123341_() + box.f_82288_ + Math.random() * (box.f_82291_ - box.f_82288_), (double)pos.m_123342_() + box.f_82292_ - 1.0, (double)pos.m_123343_() + box.f_82290_ + Math.random() * (box.f_82293_ - box.f_82290_), 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        Tile te;
        ItemStack stack = new ItemStack((ItemLike)this);
        Object object = builder.m_287159_(LootContextParams.f_81462_);
        if (object instanceof Tile && (te = (Tile)((Object)object)).m_8077_()) {
            stack.m_41714_(te.m_7770_());
        }
        return Collections.singletonList(stack);
    }

    @NotNull
    public BlockState m_5573_(BlockPlaceContext ctx) {
        Level level = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        Player player = ctx.m_43723_();
        if (player != null && !player.m_6144_()) {
            FluidState fluidState = level.m_6425_(pos);
            Item i = ModRegistry.JAR_ITEM.get();
            if (!level.f_46443_) {
                Utils.swapItemNBT((Player)player, (InteractionHand)ctx.m_43724_(), (ItemStack)ctx.m_43722_(), (ItemStack)new ItemStack((ItemLike)i));
            }
            BlockState state = (BlockState)CompatObjects.TATER.get().m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
            return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)ctx.m_8125_().m_122424_());
        }
        return super.m_5573_(ctx);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return Utils.getTicker(pBlockEntityType, QuarkCompatImpl.TATER_IN_A_JAR_TILE.get(), TinyPotatoBlockEntity::commonTick);
    }

    public static class Tile
    extends TinyPotatoBlockEntity {
        public Tile(BlockPos pos, BlockState state) {
            super(pos, state);
            this.angry = true;
        }

        public BlockEntityType<Tile> m_58903_() {
            return QuarkCompatImpl.TATER_IN_A_JAR_TILE.get();
        }
    }
}

