/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block;

import net.mehvahdjukaar.supplementaries.common.items.KeyItem;
import net.mehvahdjukaar.supplementaries.common.utils.ItemsUtil;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public interface IKeyLockable {
    public static final int MAX_ITEM_NAME_LEN = 50;

    public void setPassword(String var1);

    public String getPassword();

    public void clearPassword();

    default public void onPasswordCleared(Player player, BlockPos pos) {
        player.m_5661_((Component)Component.m_237115_((String)"message.supplementaries.safe.cleared"), true);
        player.m_9236_().m_5594_(null, pos, SoundEvents.f_12012_, SoundSource.BLOCKS, 0.5f, 1.5f);
    }

    default public boolean shouldShowPassword() {
        return this.getPassword().length() <= 50;
    }

    default public void onKeyAssigned(Level level, BlockPos pos, Player player, String newKey) {
        MutableComponent message = this.shouldShowPassword() ? Component.m_237110_((String)"message.supplementaries.safe.assigned_key", (Object[])new Object[]{newKey}) : Component.m_237115_((String)"message.supplementaries.safe.assigned_key_generic");
        player.m_5661_((Component)message, true);
        level.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_12012_, SoundSource.BLOCKS, 0.5f, 1.5f);
    }

    default public KeyStatus getKeyStatus(ItemStack key) {
        return IKeyLockable.getKeyStatus(key, this.getPassword());
    }

    public static KeyStatus getKeyStatus(ItemStack key, String password) {
        String correct = IKeyLockable.getKeyPassword(key);
        if (correct != null) {
            if (correct.equals(password)) {
                return KeyStatus.CORRECT_KEY;
            }
            return KeyStatus.INCORRECT_KEY;
        }
        return KeyStatus.NO_KEY;
    }

    @Nullable
    public static String getKeyPassword(ItemStack key) {
        Item item = key.m_41720_();
        if (item instanceof KeyItem) {
            KeyItem k = (KeyItem)item;
            return k.getPassword(key);
        }
        if (key.m_204117_(ModTags.KEY)) {
            return ModRegistry.KEY_ITEM.get().getPassword(key);
        }
        return null;
    }

    default public boolean testIfHasCorrectKey(Player player, String lockPassword, boolean feedbackMessage, @Nullable String translName) {
        KeyStatus key = ItemsUtil.hasKeyInInventory(player, lockPassword);
        if (key == KeyStatus.INCORRECT_KEY) {
            if (feedbackMessage) {
                player.m_5661_((Component)Component.m_237115_((String)"message.supplementaries.safe.incorrect_key"), true);
            }
            return false;
        }
        if (key == KeyStatus.CORRECT_KEY) {
            return true;
        }
        if (feedbackMessage) {
            player.m_5661_((Component)Component.m_237115_((String)("message.supplementaries." + translName + ".locked")), true);
        }
        return false;
    }

    public static enum KeyStatus {
        CORRECT_KEY,
        INCORRECT_KEY,
        NO_KEY;


        public boolean isCorrect() {
            return this == CORRECT_KEY;
        }
    }
}

