/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.screens;

import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.SuppClientPlatformStuff;
import net.mehvahdjukaar.supplementaries.client.screens.widgets.ISlider;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SpeakerBlockTile;
import net.mehvahdjukaar.supplementaries.common.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.common.network.ServerBoundSetSpeakerBlockPacket;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class SpeakerBlockScreen
extends Screen {
    private static final Component NARRATOR_TEXT = Component.m_237115_((String)"gui.supplementaries.speaker_block.chat_message");
    private static final Component CHAT_TEXT = Component.m_237115_((String)"gui.supplementaries.speaker_block.narrator_message");
    private static final Component ACTION_BAR_TEXT = Component.m_237115_((String)"gui.supplementaries.speaker_block.action_bar_message");
    private static final Component TITLE_TEXT = Component.m_237115_((String)"gui.supplementaries.speaker_block.title_message");
    private static final Component DISTANCE_BLOCKS = Component.m_237115_((String)"gui.supplementaries.speaker_block.blocks");
    private static final Component VOLUME_TEXT = Component.m_237115_((String)"gui.supplementaries.speaker_block.volume");
    private static final Component EDIT = Component.m_237115_((String)"gui.supplementaries.speaker_block.edit");
    private EditBox editBox;
    private final SpeakerBlockTile tileSpeaker;
    private SpeakerBlockTile.Mode mode;
    private Button modeBtn;
    private ISlider volumeSlider;

    public SpeakerBlockScreen(SpeakerBlockTile te) {
        super(EDIT);
        this.tileSpeaker = te;
    }

    public static void open(SpeakerBlockTile te) {
        Minecraft.m_91087_().m_91152_((Screen)new SpeakerBlockScreen(te));
    }

    public void m_86600_() {
        this.editBox.m_94120_();
    }

    private void updateMode() {
        switch (this.mode) {
            default: {
                this.modeBtn.m_93666_(CHAT_TEXT);
                break;
            }
            case NARRATOR: {
                this.modeBtn.m_93666_(NARRATOR_TEXT);
                break;
            }
            case STATUS_MESSAGE: {
                this.modeBtn.m_93666_(ACTION_BAR_TEXT);
                break;
            }
            case TITLE: {
                this.modeBtn.m_93666_(TITLE_TEXT);
            }
        }
    }

    private void toggleMode() {
        this.mode = SpeakerBlockTile.Mode.values()[(this.mode.ordinal() + 1) % SpeakerBlockTile.Mode.values().length];
        if (!CommonConfigs.Redstone.SPEAKER_NARRATOR.get().booleanValue() && this.mode == SpeakerBlockTile.Mode.NARRATOR) {
            this.mode = SpeakerBlockTile.Mode.CHAT;
        }
    }

    public void m_7856_() {
        assert (this.f_96541_ != null);
        int range = CommonConfigs.Redstone.SPEAKER_RANGE.get();
        this.mode = this.tileSpeaker.getMode();
        String message = this.tileSpeaker.getMessage(Minecraft.m_91087_().m_167974_()).getString();
        double initialVolume = this.tileSpeaker.getVolume();
        this.volumeSlider = SuppClientPlatformStuff.createSlider(this.f_96543_ / 2 - 75, this.f_96544_ / 4 + 80, 150, 20, VOLUME_TEXT, DISTANCE_BLOCKS, 1.0, range, initialVolume, 1.0, 1, true);
        this.m_142416_(this.volumeSlider);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> this.onDone()).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ / 4 + 120, 200, 20).m_253136_());
        this.modeBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)CHAT_TEXT, button -> {
            this.toggleMode();
            this.updateMode();
        }).m_252987_(this.f_96543_ / 2 - 75, this.f_96544_ / 4 + 50, 150, 20).m_253136_());
        if (!CommonConfigs.Redstone.SPEAKER_NARRATOR.get().booleanValue()) {
            this.modeBtn.f_93623_ = false;
        }
        this.updateMode();
        this.editBox = new EditBox(this.f_96547_, this.f_96543_ / 2 - 100, this.f_96544_ / 4 + 10, 200, 20, this.f_96539_){

            protected MutableComponent m_5646_() {
                return super.m_5646_();
            }
        };
        this.editBox.m_94144_(message);
        this.editBox.m_94199_(32);
        this.m_142416_((GuiEventListener)this.editBox);
        this.m_264313_((GuiEventListener)this.editBox);
        this.editBox.m_93692_(true);
    }

    public void m_7861_() {
        NetworkHandler.CHANNEL.sendToServer((Message)new ServerBoundSetSpeakerBlockPacket(this.tileSpeaker.m_58899_(), this.editBox.m_94155_(), this.mode, this.volumeSlider.getValue()));
    }

    private void onDone() {
        this.tileSpeaker.m_6596_();
        this.f_96541_.m_91152_(null);
    }

    public void m_7379_() {
        this.onDone();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode != 257 && keyCode != 335) {
            return false;
        }
        this.onDone();
        return true;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.volumeSlider == this.m_7222_() && button == 0) {
            this.volumeSlider.onRelease(mouseX, mouseY);
            this.m_7522_((GuiEventListener)this.editBox);
            this.editBox.m_93692_(true);
        }
        return true;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 40, 0xFFFFFF);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }
}

