/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.chunkymcchunkface.datagen;

import com.mrbysco.chunkymcchunkface.datagen.assets.ChunkyItemModelProvider;
import com.mrbysco.chunkymcchunkface.datagen.assets.ChunkyLanguageProvider;
import com.mrbysco.chunkymcchunkface.datagen.assets.ChunkyStateProvider;
import com.mrbysco.chunkymcchunkface.datagen.data.ChunkyBlockTagProvider;
import com.mrbysco.chunkymcchunkface.datagen.data.ChunkyItemTagProvider;
import com.mrbysco.chunkymcchunkface.datagen.data.ChunkyLootProvider;
import com.mrbysco.chunkymcchunkface.datagen.data.ChunkyRecipeProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ChunkyDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.addProvider(true, (DataProvider)new ChunkyRecipeProvider(packOutput));
            generator.addProvider(true, (DataProvider)new ChunkyLootProvider(packOutput));
            ChunkyBlockTagProvider provider = new ChunkyBlockTagProvider(packOutput, lookupProvider, helper);
            generator.addProvider(true, (DataProvider)provider);
            generator.addProvider(true, (DataProvider)new ChunkyItemTagProvider(packOutput, lookupProvider, (TagsProvider<Block>)provider, helper));
        }
        if (event.includeClient()) {
            generator.addProvider(true, (DataProvider)new ChunkyLanguageProvider(packOutput));
            generator.addProvider(true, (DataProvider)new ChunkyStateProvider(packOutput, helper));
            generator.addProvider(true, (DataProvider)new ChunkyItemModelProvider(packOutput, helper));
        }
    }
}

