/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.chunkymcchunkface.blocks.entity;

import com.mrbysco.chunkymcchunkface.ChunkyMcChunkFace;
import com.mrbysco.chunkymcchunkface.blocks.ChunkLoaderBlock;
import com.mrbysco.chunkymcchunkface.config.ChunkyConfig;
import com.mrbysco.chunkymcchunkface.data.ChunkData;
import com.mrbysco.chunkymcchunkface.registry.ChunkyRegistry;
import com.mrbysco.chunkymcchunkface.registry.ChunkyTags;
import com.mrbysco.chunkymcchunkface.util.ChunkyHelper;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class ChunkLoaderBlockEntity
extends BlockEntity {
    private static final int MAX_TIERS = 4;
    private int tier;
    private final List<UUID> playerCache = new ArrayList<UUID>();
    protected final LongSet loadedChunks = new LongOpenHashSet();
    private int cooldown = 0;

    public ChunkLoaderBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ChunkyRegistry.CHUNK_LOADER_ENTITY.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, ChunkLoaderBlockEntity blockEntity) {
        int tier;
        if (level.m_46467_() % 80L == 0L && (tier = ChunkLoaderBlockEntity.getUpdatedTier(level, pos)) != blockEntity.tier) {
            ChunkyMcChunkFace.LOGGER.info("ChunkLoader at {} has been updated from tier {} to tier {}", new Object[]{pos, blockEntity.tier, tier});
            blockEntity.tier = tier;
            blockEntity.refreshChunks();
        }
        if (blockEntity.isEnabled() && level.m_46467_() % 20L == 0L) {
            if (blockEntity.playerCache.isEmpty()) {
                blockEntity.disableChunkLoaderState();
                blockEntity.disableChunkLoader();
            } else {
                boolean isPlayerOnline = false;
                long latestTime = 0L;
                for (UUID uuid : blockEntity.playerCache) {
                    if (level.m_46003_(uuid) != null) {
                        isPlayerOnline = true;
                    }
                    Player player = level.m_46003_(uuid);
                    ChunkData data = ChunkData.get(level);
                    long lastSeen = player != null ? level.m_46467_() : data.getLastSeen(uuid);
                    if (lastSeen <= latestTime) continue;
                    latestTime = lastSeen;
                }
                if (!isPlayerOnline) {
                    int configuredTicks = (Integer)ChunkyConfig.COMMON.offlineTime.get();
                    if (latestTime > 0L && level.m_46467_() - latestTime > (long)configuredTicks) {
                        ChunkyMcChunkFace.LOGGER.info("ChunkLoader at {} has been disabled due to inactivity of the players {}", (Object)pos, (Object)ChunkyHelper.formatTicks(configuredTicks));
                        blockEntity.disableChunkLoaderState();
                        blockEntity.disableChunkLoader();
                    }
                } else if (level.m_46467_() % 100L == 0L) {
                    blockEntity.loadChunks();
                }
            }
        }
        if (blockEntity.cooldown > 0) {
            --blockEntity.cooldown;
        }
    }

    public void disableChunkLoader() {
        this.clearPlayerCache();
        this.unloadChunks();
    }

    public void disableChunkLoaderState() {
        this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)ChunkLoaderBlock.ENABLED, (Comparable)Boolean.valueOf(false)));
    }

    public void clearPlayerCache() {
        this.playerCache.clear();
    }

    public void enableChunkLoading() {
        if (this.cooldown == 0) {
            this.loadChunks();
            this.cooldown = 20;
        }
    }

    public void unloadChunks() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            long pos2;
            ChunkyMcChunkFace.LOGGER.debug("Attempting to remove {} chunk tickets. pos: {} world: {}", new Object[]{this.loadedChunks.size(), this.f_58858_.m_123344_(), this.f_58857_.m_46472_().m_135782_()});
            ServerLevel serverLevel = (ServerLevel)this.f_58857_;
            ChunkData data = ChunkData.get(this.f_58857_);
            long centerChunk = new ChunkPos(this.f_58858_).m_45588_();
            int range = this.getRange(this.tier);
            LongSet chunkPosList = ChunkyHelper.generateChunkPosList(centerChunk, range);
            List<ChunkPos> loaderList = data.getActiveChunkLoaderChunks(serverLevel);
            loaderList.forEach(pos -> {
                long longPos = pos.m_45588_();
                chunkPosList.remove(longPos);
                this.loadedChunks.remove(longPos);
            });
            LongIterator longIterator = chunkPosList.iterator();
            while (longIterator.hasNext()) {
                pos2 = (Long)longIterator.next();
                this.loadedChunks.remove(pos2);
                ChunkyHelper.releaseChunkTicket(serverLevel, this.f_58858_, pos2);
            }
            longIterator = this.loadedChunks.iterator();
            while (longIterator.hasNext()) {
                pos2 = (Long)longIterator.next();
                ChunkyHelper.releaseChunkTicket(serverLevel, this.f_58858_, pos2);
            }
            this.loadedChunks.clear();
            this.refreshClient();
            ChunkyHelper.releaseChunkTicket(serverLevel, this.f_58858_, centerChunk);
        }
    }

    public void loadChunks(int tier) {
        if (this.isEnabled() && this.f_58857_ != null && !this.f_58857_.f_46443_) {
            ServerLevel serverLevel = (ServerLevel)this.f_58857_;
            long centerChunk = new ChunkPos(this.f_58858_).m_45588_();
            int range = this.getRange(tier);
            LongSet chunkPosList = ChunkyHelper.generateChunkPosList(centerChunk, range);
            LongIterator longIterator = chunkPosList.iterator();
            while (longIterator.hasNext()) {
                long pos = (Long)longIterator.next();
                this.loadedChunks.add(pos);
                ChunkyHelper.registerChunkTicket(serverLevel, this.f_58858_, pos);
            }
            this.refreshClient();
        }
    }

    public void loadChunks() {
        this.loadChunks(this.getTier());
    }

    public void refreshChunks() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && this.isEnabled()) {
            this.unloadChunks();
            this.loadChunks(this.getTier());
        }
    }

    private static int getUpdatedTier(Level level, BlockPos pos) {
        int k;
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        int i = 0;
        int j = 1;
        while (j <= 4 && (k = y - j) >= level.m_141937_()) {
            boolean flag = true;
            block1: for (int l = x - j; l <= x + j && flag; ++l) {
                for (int i1 = z - j; i1 <= z + j; ++i1) {
                    if (level.m_8055_(new BlockPos(l, k, i1)).m_204336_(ChunkyTags.UPGRADE_BLOCKS)) continue;
                    flag = false;
                    continue block1;
                }
            }
            if (!flag) break;
            i = j++;
        }
        return i;
    }

    public int getRange(int tier) {
        return switch (tier) {
            default -> (Integer)ChunkyConfig.COMMON.baseRange.get();
            case 1 -> (Integer)ChunkyConfig.COMMON.tier1Range.get();
            case 2 -> (Integer)ChunkyConfig.COMMON.tier2Range.get();
            case 3 -> (Integer)ChunkyConfig.COMMON.tier3Range.get();
            case 4 -> (Integer)ChunkyConfig.COMMON.tier4Range.get();
        };
    }

    public int getRange() {
        return this.getRange(this.getTier());
    }

    public int getTier() {
        return this.tier;
    }

    public boolean isEnabled() {
        return this.m_58900_().m_60713_((Block)ChunkyRegistry.CHUNK_LOADER.get()) && (Boolean)this.m_58900_().m_61143_((Property)ChunkLoaderBlock.ENABLED) != false;
    }

    public void addPlayer(UUID uuid) {
        if (!this.playerCache.contains(uuid)) {
            this.playerCache.add(uuid);
            this.refreshClient();
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.tier = tag.m_128451_("Levels");
        this.cooldown = tag.m_128451_("Cooldown");
        if (!this.loadedChunks.isEmpty()) {
            if (this.m_58898_()) {
                this.unloadChunks();
            } else {
                this.loadedChunks.clear();
            }
        }
        for (long chunk : tag.m_128467_("loadedChunks")) {
            this.loadedChunks.add(chunk);
        }
        ListTag playerCacheTag = tag.m_128437_("playerCache", 10);
        for (int j = 0; j < playerCacheTag.size(); ++j) {
            CompoundTag cacheTag = playerCacheTag.m_128728_(j);
            this.playerCache.add(cacheTag.m_128342_("UUID"));
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("Levels", this.tier);
        tag.m_128405_("Cooldown", this.cooldown);
        tag.m_128388_("loadedChunks", this.loadedChunks.toLongArray());
        ListTag playerCacheTag = new ListTag();
        for (UUID uuid : this.playerCache) {
            CompoundTag cacheTag = new CompoundTag();
            cacheTag.m_128362_("UUID", uuid);
            playerCacheTag.add((Object)cacheTag);
        }
        tag.m_128365_("playerCache", (Tag)playerCacheTag);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
        BlockState state = this.f_58857_.m_8055_(this.m_58899_());
        this.f_58857_.m_7260_(this.m_58899_(), state, state, 3);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return nbt;
    }

    public CompoundTag getPersistentData() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return nbt;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    private void refreshClient() {
        this.m_6596_();
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        this.f_58857_.m_7260_(this.f_58858_, state, state, 2);
    }

    public AABB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }
}

