/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.lex.cfd;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.lex.cfd.CobbleForDays;
import net.minecraftforge.lex.cfd.Config;

public class CobbleGenTile
extends BlockEntity {
    private final ConfigCache config;
    private final LazyOptional<IItemHandler> inventory = LazyOptional.of(() -> new Inventory());
    private LazyOptional<IItemHandler> cache = null;
    private int count = 0;
    private int timer = 20;
    private int configTimer = 200;

    public CobbleGenTile(Config.Server.Tier tier, BlockEntityType<?> tileType, BlockPos blockPos, BlockState blockState) {
        super(tileType, blockPos, blockState);
        this.config = new ConfigCache(tier);
        this.timer = (Integer)tier.interval.get();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (!this.f_58859_ && cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventory.cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_7651_() {
        this.inventory.invalidate();
        super.m_7651_();
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.count = nbt.m_128441_("count") ? nbt.m_128451_("count") : 0;
        this.timer = nbt.m_128441_("timer") ? nbt.m_128451_("timer") : 0;
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("count", this.count);
        nbt.m_128405_("timer", this.timer);
    }

    public void updateCache() {
        BlockEntity tileEntity;
        BlockEntity blockEntity = tileEntity = this.f_58857_ != null && this.f_58857_.m_46749_(this.f_58858_.m_7494_()) ? this.f_58857_.m_7702_(this.f_58858_.m_7494_()) : null;
        if (tileEntity != null) {
            LazyOptional lazyOptional = tileEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.DOWN);
            if (lazyOptional.isPresent()) {
                if (this.cache != lazyOptional) {
                    this.cache = lazyOptional;
                    this.cache.addListener(l -> this.updateCache());
                }
            } else {
                this.cache = LazyOptional.empty();
            }
        } else {
            this.cache = LazyOptional.empty();
        }
    }

    private LazyOptional<IItemHandler> getCache() {
        if (this.cache == null) {
            this.updateCache();
        }
        return this.cache;
    }

    private void push() {
        ItemStack stack = new ItemStack((ItemLike)Items.f_42594_, this.count);
        ItemStack result = this.getCache().map(iItemHandler -> ItemHandlerHelper.insertItemStacked((IItemHandler)iItemHandler, (ItemStack)stack, (boolean)false)).orElse(stack);
        if (result.m_41619_()) {
            this.count = 0;
            this.m_6596_();
        } else if (result.m_41613_() != this.count) {
            this.count = result.m_41613_();
            this.m_6596_();
        }
    }

    public static CobbleGenTile create(int tier, BlockPos blockPos, BlockState blockState) {
        switch (tier) {
            case 1: {
                return new CobbleGenTile(Config.SERVER.tier1, (BlockEntityType)CobbleForDays.TIER1_TILE.get(), blockPos, blockState);
            }
            case 2: {
                return new CobbleGenTile(Config.SERVER.tier2, (BlockEntityType)CobbleForDays.TIER2_TILE.get(), blockPos, blockState);
            }
            case 3: {
                return new CobbleGenTile(Config.SERVER.tier3, (BlockEntityType)CobbleForDays.TIER3_TILE.get(), blockPos, blockState);
            }
            case 4: {
                return new CobbleGenTile(Config.SERVER.tier4, (BlockEntityType)CobbleForDays.TIER4_TILE.get(), blockPos, blockState);
            }
            case 5: {
                return new CobbleGenTile(Config.SERVER.tier5, (BlockEntityType)CobbleForDays.TIER5_TILE.get(), blockPos, blockState);
            }
        }
        throw new IllegalArgumentException("Unknown Tier: " + tier);
    }

    public static BlockEntityType.BlockEntitySupplier<CobbleGenTile> createSupplier(int tier) {
        return switch (tier) {
            case 1 -> (blockPos, blockState) -> new CobbleGenTile(Config.SERVER.tier1, (BlockEntityType)CobbleForDays.TIER1_TILE.get(), blockPos, blockState);
            case 2 -> (blockPos, blockState) -> new CobbleGenTile(Config.SERVER.tier2, (BlockEntityType)CobbleForDays.TIER2_TILE.get(), blockPos, blockState);
            case 3 -> (blockPos, blockState) -> new CobbleGenTile(Config.SERVER.tier3, (BlockEntityType)CobbleForDays.TIER3_TILE.get(), blockPos, blockState);
            case 4 -> (blockPos, blockState) -> new CobbleGenTile(Config.SERVER.tier4, (BlockEntityType)CobbleForDays.TIER4_TILE.get(), blockPos, blockState);
            case 5 -> (blockPos, blockState) -> new CobbleGenTile(Config.SERVER.tier5, (BlockEntityType)CobbleForDays.TIER5_TILE.get(), blockPos, blockState);
            default -> throw new IllegalArgumentException("Unknown Tier: " + tier);
        };
    }

    private static class ConfigCache {
        private final Config.Server.Tier tier;
        private int interval;
        private int count;
        private int max;
        private boolean pushes;

        private ConfigCache(Config.Server.Tier tier) {
            this.tier = tier;
            this.update();
        }

        private void update() {
            this.interval = (Integer)this.tier.interval.get();
            this.count = (Integer)this.tier.count.get();
            this.max = (Integer)this.tier.max.get();
            this.pushes = (Boolean)this.tier.pushes.get();
        }
    }

    private class Inventory
    implements IItemHandler {
        private final ItemStack stack = new ItemStack((ItemLike)Items.f_42594_, 0);

        private Inventory() {
        }

        public int getSlots() {
            return 1;
        }

        public ItemStack getStackInSlot(int slot) {
            this.stack.m_41764_(CobbleGenTile.this.count);
            return this.stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (CobbleGenTile.this.count == 0 || amount == 0) {
                return ItemStack.f_41583_;
            }
            int ret = Math.min(CobbleGenTile.this.count, amount);
            if (!simulate) {
                CobbleGenTile.this.count -= ret;
                CobbleGenTile.this.m_6596_();
            }
            return new ItemStack((ItemLike)Items.f_42594_, ret);
        }

        public int getSlotLimit(int slot) {
            return Integer.MAX_VALUE;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return stack;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return false;
        }
    }

    public static class Ticker
    implements BlockEntityTicker<CobbleGenTile> {
        public void tick(Level level, BlockPos blockPos, BlockState blockState, CobbleGenTile cobbleGen) {
            if (level.f_46443_) {
                return;
            }
            if (--cobbleGen.timer <= 0) {
                cobbleGen.count += cobbleGen.config.count;
                cobbleGen.timer = cobbleGen.config.interval;
                if (cobbleGen.count > cobbleGen.config.max) {
                    cobbleGen.count = cobbleGen.config.max;
                }
                if (cobbleGen.count < 0) {
                    cobbleGen.count = 0;
                }
                cobbleGen.m_6596_();
            }
            if (cobbleGen.config.pushes && cobbleGen.count > 0 && cobbleGen.getCache().isPresent()) {
                cobbleGen.push();
            }
            if (--cobbleGen.configTimer <= 0) {
                cobbleGen.config.update();
                cobbleGen.configTimer = 200;
            }
        }
    }
}

