/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.multiblock;

import it.zerono.mods.zerocore.lib.multiblock.IMultiblockController;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;

public interface IMultiblockPart<Controller extends IMultiblockController<Controller>> {
    public boolean isConnected();

    default public boolean isConnectedTo(Controller controller) {
        return this.evalOnController(c -> c == controller, false);
    }

    public boolean isMachineAssembled();

    public boolean isMachineDisassembled();

    public boolean isMachinePaused();

    public Optional<Controller> getMultiblockController();

    default public void executeOnController(Consumer<Controller> code) {
        this.getMultiblockController().ifPresent(code);
    }

    default public <R> R evalOnController(Function<Controller, R> code, R defaultValue) {
        return this.getMultiblockController().map(code).orElse(defaultValue);
    }

    default public boolean testOnController(Predicate<Controller> test) {
        return this.getMultiblockController().filter(test).isPresent();
    }

    @Deprecated
    public Optional<Level> getPartWorld();

    default public <T> T mapPartWorld(Function<Level, T> mapper, T defaultValue) {
        return this.getPartWorld().map(mapper).orElse(defaultValue);
    }

    default public void forPartWorld(Consumer<Level> consumer) {
        this.getPartWorld().ifPresent(consumer);
    }

    default public Level getCurrentWorld() {
        return Objects.requireNonNull(this.getPartWorld().orElse(null));
    }

    public BlockPos getWorldPosition();

    default public long getWorldPositionHash() {
        return this.getWorldPosition().m_121878_();
    }

    public boolean isPartInvalid();

    public void onAttached(Controller var1);

    public void onDetached(Controller var1);

    public void onOrphaned(Controller var1, int var2, int var3);

    public Controller createController();

    public Class<Controller> getControllerType();

    public void onAssimilated(Controller var1);

    public void setVisited();

    public void setUnvisited();

    public boolean isVisited();

    default public boolean isNotVisited() {
        return !this.isVisited();
    }

    public void becomeMultiblockSaveDelegate();

    public void forfeitMultiblockSaveDelegate();

    public boolean isMultiblockSaveDelegate();

    public List<IMultiblockPart<Controller>> getNeighboringParts();

    public void onPreMachineAssembled(Controller var1);

    public void onPostMachineAssembled(Controller var1);

    public void onPreMachineBroken();

    public void onPostMachineBroken();

    public void onMachineActivated();

    public void onMachineDeactivated();

    @Deprecated
    default public Set<Controller> attachToNeighbors() {
        return Collections.emptySet();
    }

    public Set<Controller> attachToNeighbors(Function<IMultiblockPart<Controller>, Set<Controller>> var1);

    public void assertDetached();

    public boolean hasMultiblockSaveData();

    public Optional<CompoundTag> getMultiblockSaveData();

    default public <T> T mapMultiblockSaveData(Function<CompoundTag, T> mapper, T defaultValue) {
        return this.getMultiblockSaveData().map(mapper).orElse(defaultValue);
    }

    default public void forMultiblockSaveData(Consumer<CompoundTag> consumer) {
        this.getMultiblockSaveData().ifPresent(consumer);
    }

    public void onMultiblockDataAssimilated();

    public void listenForControllerDataUpdates();

    public static BlockBehaviour.Properties getDefaultBlockProperties() {
        return BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60918_(SoundType.f_56743_).m_60913_(5.0f, 6.0f).m_60999_().m_60953_(blockState -> 0).m_60922_((blockState, blockReader, pos, entity) -> false).m_60971_((blockState, blockReader, pos) -> true);
    }
}

