/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.data.nbt;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;

public final class NBTHelper {
    public static final CompoundTag EMPTY_COMPOUND = new CompoundTag();

    public static Optional<CompoundTag> nbtFrom(File file) {
        if (file.exists()) {
            Optional<CompoundTag> optional;
            FileInputStream stream = new FileInputStream(file);
            try {
                optional = Optional.of(NbtIo.m_128939_((InputStream)stream));
            }
            catch (Throwable throwable) {
                try {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            stream.close();
            return optional;
        }
        return Optional.empty();
    }

    public static boolean nbtTo(File file, CompoundTag data) {
        boolean bl;
        FileOutputStream stream = new FileOutputStream(file);
        try {
            NbtIo.m_128947_((CompoundTag)data, (OutputStream)stream);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
        }
        stream.close();
        return bl;
    }

    public static <E extends Enum<E>> CompoundTag nbtSetEnum(CompoundTag nbt, String key, E value) {
        nbt.m_128359_(key, value.name());
        return nbt;
    }

    public static <E extends Enum<E>> E nbtGetEnum(CompoundTag nbt, String key, Class<E> enumClass) throws IllegalArgumentException {
        return Enum.valueOf(enumClass, nbt.m_128461_(key));
    }

    public static boolean nbtContainsEnum(CompoundTag nbt, String key) {
        return nbt.m_128425_(key, 8);
    }

    public static <E extends Enum<E>> E nbtGetEnum(CompoundTag nbt, String key, Function<String, E> enumFactory, E defaultValue) {
        String value;
        if (nbt.m_128441_(key) && !Strings.isNullOrEmpty((String)(value = nbt.m_128461_(key)))) {
            return (E)((Enum)enumFactory.apply(nbt.m_128461_(key)));
        }
        return defaultValue;
    }

    public static <E extends Enum<E>> CompoundTag nbtSetEnumSet(CompoundTag nbt, String key, EnumSet<E> value) {
        ListTag tagList = new ListTag();
        for (Enum enumValue : value) {
            tagList.add((Object)NBTHelper.nbtSetEnum(new CompoundTag(), "enum", enumValue));
        }
        nbt.m_128365_(key, (Tag)tagList);
        return nbt;
    }

    public static boolean nbtContainsEnumSet(CompoundTag nbt, String key) {
        return nbt.m_128425_(key, 9);
    }

    public static <E extends Enum<E>> EnumSet<E> nbtGetEnumSet(CompoundTag nbt, String key, Class<E> enumClass) throws IllegalArgumentException {
        ListTag tagList = nbt.m_128437_(key, 8);
        ArrayList valueList = Lists.newArrayList();
        for (int i = 0; i < tagList.size(); ++i) {
            E enumValue = NBTHelper.nbtGetEnum(tagList.m_128728_(i), "enum", enumClass);
            valueList.add(enumValue);
        }
        return EnumSet.copyOf(valueList);
    }

    private NBTHelper() {
    }
}

