/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import it.zerono.mods.zerocore.internal.Log;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.client.gui.AbstractWindowsManager;
import it.zerono.mods.zerocore.lib.client.gui.GuiHelper;
import it.zerono.mods.zerocore.lib.client.gui.IControl;
import it.zerono.mods.zerocore.lib.client.gui.IControlContainer;
import it.zerono.mods.zerocore.lib.client.gui.IWindow;
import it.zerono.mods.zerocore.lib.client.gui.Theme;
import it.zerono.mods.zerocore.lib.client.gui.WindowsManagerMultiWindow;
import it.zerono.mods.zerocore.lib.client.gui.WindowsManagerSingleWindow;
import it.zerono.mods.zerocore.lib.client.gui.control.HelpButton;
import it.zerono.mods.zerocore.lib.client.gui.control.SlotsGroup;
import it.zerono.mods.zerocore.lib.client.gui.databind.BindingGroup;
import it.zerono.mods.zerocore.lib.client.gui.databind.IBinding;
import it.zerono.mods.zerocore.lib.client.gui.layout.FixedLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.data.geometry.Rectangle;
import it.zerono.mods.zerocore.lib.event.ConcurrentEvent;
import it.zerono.mods.zerocore.lib.event.Event;
import it.zerono.mods.zerocore.lib.event.IEvent;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModContainerScreen<C extends ModContainer>
extends AbstractContainerScreen<C> {
    public final IEvent<Runnable> Create;
    public final IEvent<Runnable> Close;
    public final IEvent<Runnable> Created;
    public final IEvent<Runnable> DataUpdated;
    private final AbstractWindowsManager<C> _windowsManager;
    private final List<Runnable> _tickHandlers;
    private final Queue<Runnable> _deferred;
    private final Runnable _raiseContainerDataUpdatedHandler;
    private boolean _dataUpdateInProgress;
    private int _originalMouseX;
    private int _originalMouseY;
    private boolean _ignoreCloseOnInventoryKey;
    private int _nextBogusId;
    private BindingGroup _bindings;
    private Theme _theme;

    protected ModContainerScreen(C container, Inventory inventory, Component title, int guiWidth, int guiHeight) {
        this(container, inventory, title, guiWidth, guiHeight, true);
    }

    protected ModContainerScreen(C container, Inventory inventory, Component title, int guiWidth, int guiHeight, boolean singleWindow) {
        super(container, inventory, title);
        this.f_97726_ = guiWidth;
        this.f_97727_ = guiHeight;
        this._tickHandlers = Lists.newArrayListWithCapacity((int)2);
        this._deferred = Lists.newLinkedList();
        this._originalMouseY = 0;
        this._originalMouseX = 0;
        this._ignoreCloseOnInventoryKey = false;
        this._nextBogusId = 0;
        this._theme = Theme.DEFAULT;
        this.Create = new Event<Runnable>();
        this.Close = new ConcurrentEvent<Runnable>();
        this.Created = new Event<Runnable>();
        this.DataUpdated = new Event<Runnable>();
        this._raiseContainerDataUpdatedHandler = ((ModContainer)container).subscribeContainerDataUpdate(this::raiseDataUpdated);
        this._windowsManager = singleWindow ? new WindowsManagerSingleWindow(this) : new WindowsManagerMultiWindow(this);
    }

    protected void close() {
        if (null != Minecraft.m_91087_().f_91074_) {
            Minecraft.m_91087_().f_91074_.m_6915_();
        }
    }

    protected boolean isDataUpdateInProgress() {
        return this._dataUpdateInProgress;
    }

    protected void onScreenCreate() {
    }

    protected void onScreenCreated() {
        this.raiseDataUpdated();
    }

    protected void onScreenClose() {
        ((ModContainer)this.m_6262_()).unsubscribeContainerDataUpdate(this._raiseContainerDataUpdatedHandler);
    }

    protected void onDataUpdated() {
    }

    public boolean isValid() {
        ArrayList errors = Lists.newArrayList();
        this._windowsManager.validate(errors::add);
        if (!errors.isEmpty()) {
            CodeHelper.reportErrorToPlayer((Player)Objects.requireNonNull(this.getMinecraft().f_91074_), null, errors);
            return false;
        }
        return true;
    }

    public void requestTickUpdates(Runnable handler) {
        this._tickHandlers.add(handler);
    }

    public int getGuiX() {
        return this.f_97735_;
    }

    public int getGuiY() {
        return this.f_97736_;
    }

    public int getGuiWidth() {
        return this.f_97726_;
    }

    public int getGuiHeight() {
        return this.f_97727_;
    }

    public int getMinecraftWindowWidth() {
        return this.getMinecraft().m_91268_().m_85441_();
    }

    public int getMinecraftWindowHeight() {
        return this.getMinecraft().m_91268_().m_85442_();
    }

    public float getZLevel() {
        return 0.0f;
    }

    public double getGuiScaleFactor() {
        return this.getMinecraft().m_91268_().m_85449_();
    }

    public int getClippedMouseX() {
        return Mth.m_14165_((double)(GuiHelper.getMouse().m_91589_() - (double)this.getGuiX()));
    }

    public int getClippedMouseY() {
        return Mth.m_14165_((double)(GuiHelper.getMouse().m_91594_() - (double)this.getGuiY()));
    }

    public void renderHoveredSlotToolTip(GuiGraphics gfx) {
        this.m_280072_(gfx, this.getOriginalMouseX(), this.getOriginalMouseY());
    }

    public int getTooltipsPopupMaxWidth() {
        return -1;
    }

    public static int parseTooltipsPopupMaxWidthFromLang(String langKey, int defaultValue) {
        MutableComponent text = Component.m_237115_((String)langKey);
        try {
            int width = Integer.parseInt(text.getString());
            return width > 0 ? width : defaultValue;
        }
        catch (NumberFormatException ex) {
            Log.LOGGER.error(Log.GUI, "Invalid integer value from lang file: {}", (Object)langKey);
            return defaultValue;
        }
    }

    public int getOriginalMouseX() {
        return this._originalMouseX;
    }

    public int getOriginalMouseY() {
        return this._originalMouseY;
    }

    public Rectangle getScreenRect() {
        return new Rectangle(0, 0, Minecraft.m_91087_().m_91268_().m_85445_(), Minecraft.m_91087_().m_91268_().m_85446_());
    }

    public Rectangle getScreenRectPadded() {
        return this.getScreenRect().inset(5, 5);
    }

    public int nextGenericId() {
        return this._nextBogusId++;
    }

    public String nextGenericName() {
        return Integer.toString(this.nextGenericId());
    }

    public void enqueueTask(Runnable runnable) {
        this._deferred.add(runnable);
    }

    protected IWindow createWindow(IControlContainer rootContainer, boolean modalWindow) {
        return this._windowsManager.createWindow(rootContainer, modalWindow, this.getGuiX(), this.getGuiY(), this.getGuiWidth(), this.getGuiHeight());
    }

    protected IWindow createWindow(IControlContainer rootContainer, boolean modalWindow, int x, int y, int width, int height) {
        return this._windowsManager.createWindow(rootContainer, modalWindow, x, y, width, height);
    }

    protected void ignoreCloseOnInventoryKey(boolean ignore) {
        this._ignoreCloseOnInventoryKey = ignore;
    }

    protected boolean ignoreCloseOnInventoryKey() {
        return this._ignoreCloseOnInventoryKey;
    }

    protected IControl createPatchouliHelpButton(ResourceLocation bookId, ResourceLocation entryId, int pageNum) {
        HelpButton help = HelpButton.patchouli(this, "helpPatchouli", bookId, entryId, pageNum);
        help.setLayoutEngineHint(FixedLayoutEngine.hint(this.getGuiWidth() - 30, this.getGuiHeight() - 41));
        return help;
    }

    public Theme getTheme() {
        return this._theme;
    }

    public void setTheme(Theme theme) {
        this._theme = Objects.requireNonNull(theme);
        this._windowsManager.onThemeChanged(theme);
    }

    protected SlotsGroup createMonoSlotGroupControl(String controlName, String inventorySlotsGroupName, ISprite backgroundSprite, int borderSize) {
        SlotsGroup control = new SlotsGroup(this, controlName, inventorySlotsGroupName, backgroundSprite.getWidth(), backgroundSprite.getHeight(), backgroundSprite);
        control.setPadding(borderSize);
        return control;
    }

    protected SlotsGroup createPlayerHotBarSlotsGroupControl(ISprite backgroundSprite, int borderSize) {
        SlotsGroup control = new SlotsGroup(this, "hotbar", "playerinventory_hotbar", backgroundSprite.getWidth(), backgroundSprite.getHeight(), backgroundSprite);
        control.setPadding(borderSize);
        return control;
    }

    protected SlotsGroup createPlayerInventorySlotsGroupControl(ISprite backgroundSprite, int borderSize) {
        SlotsGroup control = new SlotsGroup(this, "playerinv", "playerinventory_main", backgroundSprite.getWidth(), backgroundSprite.getHeight(), backgroundSprite);
        control.setPadding(borderSize);
        return control;
    }

    public <Value> void addDataBinding(Supplier<Value> supplier, Consumer<Value> consumer) {
        this.addDataBinding(IBinding.from(supplier, consumer));
    }

    @SafeVarargs
    public final <Value> void addDataBinding(Supplier<Value> supplier, Consumer<Value> ... consumers) {
        this.addDataBinding(IBinding.from(supplier, consumers));
    }

    private void addDataBinding(IBinding binding) {
        if (null == this._bindings) {
            this._bindings = new BindingGroup();
        }
        this._bindings.addBinding(binding);
    }

    public final void m_7856_() {
        super.m_7856_();
        this.raiseScreenCreate();
        this.raiseScreenCreated();
    }

    public boolean m_7043_() {
        return false;
    }

    public final void m_7861_() {
        super.m_7861_();
        this.raiseScreenClose();
        this.Create.unsubscribeAll();
        this.Created.unsubscribeAll();
        this.Close.unsubscribeAll();
        CodeHelper.clearErrorReport();
    }

    public final void m_181908_() {
        super.m_181908_();
        this._windowsManager.onGuiContainerTick();
        this._tickHandlers.forEach(Runnable::run);
        if (!this._deferred.isEmpty()) {
            this._deferred.forEach(Runnable::run);
            this._deferred.clear();
        }
    }

    protected final void m_7286_(GuiGraphics gfx, float partialTicks, int mouseX, int mouseY) {
        this.m_280273_(gfx);
        this._originalMouseX = mouseX;
        this._originalMouseY = mouseY;
        this._windowsManager.onGuiContainerPaintBackground(gfx, partialTicks);
    }

    protected final void m_280003_(GuiGraphics gfx, int mouseX, int mouseY) {
        this._originalMouseX = mouseX;
        this._originalMouseY = mouseY;
        this._windowsManager.onGuiContainerPaintForeground(gfx);
    }

    public final boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        this._originalMouseX = (int)mouseX;
        this._originalMouseY = (int)mouseY;
        return this._windowsManager.onGuiContainerMouseClicked(mouseX, mouseY, mouseButton) || super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public final boolean m_6348_(double mouseX, double mouseY, int mouseButton) {
        this._originalMouseX = (int)mouseX;
        this._originalMouseY = (int)mouseY;
        return this._windowsManager.onGuiContainerMouseReleased(mouseX, mouseY, mouseButton) || super.m_6348_(mouseX, mouseY, mouseButton);
    }

    public void m_94757_(double mouseX, double mouseY) {
        super.m_94757_(mouseX, mouseY);
        this._originalMouseX = (int)mouseX;
        this._originalMouseY = (int)mouseY;
        this._windowsManager.onGuiContainerMouseMoved(mouseX, mouseY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollDelta) {
        this._originalMouseX = (int)mouseX;
        this._originalMouseY = (int)mouseY;
        return this._windowsManager.onGuiContainerMouseScrolled(mouseX, mouseY, scrollDelta) || super.m_6050_(mouseX, mouseY, scrollDelta);
    }

    public final boolean m_5534_(char typedChar, int keyCode) {
        return this._windowsManager.onGuiContainerCharTyped(typedChar, keyCode) || super.m_5534_(typedChar, keyCode);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        return this._windowsManager.onGuiContainerKeyPressed(keyCode, scanCode, modifiers) || this.checkIgnoreCloseOnInventoryKey(keyCode, scanCode) || super.m_7933_(keyCode, scanCode, modifiers);
    }

    private boolean checkIgnoreCloseOnInventoryKey(int keyCode, int scanCode) {
        return this.ignoreCloseOnInventoryKey() && this.getMinecraft().f_91066_.f_92092_.isActiveAndMatches(InputConstants.m_84827_((int)keyCode, (int)scanCode));
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        return this._windowsManager.onGuiContainerKeyReleased(keyCode, scanCode, modifiers) || super.m_7920_(keyCode, scanCode, modifiers);
    }

    protected boolean m_6774_(int regionX, int regionY, int regionWidth, int regionHeight, double pointX, double pointY) {
        return (pointX -= (double)this.getGuiLeft()) >= (double)(regionX - 1) && pointX < (double)(regionX + regionWidth + 1) && (pointY -= (double)this.getGuiTop()) >= (double)(regionY - 1) && pointY < (double)(regionY + regionHeight + 1);
    }

    private void raiseScreenCreate() {
        this.Create.raise(Runnable::run);
        this.onScreenCreate();
    }

    private void raiseScreenCreated() {
        this.onScreenCreated();
        this.Created.raise(Runnable::run);
    }

    private void raiseScreenClose() {
        this.Close.raise(Runnable::run);
        this.onScreenClose();
        if (null != this._bindings) {
            this._bindings.close();
        }
    }

    protected void raiseDataUpdated() {
        this._dataUpdateInProgress = true;
        if (null != this._bindings) {
            this._bindings.update();
        }
        this.onDataUpdated();
        this.DataUpdated.raise(Runnable::run);
        this._dataUpdateInProgress = false;
    }
}

