/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.module;

import mods.railcraft.api.fuel.FuelUtil;
import mods.railcraft.world.level.block.entity.steamboiler.FluidFueledSteamBoilerBlockEntity;
import mods.railcraft.world.level.material.FluidTools;
import mods.railcraft.world.level.material.StandardTank;
import mods.railcraft.world.level.material.steam.FluidFuelProvider;
import mods.railcraft.world.module.SteamBoilerModule;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class FluidFueledSteamBoilerModule
extends SteamBoilerModule<FluidFueledSteamBoilerBlockEntity> {
    protected final StandardTank fuelTank = StandardTank.ofBuckets(16).disableDrain().setValidator(fluidStack -> !fluidStack.isEmpty() && FuelUtil.fuelManager().getFuelValue(fluidStack.getFluid()) > 0.0f);
    private FluidTools.ProcessState fuelProcessState = FluidTools.ProcessState.RESET;

    public FluidFueledSteamBoilerModule(FluidFueledSteamBoilerBlockEntity provider) {
        super(provider, 3);
        this.tankManager.add(this.fuelTank);
        this.fuelTank.changeCallback(() -> ((FluidFueledSteamBoilerBlockEntity)provider).m_6596_());
        this.boiler.setFuelProvider(new FluidFuelProvider(this.fuelTank));
    }

    public StandardTank getFuelTank() {
        return this.fuelTank;
    }

    @Override
    protected void processFluidContainers() {
        super.processFluidContainers();
        this.fuelProcessState = FluidTools.processContainer(this.fluidContainer, this.fuelTank, FluidTools.ProcessType.DRAIN_ONLY, this.fuelProcessState);
    }

    @Override
    public boolean m_7013_(int slot, ItemStack itemStack) {
        if (!((FluidFueledSteamBoilerBlockEntity)this.provider).isFormed()) {
            return false;
        }
        if (slot == 0) {
            FluidStack fluid = FluidUtil.getFluidContained((ItemStack)itemStack).orElse(FluidStack.EMPTY);
            if (fluid.isEmpty()) {
                return false;
            }
            if (fluid.getFluid().m_205067_(FluidTags.f_13131_) || FuelUtil.fuelManager().getFuelValue(fluid.getFluid()) > 0.0f) {
                return true;
            }
        }
        return false;
    }
}

