/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.module;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import mods.railcraft.api.charge.Charge;
import mods.railcraft.api.charge.ChargeStorage;
import mods.railcraft.util.ForwardingEnergyStorage;
import mods.railcraft.util.container.AdvancedContainer;
import mods.railcraft.util.container.ContainerMapper;
import mods.railcraft.world.item.crafting.CrusherRecipe;
import mods.railcraft.world.item.crafting.RailcraftRecipeTypes;
import mods.railcraft.world.level.block.entity.CrusherBlockEntity;
import mods.railcraft.world.module.CrafterModule;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class CrusherModule
extends CrafterModule<CrusherBlockEntity> {
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_OUTPUT = 9;
    private static final int COST_PER_TICK = 80;
    private static final int COST_PER_STEP = 1280;
    private final ContainerMapper inputContainer;
    private final ContainerMapper outputContainer;
    private final Charge network;
    private Optional<CrusherRecipe> currentRecipe;
    private int currentSlot;
    private final LazyOptional<IItemHandler> itemHandler;
    private final LazyOptional<IEnergyStorage> energyHandler;

    public CrusherModule(CrusherBlockEntity provider, Charge network) {
        super(provider, 18);
        this.network = network;
        this.inputContainer = ContainerMapper.make(this, 0, 9);
        this.outputContainer = ContainerMapper.make(this, 9, 9).ignoreItemChecks();
        this.currentRecipe = Optional.empty();
        this.itemHandler = LazyOptional.of(() -> new InvWrapper(this){

            @NotNull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (slot < 9) {
                    return ItemStack.f_41583_;
                }
                return super.extractItem(slot, amount, simulate);
            }

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                if (slot < 9) {
                    return super.insertItem(slot, stack, simulate);
                }
                return stack;
            }
        });
        this.energyHandler = LazyOptional.of(() -> new ForwardingEnergyStorage(this::storage));
    }

    public ChargeStorage storage() {
        return this.access().storage().get();
    }

    private Charge.Access access() {
        return this.network.network((ServerLevel)((CrusherBlockEntity)this.provider).level()).access(((CrusherBlockEntity)this.provider).blockPos());
    }

    @Override
    public void serverTick() {
        super.serverTick();
        if (!this.lacksRequirements()) {
            this.energyHandler.ifPresent(storage -> storage.extractEnergy(80, false));
        }
    }

    @Override
    public boolean m_7013_(int index, ItemStack stack) {
        if (index < 9 && super.m_7013_(index, stack)) {
            return this.getRecipe(stack).isPresent();
        }
        return true;
    }

    @Override
    protected int calculateDuration() {
        return this.currentRecipe.map(CrusherRecipe::getProcessTime).orElse(200);
    }

    @Override
    protected boolean lacksRequirements() {
        return this.currentRecipe.isEmpty();
    }

    @Override
    protected boolean doProcessStep() {
        return this.energyHandler.map(storage -> storage.getEnergyStored() > 1280).orElse(false);
    }

    @Override
    protected void setupCrafting() {
        if (this.isRecipeValid()) {
            return;
        }
        this.currentRecipe = Optional.empty();
        for (int i = 0; i < this.inputContainer.m_6643_(); ++i) {
            ItemStack itemStack = this.inputContainer.m_8020_(i);
            if (itemStack.m_41619_()) continue;
            this.currentSlot = i;
            this.currentRecipe = this.getRecipe(itemStack);
            break;
        }
    }

    @Override
    protected boolean craftAndPush() {
        CrusherRecipe recipe = this.currentRecipe.orElseThrow(NullPointerException::new);
        AdvancedContainer tempInv = AdvancedContainer.copyOf(this.outputContainer);
        List<ItemStack> outputs = recipe.pollOutputs(((CrusherBlockEntity)this.provider).m_58904_().m_213780_());
        boolean hasSpace = outputs.stream().map(tempInv::insert).allMatch(ItemStack::m_41619_);
        if (hasSpace) {
            outputs.forEach(this.outputContainer::insert);
            this.inputContainer.extract((Predicate)recipe.m_7527_().get(0));
            ((CrusherBlockEntity)this.provider).m_58904_().m_5594_(null, ((CrusherBlockEntity)this.provider).blockPos(), SoundEvents.f_12059_, SoundSource.BLOCKS, 1.0f, ((CrusherBlockEntity)this.provider).m_58904_().m_213780_().m_188501_() * 0.25f + 0.7f);
        }
        return hasSpace;
    }

    private boolean isRecipeValid() {
        return this.currentRecipe.map(r -> (Ingredient)r.m_7527_().get(0)).map(r -> r.test(this.inputContainer.m_8020_(this.currentSlot))).orElse(false);
    }

    private Optional<CrusherRecipe> getRecipe(ItemStack itemStack) {
        return ((CrusherBlockEntity)this.provider).m_58904_().m_7465_().m_44015_((RecipeType)RailcraftRecipeTypes.CRUSHING.get(), (Container)new SimpleContainer(new ItemStack[]{itemStack}), ((CrusherBlockEntity)this.provider).m_58904_());
    }

    @Override
    public void m_6596_() {
        super.m_6596_();
        this.currentRecipe = Optional.empty();
    }

    public LazyOptional<IItemHandler> getItemHandler() {
        return this.itemHandler;
    }

    public LazyOptional<IEnergyStorage> getEnergyHandler() {
        return this.energyHandler;
    }

    public void invalidateCaps() {
        this.itemHandler.invalidate();
        this.energyHandler.invalidate();
    }
}

