/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.levelgen.structure;

import mods.railcraft.world.level.block.RailcraftBlocks;
import mods.railcraft.world.level.levelgen.structure.RailcraftStructurePieces;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;

public class GeodeStructurePiece
extends StructurePiece {
    private static final int DISTANCE_OUTER_SQ = 64;
    private static final int DISTANCE_ORE_SQ = 25;
    private static final int DISTANCE_INNER_SQ = 16;

    public GeodeStructurePiece(int minX, int y, int minZ) {
        super((StructurePieceType)RailcraftStructurePieces.GEODE.get(), 0, GeodeStructurePiece.createBoundingBox(minX, y, minZ));
        this.m_73519_(null);
    }

    public GeodeStructurePiece(CompoundTag tag) {
        super((StructurePieceType)RailcraftStructurePieces.GEODE.get(), tag);
    }

    private static BoundingBox createBoundingBox(int minX, int y, int minZ) {
        return new BoundingBox(minX, y, minZ, minX + 16, y + 16, minZ + 16);
    }

    protected void m_183620_(StructurePieceSerializationContext context, CompoundTag tag) {
    }

    public void m_213694_(WorldGenLevel level, StructureManager structureManager, ChunkGenerator generator, RandomSource random, BoundingBox box, ChunkPos chunkPos, BlockPos pos) {
        for (int x = -8; x < 8; ++x) {
            for (int y = -8; y < 8; ++y) {
                for (int z = -8; z < 8; ++z) {
                    int distSq = x * x + y * y + z * z;
                    BlockPos targetPos = pos.m_7918_(x, 9 + y, z);
                    if (distSq <= 16) {
                        this.placeAir(level, targetPos);
                    } else if (distSq <= 64) {
                        this.placeStone(level, targetPos, random);
                    }
                    BlockState existingState = level.m_8055_(targetPos);
                    if (distSq <= 16 || distSq > 25) continue;
                    this.placeOre(level, existingState, random, targetPos);
                }
            }
        }
    }

    private void placeAir(WorldGenLevel level, BlockPos pos) {
        this.m_73434_(level, Blocks.f_50016_.m_49966_(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), this.m_73547_());
    }

    private void placeStone(WorldGenLevel level, BlockPos pos, RandomSource random) {
        BlockState state = random.m_188500_() < 0.2 ? (random.m_188500_() < 0.5 ? Blocks.f_152550_.m_49966_() : Blocks.f_152597_.m_49966_()) : ((Block)RailcraftBlocks.ABYSSAL_STONE.get()).m_49966_();
        this.m_73434_(level, state, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), this.m_73547_());
    }

    private void placeOre(WorldGenLevel level, BlockState existingState, RandomSource random, BlockPos pos) {
        if (existingState.m_60713_((Block)RailcraftBlocks.ABYSSAL_STONE.get())) {
            double chance = random.m_188500_();
            BlockState oreState = null;
            if (chance <= 0.004) {
                oreState = Blocks.f_152474_.m_49966_();
            } else if (chance <= 0.008) {
                oreState = Blocks.f_152479_.m_49966_();
            } else if (chance <= 0.02) {
                oreState = Blocks.f_152472_.m_49966_();
            }
            if (oreState != null) {
                this.m_73434_(level, oreState, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), this.m_73547_());
            }
        }
    }
}

