/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.track.outfitted;

import java.util.function.Supplier;
import mods.railcraft.api.track.TrackType;
import mods.railcraft.api.track.TrackUtil;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.track.SwitchTrackBlockEntity;
import mods.railcraft.world.level.block.entity.track.WyeTrackBlockEntity;
import mods.railcraft.world.level.block.track.outfitted.SwitchTrackBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import org.jetbrains.annotations.Nullable;

public class WyeTrackBlock
extends SwitchTrackBlock
implements EntityBlock {
    public WyeTrackBlock(Supplier<? extends TrackType> trackType, BlockBehaviour.Properties properties) {
        super(trackType, properties);
    }

    @Override
    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldBlockState, boolean moved) {
        this.adjustShape(state, level, pos);
        super.m_6807_(state, level, pos, oldBlockState, moved);
    }

    protected void adjustShape(BlockState blockState, Level level, BlockPos pos) {
        switch (TrackUtil.getRailShapeRaw(blockState)) {
            case NORTH_SOUTH: {
                BlockPos north = pos.m_122012_();
                BlockPos south = pos.m_122019_();
                if (!BaseRailBlock.m_49364_((Level)level, (BlockPos)north) || !BaseRailBlock.m_49364_((Level)level, (BlockPos)south)) {
                    return;
                }
                RailShape northShape = TrackUtil.getTrackDirection((BlockGetter)level, north);
                RailShape southShape = TrackUtil.getTrackDirection((BlockGetter)level, south);
                if (!northShape.equals((Object)RailShape.NORTH_SOUTH) || !southShape.equals((Object)RailShape.NORTH_SOUTH)) break;
                TrackUtil.setRailShape(level, pos, RailShape.EAST_WEST);
                break;
            }
            case EAST_WEST: {
                BlockPos east = pos.m_122029_();
                BlockPos west = pos.m_122024_();
                if (!BaseRailBlock.m_49364_((Level)level, (BlockPos)east) || !BaseRailBlock.m_49364_((Level)level, (BlockPos)west)) {
                    return;
                }
                RailShape eastShape = TrackUtil.getTrackDirection((BlockGetter)level, east);
                RailShape westShape = TrackUtil.getTrackDirection((BlockGetter)level, west);
                if (!eastShape.equals((Object)RailShape.EAST_WEST) || !westShape.equals((Object)RailShape.EAST_WEST)) break;
                TrackUtil.setRailShape(level, pos, RailShape.NORTH_SOUTH);
                break;
            }
        }
    }

    @Override
    public RailShape getRailDirection(BlockState blockState, BlockGetter world, BlockPos pos, @Nullable AbstractMinecart cart) {
        boolean switched = WyeTrackBlock.isSwitched(blockState);
        return switch (WyeTrackBlock.getFacing(blockState)) {
            case Direction.NORTH -> {
                if (switched) {
                    yield RailShape.SOUTH_WEST;
                }
                yield RailShape.SOUTH_EAST;
            }
            case Direction.SOUTH -> {
                if (switched) {
                    yield RailShape.NORTH_EAST;
                }
                yield RailShape.NORTH_WEST;
            }
            case Direction.EAST -> {
                if (switched) {
                    yield RailShape.NORTH_WEST;
                }
                yield RailShape.SOUTH_WEST;
            }
            case Direction.WEST -> {
                if (switched) {
                    yield RailShape.SOUTH_EAST;
                }
                yield RailShape.NORTH_EAST;
            }
            default -> throw new IllegalStateException("Invalid facing direction.");
        };
    }

    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new WyeTrackBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> type) {
        return level.m_5776_() ? null : BaseEntityBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)RailcraftBlockEntityTypes.WYE_TRACK.get()), SwitchTrackBlockEntity::serverTick);
    }
}

