/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.track.outfitted;

import java.util.List;
import java.util.function.Supplier;
import mods.railcraft.Translations;
import mods.railcraft.api.track.TrackType;
import mods.railcraft.world.level.block.track.outfitted.ReversibleOutfittedTrackBlock;
import mods.railcraft.world.level.block.track.outfitted.ReversiblePoweredOutfittedTrackBlock;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GatedTrackBlock
extends ReversiblePoweredOutfittedTrackBlock {
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final BooleanProperty IN_WALL = BlockStateProperties.f_61442_;
    public static final BooleanProperty ONE_WAY = BooleanProperty.m_61465_((String)"one_way");
    private static final double MOTION_MIN = 0.2;
    protected static final VoxelShape Z_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape X_SHAPE = Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    protected static final VoxelShape Z_SHAPE_LOW = Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)13.0, (double)10.0);
    protected static final VoxelShape X_SHAPE_LOW = Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)13.0, (double)16.0);
    protected static final VoxelShape Z_COLLISION_SHAPE = GatedTrackBlock.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)24.0, (double)10.0);
    protected static final VoxelShape X_COLLISION_SHAPE = GatedTrackBlock.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)24.0, (double)16.0);
    protected static final VoxelShape Z_OCCLUSION_SHAPE = Shapes.m_83110_((VoxelShape)GatedTrackBlock.m_49796_((double)0.0, (double)5.0, (double)7.0, (double)2.0, (double)16.0, (double)9.0), (VoxelShape)GatedTrackBlock.m_49796_((double)14.0, (double)5.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0));
    protected static final VoxelShape X_OCCLUSION_SHAPE = Shapes.m_83110_((VoxelShape)GatedTrackBlock.m_49796_((double)7.0, (double)5.0, (double)0.0, (double)9.0, (double)16.0, (double)2.0), (VoxelShape)GatedTrackBlock.m_49796_((double)7.0, (double)5.0, (double)14.0, (double)9.0, (double)16.0, (double)16.0));
    protected static final VoxelShape Z_OCCLUSION_SHAPE_LOW = Shapes.m_83110_((VoxelShape)GatedTrackBlock.m_49796_((double)0.0, (double)2.0, (double)7.0, (double)2.0, (double)13.0, (double)9.0), (VoxelShape)GatedTrackBlock.m_49796_((double)14.0, (double)2.0, (double)7.0, (double)16.0, (double)13.0, (double)9.0));
    protected static final VoxelShape X_OCCLUSION_SHAPE_LOW = Shapes.m_83110_((VoxelShape)GatedTrackBlock.m_49796_((double)7.0, (double)2.0, (double)0.0, (double)9.0, (double)13.0, (double)2.0), (VoxelShape)GatedTrackBlock.m_49796_((double)7.0, (double)2.0, (double)14.0, (double)9.0, (double)13.0, (double)16.0));

    public GatedTrackBlock(Supplier<? extends TrackType> trackType, BlockBehaviour.Properties properties) {
        super(trackType, properties);
    }

    @Override
    protected BlockState buildDefaultState(BlockState blockState) {
        return (BlockState)((BlockState)((BlockState)super.buildDefaultState(blockState).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)IN_WALL, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ONE_WAY, (Comparable)Boolean.valueOf(false));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{OPEN, IN_WALL, ONE_WAY});
    }

    @Override
    public VoxelShape m_5940_(BlockState blockState, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (((Boolean)blockState.m_61143_((Property)IN_WALL)).booleanValue()) {
            return GatedTrackBlock.getRailShapeRaw(blockState) == RailShape.EAST_WEST ? X_SHAPE_LOW : Z_SHAPE_LOW;
        }
        return GatedTrackBlock.getRailShapeRaw(blockState) == RailShape.EAST_WEST ? X_SHAPE : Z_SHAPE;
    }

    public BlockState m_7417_(BlockState blockState, Direction neighborDirection, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (ReversibleOutfittedTrackBlock.getFacing(blockState).m_122427_().m_122434_() != neighborDirection.m_122434_()) {
            return super.m_7417_(blockState, neighborDirection, neighborState, level, pos, neighborPos);
        }
        return (BlockState)blockState.m_61124_((Property)IN_WALL, (Comparable)Boolean.valueOf(this.isWall(neighborState) || this.isWall(level.m_8055_(pos.m_121945_(neighborDirection.m_122424_())))));
    }

    public VoxelShape m_5939_(BlockState blockState, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (((Boolean)blockState.m_61143_((Property)OPEN)).booleanValue()) {
            return Shapes.m_83040_();
        }
        return GatedTrackBlock.getRailShapeRaw(blockState) == RailShape.NORTH_SOUTH ? Z_COLLISION_SHAPE : X_COLLISION_SHAPE;
    }

    public VoxelShape m_7952_(BlockState blockState, BlockGetter level, BlockPos pos) {
        if (((Boolean)blockState.m_61143_((Property)IN_WALL)).booleanValue()) {
            return GatedTrackBlock.getRailShapeRaw(blockState) == RailShape.EAST_WEST ? X_OCCLUSION_SHAPE_LOW : Z_OCCLUSION_SHAPE_LOW;
        }
        return GatedTrackBlock.getRailShapeRaw(blockState) == RailShape.EAST_WEST ? X_OCCLUSION_SHAPE : Z_OCCLUSION_SHAPE;
    }

    public boolean m_7357_(BlockState blockState, BlockGetter level, BlockPos pos, PathComputationType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case PathComputationType.LAND, PathComputationType.AIR -> (Boolean)blockState.m_61143_((Property)OPEN);
            case PathComputationType.WATER -> false;
        };
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockState = super.m_5573_(context);
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        RailShape railShape = GatedTrackBlock.getRailShapeRaw(blockState);
        boolean inWall = railShape == RailShape.NORTH_SOUTH && (this.isWall(level.m_8055_(pos.m_122024_())) || this.isWall(level.m_8055_(pos.m_122029_()))) || railShape == RailShape.EAST_WEST && (this.isWall(level.m_8055_(pos.m_122012_())) || this.isWall(level.m_8055_(pos.m_122019_())));
        return (BlockState)((BlockState)blockState.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(GatedTrackBlock.isPowered(blockState)))).m_61124_((Property)IN_WALL, (Comparable)Boolean.valueOf(inWall));
    }

    private boolean isWall(BlockState blockState) {
        return blockState.m_204336_(BlockTags.f_13032_);
    }

    @Override
    public int getPowerPropagation(BlockState blockState, Level level, BlockPos pos) {
        return 0;
    }

    @Override
    public void onMinecartPass(BlockState blockState, Level level, BlockPos pos, AbstractMinecart cart) {
        if (GatedTrackBlock.isOneWay(blockState) && GatedTrackBlock.isOpen(blockState)) {
            RailShape shape = GatedTrackBlock.getRailShapeRaw(blockState);
            Vec3 deltaMovement = cart.m_20184_();
            if (shape == RailShape.NORTH_SOUTH) {
                double motion = Math.max(Math.abs(deltaMovement.m_7094_()), 0.2);
                cart.m_20334_(deltaMovement.m_7096_(), deltaMovement.m_7098_(), motion * (GatedTrackBlock.isReversed(blockState) ? 1.0 : -1.0));
            } else {
                double motion = Math.max(Math.abs(deltaMovement.m_7096_()), 0.2);
                cart.m_20334_(motion * (GatedTrackBlock.isReversed(blockState) ? -1.0 : 1.0), deltaMovement.m_7098_(), deltaMovement.m_7094_());
            }
        }
    }

    @Override
    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        InteractionResult result = super.m_6227_(blockState, level, pos, player, hand, rayTraceResult);
        if (result.m_19077_()) {
            return result;
        }
        if (!level.m_5776_()) {
            boolean open = !GatedTrackBlock.isOpen(blockState);
            level.m_46597_(pos, (BlockState)blockState.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)));
            level.m_5594_(null, pos, open ? SoundEvents.f_11873_ : SoundEvents.f_11872_, SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.1f + 0.9f);
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    @Override
    public boolean crowbarWhack(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack itemStack) {
        if (level.m_5776_()) {
            return true;
        }
        int newState = ((GatedTrackBlock.isOneWay(blockState) ? 2 : 0) | (GatedTrackBlock.isReversed(blockState) ? 1 : 0)) + (player.m_6144_() ? 3 : 1);
        level.m_46597_(pos, (BlockState)((BlockState)blockState.m_61124_((Property)ONE_WAY, (Comparable)Boolean.valueOf((newState & 2) == 2))).m_61124_((Property)REVERSED, (Comparable)Boolean.valueOf((newState & 1) == 1)));
        return true;
    }

    @Override
    public void m_6861_(BlockState blockState, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean moved) {
        boolean powered;
        super.m_6861_(blockState, level, pos, neighborBlock, neighborPos, moved);
        if (!level.m_5776_() && (powered = GatedTrackBlock.isPowered(blockState)) != GatedTrackBlock.isOpen(blockState)) {
            level.m_7731_(pos, (BlockState)blockState.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(powered)), 2);
            level.m_5594_(null, pos, powered ? SoundEvents.f_11873_ : SoundEvents.f_11872_, SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.1f + 0.9f);
        }
    }

    public static boolean isOpen(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)OPEN);
    }

    public static boolean isOneWay(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)ONE_WAY);
    }

    public void m_5871_(ItemStack stack, BlockGetter level, List<Component> lines, TooltipFlag flag) {
        lines.add((Component)Component.m_237115_((String)Translations.Tips.GATED_TRACK).m_130940_(ChatFormatting.GRAY));
        lines.add((Component)Component.m_237115_((String)Translations.Tips.HIT_CROWBAR_TO_CHANGE_MODE).m_130940_(ChatFormatting.BLUE));
        lines.add((Component)Component.m_237115_((String)Translations.Tips.APPLY_REDSTONE_TO_OPEN).m_130940_(ChatFormatting.RED));
    }
}

