/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.post;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.EnumMap;
import java.util.Map;
import mods.railcraft.tags.RailcraftTags;
import mods.railcraft.util.VoxelShapeUtil;
import mods.railcraft.world.level.block.post.Column;
import mods.railcraft.world.level.block.post.Connection;
import mods.railcraft.world.level.block.signal.SignalBlock;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.LeadItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PostBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final VoxelShape TOP_COLUMN_SHAPE = PostBlock.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    public static final VoxelShape MIDDLE_COLUMN_SHAPE = PostBlock.m_49796_((double)6.0, (double)9.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0);
    public static final VoxelShape FULL_COLUMN_SHAPE = PostBlock.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    public static final VoxelShape PLATFORM_SHAPE = Shapes.m_83110_((VoxelShape)PostBlock.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), (VoxelShape)PostBlock.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
    public static final Map<Direction, VoxelShape> HORIZONTAL_CONNECTION_SHAPES = Map.copyOf(VoxelShapeUtil.createHorizontalShapes(7.0, 7.0, 7.0, 9.0, 15.0, 9.0));
    public static final EnumProperty<Column> COLUMN = EnumProperty.m_61587_((String)"column", Column.class);
    public static final EnumProperty<Connection> NORTH = EnumProperty.m_61587_((String)"north", Connection.class);
    public static final EnumProperty<Connection> SOUTH = EnumProperty.m_61587_((String)"south", Connection.class);
    public static final EnumProperty<Connection> EAST = EnumProperty.m_61587_((String)"east", Connection.class);
    public static final EnumProperty<Connection> WEST = EnumProperty.m_61587_((String)"west", Connection.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final Map<Direction, EnumProperty<Connection>> propertyByDirection = (Map)Util.m_137469_(new EnumMap(Direction.class), map -> {
        map.put(Direction.NORTH, NORTH);
        map.put(Direction.EAST, EAST);
        map.put(Direction.SOUTH, SOUTH);
        map.put(Direction.WEST, WEST);
    });
    private final Map<Column, VoxelShape[]> shapes = Map.of(Column.FULL, VoxelShapeUtil.makeShapes(FULL_COLUMN_SHAPE, HORIZONTAL_CONNECTION_SHAPES), Column.TOP, VoxelShapeUtil.makeShapes(TOP_COLUMN_SHAPE, HORIZONTAL_CONNECTION_SHAPES), Column.SMALL, VoxelShapeUtil.makeShapes(MIDDLE_COLUMN_SHAPE, HORIZONTAL_CONNECTION_SHAPES), Column.PLATFORM, VoxelShapeUtil.makeShapes(PLATFORM_SHAPE, HORIZONTAL_CONNECTION_SHAPES));
    private final Object2IntMap<BlockState> stateToIndex = new Object2IntOpenHashMap();

    public PostBlock(BlockBehaviour.Properties properties) {
        super(properties);
        properties.m_60913_(3.0f, 15.0f);
        for (BlockState blockstate : this.f_49792_.m_61056_()) {
            this.getShapeIndex(blockstate);
        }
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(COLUMN, (Comparable)((Object)Column.FULL))).m_61124_(NORTH, (Comparable)((Object)Connection.NONE))).m_61124_(SOUTH, (Comparable)((Object)Connection.NONE))).m_61124_(EAST, (Comparable)((Object)Connection.NONE))).m_61124_(WEST, (Comparable)((Object)Connection.NONE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{COLUMN, NORTH, SOUTH, EAST, WEST, WATERLOGGED});
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter level, BlockPos blockPos, CollisionContext context) {
        return this.shapes.get(blockState.m_61143_(COLUMN))[this.getShapeIndex(blockState)];
    }

    public VoxelShape m_7947_(BlockState blockState, BlockGetter level, BlockPos blockPos) {
        return Shapes.m_83144_();
    }

    public final int getShapeIndex(BlockState blockState) {
        return this.stateToIndex.computeIfAbsent((Object)blockState, this::computeShapeIndex);
    }

    protected int computeShapeIndex(BlockState blockState) {
        int i = 0;
        for (Map.Entry<Direction, EnumProperty<Connection>> entry : propertyByDirection.entrySet()) {
            if (blockState.m_61143_((Property)entry.getValue()) == Connection.NONE) continue;
            i |= VoxelShapeUtil.indexFor(entry.getKey());
        }
        switch ((Column)((Object)blockState.m_61143_(COLUMN))) {
            case FULL: {
                i |= VoxelShapeUtil.indexFor(Direction.DOWN);
            }
            case TOP: {
                i |= VoxelShapeUtil.indexFor(Direction.UP);
                break;
            }
        }
        return i;
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        if (level.m_5776_()) {
            ItemStack itemStack = player.m_21120_(hand);
            return itemStack.m_41720_() == Items.f_42655_ ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        return LeadItem.m_42829_((Player)player, (Level)level, (BlockPos)pos);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos blockPos = context.m_8083_();
        FluidState fluidState = level.m_6425_(context.m_8083_());
        BlockPos northPos = blockPos.m_122012_();
        BlockPos eastPos = blockPos.m_122029_();
        BlockPos southPos = blockPos.m_122019_();
        BlockPos westPos = blockPos.m_122024_();
        BlockState northState = level.m_8055_(northPos);
        BlockState eastState = level.m_8055_(eastPos);
        BlockState southState = level.m_8055_(southPos);
        BlockState westState = level.m_8055_(westPos);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)super.m_5573_(context).m_61124_(COLUMN, (Comparable)((Object)this.getColumn((BlockGetter)level, blockPos)))).m_61124_(NORTH, (Comparable)((Object)this.getConnection(northState, northState.m_60783_((BlockGetter)level, northPos, Direction.SOUTH), Direction.SOUTH)))).m_61124_(EAST, (Comparable)((Object)this.getConnection(eastState, eastState.m_60783_((BlockGetter)level, eastPos, Direction.WEST), Direction.WEST)))).m_61124_(SOUTH, (Comparable)((Object)this.getConnection(southState, southState.m_60783_((BlockGetter)level, southPos, Direction.NORTH), Direction.NORTH)))).m_61124_(WEST, (Comparable)((Object)this.getConnection(westState, westState.m_60783_((BlockGetter)level, westPos, Direction.EAST), Direction.EAST)))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_().m_6212_((Fluid)Fluids.f_76193_)));
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos blockPos, BlockPos neighborPos) {
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(blockPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return direction.m_122434_().m_122480_() == Direction.Plane.HORIZONTAL ? (BlockState)blockState.m_61124_((Property)propertyByDirection.get(direction), (Comparable)((Object)this.getConnection(neighborState, neighborState.m_60783_((BlockGetter)level, neighborPos, direction.m_122424_()), direction.m_122424_()))) : (BlockState)blockState.m_61124_(COLUMN, (Comparable)((Object)this.getColumn((BlockGetter)level, blockPos)));
    }

    public Connection getConnection(BlockState blockState, boolean sturdy, Direction direction) {
        if (blockState.m_204336_(RailcraftTags.Blocks.SIGNAL)) {
            return SignalBlock.connectsToDirection(blockState, direction.m_122424_()) ? Connection.DOUBLE : Connection.NONE;
        }
        if (blockState.m_204336_(RailcraftTags.Blocks.POST) || !PostBlock.m_152463_((BlockState)blockState) && sturdy) {
            return Connection.DOUBLE;
        }
        return Connection.NONE;
    }

    public Column getColumn(BlockGetter level, BlockPos blockPos) {
        BlockPos abovePos = blockPos.m_7494_();
        BlockState aboveState = level.m_8055_(abovePos);
        BlockPos belowPos = blockPos.m_7495_();
        BlockState belowState = level.m_8055_(belowPos);
        if (aboveState.m_204336_(BlockTags.f_13034_)) {
            return Column.PLATFORM;
        }
        if (belowState.m_204336_(RailcraftTags.Blocks.POST) || belowState.m_204336_(RailcraftTags.Blocks.SIGNAL) || belowState.m_60783_(level, belowPos, Direction.UP)) {
            return Column.FULL;
        }
        if (!aboveState.m_60795_()) {
            return Column.TOP;
        }
        return Column.SMALL;
    }

    public boolean m_7420_(BlockState blockState, BlockGetter level, BlockPos pos) {
        return (Boolean)blockState.m_61143_((Property)WATERLOGGED) == false;
    }

    public FluidState m_5888_(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(blockState);
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType pathType) {
        return false;
    }

    public BlockState m_6843_(BlockState blockState, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)blockState.m_61124_(NORTH, (Comparable)((Object)((Connection)((Object)blockState.m_61143_(SOUTH)))))).m_61124_(EAST, (Comparable)((Object)((Connection)((Object)blockState.m_61143_(WEST)))))).m_61124_(SOUTH, (Comparable)((Object)((Connection)((Object)blockState.m_61143_(NORTH)))))).m_61124_(WEST, (Comparable)((Object)((Connection)((Object)blockState.m_61143_(EAST)))));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)blockState.m_61124_(NORTH, (Comparable)((Object)((Connection)((Object)blockState.m_61143_(EAST)))))).m_61124_(EAST, (Comparable)((Object)((Connection)((Object)blockState.m_61143_(SOUTH)))))).m_61124_(SOUTH, (Comparable)((Object)((Connection)((Object)blockState.m_61143_(WEST)))))).m_61124_(WEST, (Comparable)((Object)((Connection)((Object)blockState.m_61143_(NORTH)))));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)blockState.m_61124_(NORTH, (Comparable)((Object)((Connection)((Object)blockState.m_61143_(WEST)))))).m_61124_(EAST, (Comparable)((Object)((Connection)((Object)blockState.m_61143_(NORTH)))))).m_61124_(SOUTH, (Comparable)((Object)((Connection)((Object)blockState.m_61143_(EAST)))))).m_61124_(WEST, (Comparable)((Object)((Connection)((Object)blockState.m_61143_(SOUTH)))));
            }
        }
        return blockState;
    }

    public BlockState m_6943_(BlockState blockState, Mirror mirror) {
        switch (mirror) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)blockState.m_61124_(NORTH, (Comparable)((Object)((Connection)((Object)blockState.m_61143_(SOUTH)))))).m_61124_(SOUTH, (Comparable)((Object)((Connection)((Object)blockState.m_61143_(NORTH)))));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)blockState.m_61124_(EAST, (Comparable)((Object)((Connection)((Object)blockState.m_61143_(WEST)))))).m_61124_(WEST, (Comparable)((Object)((Connection)((Object)blockState.m_61143_(EAST)))));
            }
        }
        return super.m_6943_(blockState, mirror);
    }
}

