/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.signal;

import java.util.EnumSet;
import mods.railcraft.api.signal.SignalAspect;
import mods.railcraft.api.signal.SimpleSignalController;
import mods.railcraft.api.signal.entity.SignalControllerEntity;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.signal.AbstractSignalBoxBlockEntity;
import mods.railcraft.world.level.block.signal.SignalBoxBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class SignalControllerBoxBlockEntity
extends AbstractSignalBoxBlockEntity
implements SignalControllerEntity {
    private final SimpleSignalController signalController = new SimpleSignalController(1, this::syncToClient, this, true);
    private SignalAspect defaultAspect = SignalAspect.GREEN;
    private SignalAspect poweredAspect = SignalAspect.RED;

    public SignalControllerBoxBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.SIGNAL_CONTROLLER_BOX.get(), blockPos, blockState);
    }

    public SignalAspect getDefaultAspect() {
        return this.defaultAspect;
    }

    public void setDefaultAspect(SignalAspect defaultAspect) {
        this.defaultAspect = defaultAspect;
        this.updateSignalAspect();
    }

    public SignalAspect getPoweredAspect() {
        return this.poweredAspect;
    }

    public void setPoweredAspect(SignalAspect poweredAspect) {
        this.poweredAspect = poweredAspect;
        this.updateSignalAspect();
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.f_58857_.m_5776_()) {
            this.signalController.refresh();
            this.updateSignalAspect();
        }
    }

    @Override
    public void blockRemoved() {
        super.blockRemoved();
        this.signalController.destroy();
    }

    @Override
    public void neighborSignalBoxChanged(AbstractSignalBoxBlockEntity neighborSignalBox, Direction neighborDirection, boolean removed) {
        this.updateSignalAspect();
    }

    @Override
    public void neighborChanged() {
        this.updateSignalAspect();
    }

    private void updateSignalAspect() {
        EnumSet<Direction> signalDirections = EnumSet.allOf(Direction.class);
        signalDirections.remove(Direction.UP);
        SignalAspect neighborAspect = SignalAspect.GREEN;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(direction));
            if (!(blockEntity instanceof AbstractSignalBoxBlockEntity)) continue;
            AbstractSignalBoxBlockEntity signalBox = (AbstractSignalBoxBlockEntity)blockEntity;
            if (SignalBoxBlock.isAspectEmitter(signalBox.m_58900_())) {
                neighborAspect = SignalAspect.mostRestrictive(neighborAspect, signalBox.getSignalAspect(direction.m_122424_()));
            }
            signalDirections.remove(direction);
        }
        SignalAspect signalAspect = this.defaultAspect;
        for (Direction direction : signalDirections) {
            if (this.f_58857_.m_277185_(this.m_58899_().m_121945_(direction), direction) <= 0) continue;
            signalAspect = this.poweredAspect;
            break;
        }
        this.signalController.setSignalAspect(SignalAspect.mostRestrictive(neighborAspect, signalAspect));
    }

    @Override
    public SignalAspect getSignalAspect(Direction direction) {
        return this.signalController.aspect();
    }

    @Override
    public SimpleSignalController getSignalController() {
        return this.signalController;
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128359_("defaultAspect", this.defaultAspect.m_7912_());
        tag.m_128359_("poweredAspect", this.poweredAspect.m_7912_());
        tag.m_128365_("signalController", (Tag)this.signalController.serializeNBT());
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.defaultAspect = SignalAspect.getByName(tag.m_128461_("defaultAspect")).get();
        this.poweredAspect = SignalAspect.getByName(tag.m_128461_("poweredAspect")).get();
        this.signalController.deserializeNBT(tag.m_128469_("signalController"));
    }

    @Override
    public void writeToBuf(FriendlyByteBuf data) {
        super.writeToBuf(data);
        data.m_130068_((Enum)this.defaultAspect);
        data.m_130068_((Enum)this.poweredAspect);
        this.signalController.writeToBuf(data);
    }

    @Override
    public void readFromBuf(FriendlyByteBuf data) {
        super.readFromBuf(data);
        this.defaultAspect = (SignalAspect)data.m_130066_(SignalAspect.class);
        this.poweredAspect = (SignalAspect)data.m_130066_(SignalAspect.class);
        this.signalController.readFromBuf(data);
    }

    public static void clientTick(Level level, BlockPos blockPos, BlockState blockState, SignalControllerBoxBlockEntity blockEntity) {
        blockEntity.signalController.spawnTuningAuraParticles();
    }
}

