/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.signal;

import java.util.Optional;
import mods.railcraft.Translations;
import mods.railcraft.api.signal.SignalAspect;
import mods.railcraft.api.util.EnumUtil;
import mods.railcraft.client.gui.widget.button.ButtonTexture;
import mods.railcraft.client.gui.widget.button.TexturePosition;
import mods.railcraft.gui.button.ButtonState;
import mods.railcraft.util.RedstoneUtil;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.signal.AbstractSignalBoxBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class SignalCapacitorBoxBlockEntity
extends AbstractSignalBoxBlockEntity {
    private short ticksPowered;
    private short ticksToPower = (short)200;
    private SignalAspect signalAspect = SignalAspect.OFF;
    private Mode mode = Mode.RISING_EDGE;

    public SignalCapacitorBoxBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.SIGNAL_CAPACITOR_BOX.get(), blockPos, blockState);
    }

    public short getTicksToPower() {
        return this.ticksToPower;
    }

    public void setTicksToPower(short ticksToPower) {
        this.ticksToPower = ticksToPower;
        this.m_6596_();
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
        this.m_6596_();
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, SignalCapacitorBoxBlockEntity blockEntity) {
        short s = blockEntity.ticksPowered;
        blockEntity.ticksPowered = (short)(s - 1);
        if (s > 0) {
            if (blockEntity.mode == Mode.FALLING_EDGE) {
                SignalAspect signalAspect = SignalAspect.GREEN;
                boolean powered = RedstoneUtil.hasRepeaterSignal(level, blockPos);
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    AbstractSignalBoxBlockEntity box;
                    BlockEntity neighbor = level.m_7702_(blockPos.m_121945_(direction));
                    if (!(neighbor instanceof AbstractSignalBoxBlockEntity) || (box = (AbstractSignalBoxBlockEntity)neighbor).getRedstoneSignal(direction.m_122424_()) <= 0) continue;
                    powered = true;
                    signalAspect = SignalAspect.mostRestrictive(signalAspect, box.getSignalAspect(direction.m_122424_()));
                }
                if (powered) {
                    blockEntity.ticksPowered = blockEntity.ticksToPower;
                    if (blockEntity.signalAspect != signalAspect) {
                        blockEntity.signalAspect = signalAspect;
                        blockEntity.m_6596_();
                    }
                }
            }
            if (blockEntity.ticksPowered <= 0) {
                blockEntity.m_6596_();
            }
        }
    }

    @Override
    public void m_6596_() {
        super.m_6596_();
        this.syncToClient();
    }

    @Override
    public void neighborChanged() {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        boolean powered = RedstoneUtil.hasRepeaterSignal(this.f_58857_, this.m_58899_());
        if (this.ticksPowered <= 0 && powered) {
            this.ticksPowered = this.ticksToPower;
            if (this.mode == Mode.RISING_EDGE) {
                this.signalAspect = SignalAspect.GREEN;
            }
            this.m_6596_();
        }
    }

    @Override
    public void neighborSignalBoxChanged(AbstractSignalBoxBlockEntity neighbor, Direction direction, boolean removed) {
        if (neighbor.getRedstoneSignal(direction) > 0) {
            this.ticksPowered = this.ticksToPower;
            if (this.mode == Mode.RISING_EDGE) {
                this.signalAspect = neighbor.getSignalAspect(direction);
            }
            this.m_6596_();
        }
    }

    @Override
    public int getRedstoneSignal(Direction direction) {
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(direction.m_122424_()));
        return blockEntity instanceof AbstractSignalBoxBlockEntity || this.ticksPowered <= 0 ? 0 : 15;
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128376_("ticksPowered", this.ticksPowered);
        tag.m_128376_("ticksToPower", this.ticksToPower);
        tag.m_128359_("signalAspect", this.signalAspect.m_7912_());
        tag.m_128405_("mode", this.mode.ordinal());
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.ticksPowered = tag.m_128448_("ticksPowered");
        this.ticksToPower = tag.m_128448_("ticksToPower");
        this.signalAspect = SignalAspect.getByName(tag.m_128461_("signalAspect")).orElse(SignalAspect.OFF);
        this.mode = Mode.values()[tag.m_128451_("mode")];
    }

    @Override
    public void writeToBuf(FriendlyByteBuf data) {
        super.writeToBuf(data);
        data.writeBoolean(this.ticksPowered > 0);
        data.writeShort((int)this.ticksToPower);
        data.m_130068_((Enum)this.signalAspect);
        data.m_130068_((Enum)this.mode);
    }

    @Override
    public void readFromBuf(FriendlyByteBuf data) {
        super.readFromBuf(data);
        this.ticksPowered = (short)(data.readBoolean() ? 1 : 0);
        this.ticksToPower = data.readShort();
        this.signalAspect = (SignalAspect)data.m_130066_(SignalAspect.class);
        this.mode = (Mode)data.m_130066_(Mode.class);
    }

    @Override
    public SignalAspect getSignalAspect(Direction direction) {
        return this.ticksPowered > 0 ? this.signalAspect : SignalAspect.RED;
    }

    public static enum Mode implements ButtonState<Mode>
    {
        RISING_EDGE("rising_edge"),
        FALLING_EDGE("falling_edge");

        private final String name;

        private Mode(String name) {
            this.name = name;
        }

        @Override
        public Component label() {
            return Component.m_237115_((String)this.getTranslationKey());
        }

        @Override
        public Optional<Component> tooltip() {
            return Optional.of(Component.m_237115_((String)this.getDescriptionKey()));
        }

        public String getTranslationKey() {
            return Translations.makeKey("signal", "capacitor." + this.name);
        }

        public String getDescriptionKey() {
            return this.getTranslationKey() + ".desc";
        }

        @Override
        public TexturePosition texturePosition() {
            return ButtonTexture.SMALL_BUTTON;
        }

        @Override
        public Mode next() {
            return (Mode)EnumUtil.next((Enum)this, (Enum[])Mode.values());
        }
    }
}

