/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.manipulator;

import java.util.stream.Stream;
import mods.railcraft.RailcraftConfig;
import mods.railcraft.util.Predicates;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.manipulator.FluidManipulatorBlockEntity;
import mods.railcraft.world.level.block.entity.manipulator.ManipulatorBlockEntity;
import mods.railcraft.world.level.material.FluidTools;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidUnloaderBlockEntity
extends FluidManipulatorBlockEntity {
    private static final int TRANSFER_RATE = 80;
    private static final Direction[] PUSH_TO = (Direction[])Stream.of(Direction.values()).filter(direction -> direction != Direction.UP).toArray(Direction[]::new);

    public FluidUnloaderBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.FLUID_UNLOADER.get(), blockPos, blockState);
    }

    @Override
    protected void upkeep() {
        super.upkeep();
        this.tankManager.push(FluidTools.findNeighbors(this.f_58857_, this.m_58899_(), Predicates.notOfType(FluidUnloaderBlockEntity.class), PUSH_TO), 0, 80);
    }

    @Override
    protected FluidTools.ProcessType getProcessType() {
        return FluidTools.ProcessType.FILL_ONLY;
    }

    @Override
    protected void processCart(AbstractMinecart cart) {
        IFluidHandler tankCart = FluidUnloaderBlockEntity.getFluidHandler(cart, Direction.DOWN);
        if (tankCart != null) {
            FluidStack moved = FluidUtil.tryFluidTransfer((IFluidHandler)this.tank, (IFluidHandler)tankCart, (int)((Integer)RailcraftConfig.SERVER.tankCartFluidTransferRate.get()), (boolean)true);
            this.setProcessing(!moved.isEmpty());
        }
    }

    @Override
    protected boolean hasWorkForCart(AbstractMinecart cart) {
        IFluidHandler cartFluidHandler = FluidUnloaderBlockEntity.getFluidHandler(cart, Direction.DOWN);
        if (cartFluidHandler == null) {
            return false;
        }
        if (this.getRedstoneMode() == ManipulatorBlockEntity.RedstoneMode.IMMEDIATE) {
            return false;
        }
        if (this.getFilterFluid().map(fluid -> cartFluidHandler.drain(fluid, IFluidHandler.FluidAction.SIMULATE).isEmpty()).orElse(false).booleanValue()) {
            return false;
        }
        return !cartFluidHandler.drain(1, IFluidHandler.FluidAction.SIMULATE).isEmpty();
    }
}

