/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity;

import java.util.EnumSet;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.api.signal.SignalAspect;
import mods.railcraft.api.signal.SignalReceiver;
import mods.railcraft.api.signal.SingleSignalReceiver;
import mods.railcraft.api.signal.entity.SignalReceiverEntity;
import mods.railcraft.api.track.SwitchActuator;
import mods.railcraft.world.level.block.entity.LockableSwitchTrackActuatorBlockEntity;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.track.actuator.SwitchTrackActuatorBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class SwitchTrackMotorBlockEntity
extends LockableSwitchTrackActuatorBlockEntity
implements SignalReceiverEntity,
SwitchActuator {
    private final SingleSignalReceiver signalReceiver = new SingleSignalReceiver(this, this::syncToClient, __ -> this.updateSwitched());
    private final EnumSet<SignalAspect> actionSignalAspects = EnumSet.of(SignalAspect.GREEN);
    private boolean redstoneTriggered;
    private boolean powered;

    public SwitchTrackMotorBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.SWITCH_TRACK_MOTOR.get(), blockPos, blockState);
    }

    public void neighborChanged() {
        boolean lastPowered = this.powered;
        this.powered = this.f_58857_.m_276867_(this.m_58899_());
        if (this.redstoneTriggered && lastPowered != this.powered) {
            this.updateSwitched();
        }
    }

    private void updateSwitched() {
        boolean switched = this.powered || this.actionSignalAspects.contains((Object)this.signalReceiver.getPrimarySignalAspect());
        SwitchTrackActuatorBlock.setSwitched(this.m_58900_(), this.f_58857_, this.m_58899_(), switched);
    }

    @Override
    public boolean shouldSwitch(RollingStock cart) {
        return SwitchTrackActuatorBlock.isSwitched(this.m_58900_());
    }

    public EnumSet<SignalAspect> getActionSignalAspects() {
        return this.actionSignalAspects;
    }

    public boolean isRedstoneTriggered() {
        return this.redstoneTriggered;
    }

    public void setRedstoneTriggered(boolean redstoneTriggered) {
        this.redstoneTriggered = redstoneTriggered;
        this.updateSwitched();
    }

    @Override
    public void setCustomName(@Nullable Component name) {
        super.setCustomName(name);
    }

    @Override
    public SignalReceiver getSignalReceiver() {
        return this.signalReceiver;
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("signalReceiver", (Tag)this.signalReceiver.serializeNBT());
        ListTag actionAspectsTag = new ListTag();
        this.actionSignalAspects.forEach(aspect -> actionAspectsTag.add((Object)StringTag.m_129297_((String)aspect.m_7912_())));
        tag.m_128365_("actionSignalAspects", (Tag)actionAspectsTag);
        tag.m_128379_("redstoneTriggered", this.redstoneTriggered);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.signalReceiver.deserializeNBT(tag.m_128469_("signalReceiver"));
        ListTag actionAspectsTag = tag.m_128437_("actionSignalAspects", 8);
        this.actionSignalAspects.clear();
        for (Tag aspectTag : actionAspectsTag) {
            SignalAspect.getByName(aspectTag.m_7916_()).ifPresent(this.actionSignalAspects::add);
        }
        this.redstoneTriggered = tag.m_128471_("redstoneTriggered");
    }

    @Override
    public void writeToBuf(FriendlyByteBuf data) {
        super.writeToBuf(data);
        this.signalReceiver.writeToBuf(data);
        data.m_245616_(this.actionSignalAspects, SignalAspect.class);
        data.writeBoolean(this.redstoneTriggered);
    }

    @Override
    public void readFromBuf(FriendlyByteBuf data) {
        super.readFromBuf(data);
        this.signalReceiver.readFromBuf(data);
        this.actionSignalAspects.clear();
        this.actionSignalAspects.addAll(data.m_247336_(SignalAspect.class));
        this.redstoneTriggered = data.readBoolean();
    }
}

