/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity;

import mods.railcraft.api.charge.Charge;
import mods.railcraft.api.charge.ChargeStorage;
import mods.railcraft.util.ForwardingEnergyStorage;
import mods.railcraft.util.container.FilteredInvWrapper;
import mods.railcraft.world.inventory.PoweredRollingMachineMenu;
import mods.railcraft.world.level.block.entity.ManualRollingMachineBlockEntity;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PoweredRollingMachineBlockEntity
extends ManualRollingMachineBlockEntity {
    private static final int CHARGE_PER_TICK = 10;
    private final LazyOptional<IItemHandler> inputHandler = LazyOptional.of(() -> new FilteredInvWrapper((Container)this.craftMatrix, true, false));
    private final LazyOptional<IItemHandler> outputHandler = LazyOptional.of(() -> new FilteredInvWrapper(this.invResult, false, true));
    private final LazyOptional<IEnergyStorage> energyHandler = LazyOptional.of(() -> new ForwardingEnergyStorage(this::storage));

    public PoweredRollingMachineBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.POWERED_ROLLING_MACHINE.get(), blockPos, blockState);
    }

    @Override
    protected void progress() {
        if (this.access().useCharge(10, false)) {
            super.progress();
        }
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
        return new PoweredRollingMachineMenu(containerId, inventory, this);
    }

    private ChargeStorage storage() {
        return this.access().storage().get();
    }

    private Charge.Access access() {
        return Charge.distribution.network((ServerLevel)this.f_58857_).access(this.blockPos());
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyHandler.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return side.equals((Object)Direction.UP) ? this.inputHandler.cast() : this.outputHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.energyHandler.invalidate();
        this.inputHandler.invalidate();
        this.outputHandler.invalidate();
    }
}

