/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity;

import java.util.Optional;
import mods.railcraft.util.container.AdvancedContainer;
import mods.railcraft.util.container.ContainerMapper;
import mods.railcraft.util.container.ContainerTools;
import mods.railcraft.world.inventory.ManualRollingMachineMenu;
import mods.railcraft.world.item.crafting.RailcraftRecipeTypes;
import mods.railcraft.world.item.crafting.RollingRecipe;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntity;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ManualRollingMachineBlockEntity
extends RailcraftBlockEntity
implements MenuProvider {
    private static final int SLOT_RESULT = 0;
    private final AdvancedContainer container;
    private final FakeRollingContainer matrixListener = new FakeRollingContainer();
    protected final RollingCraftingContainer craftMatrix = new RollingCraftingContainer(this.matrixListener, 3, 3);
    protected final ContainerMapper invResult;
    protected final ContainerMapper invMatrix;
    protected boolean isWorking;
    protected boolean useLast;
    private Optional<RollingRecipe> currentRecipe = Optional.empty();
    private int progress;
    private int clock = 0;
    private int processTime = 100;

    public ManualRollingMachineBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
        this.container = new AdvancedContainer(10);
        this.invResult = ContainerMapper.make((Container)this.container, 0, 1);
        this.invMatrix = ContainerMapper.make((Container)this.container, 1, 9);
    }

    public ManualRollingMachineBlockEntity(BlockPos blockPos, BlockState blockState) {
        this((BlockEntityType)RailcraftBlockEntityTypes.MANUAL_ROLLING_MACHINE.get(), blockPos, blockState);
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("container", (Tag)this.container.m_7927_());
        tag.m_128365_("craftMatrix", (Tag)ContainerTools.writeContainer((Container)this.craftMatrix));
        tag.m_128405_("progress", this.progress);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.container.m_7797_(tag.m_128437_("container", 10));
        ContainerTools.readContainer((Container)this.craftMatrix, tag.m_128437_("craftMatrix", 10));
        this.progress = tag.m_128451_("progress");
    }

    public void m_6596_() {
        super.m_6596_();
        this.craftMatrix.m_6596_();
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public void setProcessTime(int processTime) {
        this.processTime = Math.max(processTime, 1);
    }

    public int getProcessTime() {
        return this.processTime;
    }

    public RollingCraftingContainer getCraftMatrix(AbstractContainerMenu listener) {
        this.matrixListener.listener = listener;
        return this.craftMatrix;
    }

    public ContainerMapper getInvResult() {
        return this.invResult;
    }

    public ContainerMapper getInvMatrix() {
        return this.invMatrix;
    }

    public Optional<RollingRecipe> getRecipe() {
        return this.f_58857_.m_7465_().m_44015_((RecipeType)RailcraftRecipeTypes.ROLLING.get(), (Container)this.craftMatrix, this.f_58857_);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, ManualRollingMachineBlockEntity blockEntity) {
        blockEntity.balanceSlots();
        if (++blockEntity.clock % 8 == 0) {
            blockEntity.currentRecipe = blockEntity.getRecipe();
            blockEntity.processTime = blockEntity.currentRecipe.map(RollingRecipe::getProcessTime).orElse(100);
            blockEntity.clock = 0;
        }
        if (blockEntity.currentRecipe.isPresent() && blockEntity.canMakeMore()) {
            RollingRecipe recipe = blockEntity.currentRecipe.get();
            if (blockEntity.progress >= recipe.getProcessTime()) {
                blockEntity.isWorking = false;
                ItemStack result = recipe.assemble((CraftingContainer)blockEntity.craftMatrix, level.m_9598_());
                if (blockEntity.invResult.canFit(result)) {
                    blockEntity.craftMatrix.m_280657_().forEach(x -> x.m_41774_(1));
                    blockEntity.invResult.insert(result);
                    blockEntity.useLast = false;
                    blockEntity.progress = 0;
                    blockEntity.currentRecipe = Optional.empty();
                }
            } else {
                blockEntity.isWorking = true;
                blockEntity.progress();
            }
        } else {
            blockEntity.progress = 0;
            blockEntity.isWorking = false;
        }
    }

    protected void progress() {
        ++this.progress;
    }

    private void balanceSlots() {
        int size = this.craftMatrix.m_6643_();
        for (int i = 0; i < size; ++i) {
            ItemStack stackA = this.craftMatrix.m_8020_(i);
            if (stackA.m_41619_()) continue;
            for (int j = 0; j < size; ++j) {
                ItemStack stackB;
                if (i == j || (stackB = this.craftMatrix.m_8020_(j)).m_41619_() || !ItemStack.m_41656_((ItemStack)stackA, (ItemStack)stackB) || stackA.m_41613_() <= stackB.m_41613_() + 1) continue;
                stackA.m_41774_(1);
                stackB.m_41769_(1);
                this.craftMatrix.m_6836_(i, stackA);
                this.craftMatrix.m_6836_(j, stackB);
                return;
            }
        }
    }

    public void setUseLast() {
        this.useLast = true;
    }

    public boolean canMakeMore() {
        if (this.getRecipe().isEmpty()) {
            return false;
        }
        if (this.useLast) {
            return true;
        }
        return this.craftMatrix.m_280657_().stream().filter(x -> !x.m_41619_()).allMatch(x -> x.m_41613_() > 1);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
        return new ManualRollingMachineMenu(containerId, inventory, this);
    }

    private static class FakeRollingContainer
    extends AbstractContainerMenu {
        @Nullable
        AbstractContainerMenu listener = null;

        public FakeRollingContainer() {
            super(null, 0);
        }

        public ItemStack m_7648_(Player player, int index) {
            return ItemStack.f_41583_;
        }

        public boolean m_6875_(Player player) {
            return true;
        }

        public void m_6199_(Container container) {
            if (this.listener != null) {
                this.listener.m_6199_(container);
            }
        }
    }

    public static class RollingCraftingContainer
    extends TransientCraftingContainer {
        public RollingCraftingContainer(FakeRollingContainer menu, int width, int height) {
            super((AbstractContainerMenu)menu, width, height);
        }

        public boolean m_7013_(int index, ItemStack stack) {
            if (stack.m_41619_()) {
                return false;
            }
            if (!stack.m_41753_()) {
                return false;
            }
            return !this.m_8020_(index).m_41619_();
        }
    }
}

