/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity;

import mods.railcraft.api.charge.Charge;
import mods.railcraft.api.charge.ChargeStorage;
import mods.railcraft.particle.ForceSpawnParticleOptions;
import mods.railcraft.util.ForwardingEnergyStorage;
import mods.railcraft.util.FunctionalUtil;
import mods.railcraft.util.LevelUtil;
import mods.railcraft.world.item.Magnifiable;
import mods.railcraft.world.level.block.ForceTrackEmitterBlock;
import mods.railcraft.world.level.block.RailcraftBlocks;
import mods.railcraft.world.level.block.entity.ForceTrackEmitterState;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntity;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.track.ForceTrackBlockEntity;
import mods.railcraft.world.level.block.track.ForceTrackBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class ForceTrackEmitterBlockEntity
extends RailcraftBlockEntity
implements Magnifiable {
    private static final int BASE_DRAW = 22;
    private static final int CHARGE_PER_TRACK = 2;
    private int trackCount;
    private ForceTrackEmitterState.Instance stateInstance;
    private boolean removingTrack;
    private final LazyOptional<IEnergyStorage> energyHandler;

    public ForceTrackEmitterBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.FORCE_TRACK_EMITTER.get(), blockPos, blockState);
        this.loadState(ForceTrackEmitterState.RETRACTED);
        this.energyHandler = LazyOptional.of(() -> new ForwardingEnergyStorage(this::storage));
    }

    public ForceTrackEmitterState.Instance getStateInstance() {
        return this.stateInstance;
    }

    public int getTrackCount() {
        return this.trackCount;
    }

    public void checkSignal() {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        boolean powered = this.f_58857_.m_276867_(this.m_58899_());
        if (this.isPowered() != powered) {
            this.setPowered(powered);
        }
    }

    private void loadState(ForceTrackEmitterState state) {
        this.stateInstance = state.load(this);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, ForceTrackEmitterBlockEntity blockEntity) {
        if (!blockEntity.isPowered()) {
            blockEntity.stateInstance.uncharged().ifPresent(blockEntity::loadState);
        } else {
            int draw = ForceTrackEmitterBlockEntity.getRequiredEnergy(blockEntity.getTrackCount());
            Charge.Access access = blockEntity.access();
            if (access.useCharge(draw, false)) {
                blockEntity.stateInstance.charged(access).ifPresent(blockEntity::loadState);
            } else {
                blockEntity.stateInstance.uncharged().ifPresent(blockEntity::loadState);
            }
        }
    }

    private void spawnParticles(BlockPos pos) {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        int color = ((DyeColor)this.m_58900_().m_61143_(ForceTrackEmitterBlock.COLOR)).m_41070_();
        ServerLevel serverLevel = (ServerLevel)this.f_58857_;
        serverLevel.m_8767_((ParticleOptions)new ForceSpawnParticleOptions(color), (double)x + 0.1, (double)y, (double)z + 0.1, 1, 0.0, 0.0, 0.0, 0.0);
        serverLevel.m_8767_((ParticleOptions)new ForceSpawnParticleOptions(color), (double)x + 0.9, (double)y, (double)z + 0.1, 1, 0.0, 0.0, 0.0, 0.0);
        serverLevel.m_8767_((ParticleOptions)new ForceSpawnParticleOptions(color), (double)x + 0.1, (double)y, (double)z + 0.9, 1, 0.0, 0.0, 0.0, 0.0);
        serverLevel.m_8767_((ParticleOptions)new ForceSpawnParticleOptions(color), (double)x + 0.9, (double)y, (double)z + 0.9, 1, 0.0, 0.0, 0.0, 0.0);
        serverLevel.m_5594_(null, pos, SoundEvents.f_11852_, SoundSource.BLOCKS, 0.25f, 1.0f);
    }

    boolean placeTrack(BlockPos blockPos, BlockState existingBlockState, RailShape railShape) {
        BlockEntity blockEntity;
        if (!existingBlockState.m_60795_()) {
            return false;
        }
        this.spawnParticles(blockPos);
        BlockState trackBlockState = (BlockState)((ForceTrackBlock)RailcraftBlocks.FORCE_TRACK.get()).m_49966_().m_61124_(ForceTrackBlock.SHAPE, (Comparable)railShape);
        if (this.f_58857_.m_46597_(blockPos, trackBlockState) && (blockEntity = this.f_58857_.m_7702_(blockPos)) instanceof ForceTrackBlockEntity) {
            ForceTrackBlockEntity track = (ForceTrackBlockEntity)blockEntity;
            track.setEmitter(this);
            ++this.trackCount;
            return true;
        }
        return false;
    }

    public static int getRequiredEnergy(int tracks) {
        return 22 + 2 * tracks;
    }

    void removeFirstTrack() {
        BlockPos toRemove = this.f_58858_.m_7494_().m_5484_(ForceTrackEmitterBlock.getFacing(this.m_58900_()), this.trackCount);
        this.removeTrack(toRemove);
    }

    public void clearTracks() {
        this.clearTracks(this.m_58899_().m_7494_().m_121945_(ForceTrackEmitterBlock.getFacing(this.m_58900_())));
    }

    public void clearTracks(BlockPos startPos) {
        if (this.removingTrack || this.trackCount <= 0) {
            return;
        }
        BlockPos endPos = this.m_58899_().m_7494_().m_5484_(ForceTrackEmitterBlock.getFacing(this.m_58900_()), this.trackCount);
        if (startPos.m_123341_() == endPos.m_123341_()) {
            FunctionalUtil.rangeClosed(startPos.m_123343_(), endPos.m_123343_()).mapToObj(z -> new BlockPos(endPos.m_123341_(), endPos.m_123342_(), z)).forEach(this::removeTrack);
        } else if (startPos.m_123343_() == endPos.m_123343_()) {
            FunctionalUtil.rangeClosed(startPos.m_123341_(), endPos.m_123341_()).mapToObj(x -> new BlockPos(x, endPos.m_123342_(), endPos.m_123343_())).forEach(this::removeTrack);
        } else {
            throw new IllegalStateException("Block not aligned.");
        }
        this.notifyTrackChange();
    }

    private void removeTrack(BlockPos blockPos) {
        if (this.trackCount <= 0) {
            throw new IllegalStateException("trackCount must be greater than 0");
        }
        this.removingTrack = true;
        if (this.f_58857_.m_46749_(blockPos) && this.f_58857_.m_8055_(blockPos).m_60713_((Block)RailcraftBlocks.FORCE_TRACK.get())) {
            LevelUtil.setAir(this.f_58857_, blockPos);
            this.spawnParticles(blockPos);
        }
        --this.trackCount;
        this.removingTrack = false;
    }

    public void notifyTrackChange() {
        this.loadState(ForceTrackEmitterState.HALTED);
    }

    private boolean isPowered() {
        return (Boolean)this.m_58900_().m_61143_((Property)ForceTrackEmitterBlock.POWERED);
    }

    private void setPowered(boolean powered) {
        BlockState state = this.m_58900_();
        if (state.m_60713_((Block)RailcraftBlocks.FORCE_TRACK_EMITTER.get())) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)ForceTrackEmitterBlock.POWERED, (Comparable)Boolean.valueOf(powered)));
        }
    }

    public boolean setColor(DyeColor color) {
        if (this.m_58900_().m_61143_(ForceTrackEmitterBlock.COLOR) != color) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_(ForceTrackEmitterBlock.COLOR, (Comparable)color));
            if (!this.f_58857_.m_5776_()) {
                this.clearTracks();
            }
            return true;
        }
        return false;
    }

    @Override
    public void onMagnify(Player player) {
        player.m_5661_((Component)Component.m_237110_((String)"gui.railcraft.force.track.emitter.info", (Object[])new Object[]{this.getTrackCount()}), true);
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("trackCount", this.getTrackCount());
        tag.m_128359_("state", this.stateInstance.state().m_7912_());
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.trackCount = tag.m_128451_("trackCount");
        ForceTrackEmitterState.getByName(tag.m_128461_("state")).ifPresent(this::loadState);
    }

    private ChargeStorage storage() {
        return this.access().storage().get();
    }

    private Charge.Access access() {
        return Charge.distribution.network((ServerLevel)this.f_58857_).access(this.blockPos());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return cap == ForgeCapabilities.ENERGY ? this.energyHandler.cast() : super.getCapability(cap, side);
    }
}

