/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block;

import java.util.List;
import java.util.Map;
import mods.railcraft.Translations;
import mods.railcraft.api.charge.Charge;
import mods.railcraft.api.charge.ChargeBlock;
import mods.railcraft.api.charge.ChargeStorage;
import mods.railcraft.integrations.jei.JeiSearchable;
import mods.railcraft.world.level.block.entity.ManualRollingMachineBlockEntity;
import mods.railcraft.world.level.block.entity.PoweredRollingMachineBlockEntity;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class PoweredRollingMachineBlock
extends BaseEntityBlock
implements ChargeBlock,
JeiSearchable {
    private static final Map<Charge, ChargeBlock.Spec> CHARGE_SPECS = ChargeBlock.Spec.make(Charge.distribution, ChargeBlock.ConnectType.BLOCK, 0.0f, new ChargeStorage.Spec(ChargeStorage.State.RECHARGEABLE, 8000, 1000, 1.0f));

    public PoweredRollingMachineBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new PoweredRollingMachineBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> type) {
        return level.m_5776_() ? null : PoweredRollingMachineBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)RailcraftBlockEntityTypes.POWERED_ROLLING_MACHINE.get()), ManualRollingMachineBlockEntity::serverTick);
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        level.m_141902_(pos, (BlockEntityType)RailcraftBlockEntityTypes.POWERED_ROLLING_MACHINE.get()).ifPresent(blockEntity -> NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)blockEntity, (BlockPos)pos));
        return InteractionResult.CONSUME;
    }

    @Override
    public Map<Charge, ChargeBlock.Spec> getChargeSpecs(BlockState state, ServerLevel level, BlockPos pos) {
        return CHARGE_SPECS;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        this.registerNode(state, level, pos);
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!state.m_60713_(oldState.m_60734_())) {
            this.registerNode(state, (ServerLevel)level, pos);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moved) {
        BlockEntity blockEntity;
        if (!state.m_60713_(newState.m_60734_()) && (blockEntity = level.m_7702_(pos)) instanceof PoweredRollingMachineBlockEntity) {
            PoweredRollingMachineBlockEntity rollingMachine = (PoweredRollingMachineBlockEntity)blockEntity;
            Containers.m_19002_((Level)level, (BlockPos)pos, (Container)rollingMachine.getInvResult());
            Containers.m_19002_((Level)level, (BlockPos)pos, (Container)rollingMachine.getInvMatrix());
            level.m_46717_(pos, (Block)this);
        }
        super.m_6810_(state, level, pos, newState, moved);
        if (!state.m_60713_(newState.m_60734_())) {
            this.deregisterNode((ServerLevel)level, pos);
        }
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        super.m_5871_(stack, level, tooltip, flag);
        tooltip.add((Component)Component.m_237115_((String)Translations.Tips.ROLLING_MACHINE).m_130940_(ChatFormatting.GRAY));
    }

    @Override
    public Component addJeiInfo() {
        return Component.m_237115_((String)Translations.Jei.POWERED_ROLLING_MACHINE);
    }
}

