/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.Map;
import mods.railcraft.world.item.crafting.RailcraftRecipeSerializers;
import mods.railcraft.world.item.crafting.RailcraftRecipeTypes;
import mods.railcraft.world.level.block.RailcraftBlocks;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class RollingRecipe
implements Recipe<CraftingContainer> {
    private final ResourceLocation recipeId;
    private final int width;
    private final int height;
    private final NonNullList<Ingredient> ingredients;
    private final ItemStack result;
    private final int processTime;

    public RollingRecipe(ResourceLocation recipeId, int width, int height, NonNullList<Ingredient> ingredients, ItemStack result, int processTime) {
        this.recipeId = recipeId;
        this.width = width;
        this.height = height;
        this.ingredients = ingredients;
        this.result = result;
        this.processTime = processTime;
    }

    public int getProcessTime() {
        return this.processTime;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean matches(CraftingContainer inventory, Level level) {
        for (int i = 0; i <= inventory.m_39347_() - this.width; ++i) {
            for (int j = 0; j <= inventory.m_39346_() - this.height; ++j) {
                if (this.matches(inventory, i, j, true)) {
                    return true;
                }
                if (!this.matches(inventory, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matches(CraftingContainer inventory, int x, int y, boolean inverse) {
        for (int i = 0; i < inventory.m_39347_(); ++i) {
            for (int j = 0; j < inventory.m_39346_(); ++j) {
                int k = i - x;
                int l = j - y;
                Ingredient ingredient = Ingredient.f_43901_;
                if (k >= 0 && l >= 0 && k < this.width && l < this.height) {
                    ingredient = inverse ? (Ingredient)this.ingredients.get(this.width - k - 1 + l * this.width) : (Ingredient)this.ingredients.get(k + l * this.width);
                }
                if (ingredient.test(inventory.m_8020_(i + j * inventory.m_39347_()))) continue;
                return false;
            }
        }
        return true;
    }

    public ItemStack assemble(CraftingContainer inventory, RegistryAccess registryAccess) {
        return this.m_8043_(registryAccess).m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return width >= this.width && height >= this.height;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public ResourceLocation m_6423_() {
        return this.recipeId;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RailcraftRecipeSerializers.ROLLING.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)RailcraftRecipeTypes.ROLLING.get();
    }

    public boolean m_5598_() {
        return true;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)RailcraftBlocks.MANUAL_ROLLING_MACHINE.get());
    }

    public static class Serializer
    implements RecipeSerializer<RollingRecipe> {
        public RollingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Map map = ShapedRecipe.m_44210_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"key"));
            String[] patterns = ShapedRecipe.m_44186_((String[])ShapedRecipe.m_44196_((JsonArray)GsonHelper.m_13933_((JsonObject)json, (String)"pattern")));
            int width = patterns[0].length();
            int height = patterns.length;
            int tickCost = GsonHelper.m_13824_((JsonObject)json, (String)"processTime", (int)100);
            NonNullList ingredients = ShapedRecipe.m_44202_((String[])patterns, (Map)map, (int)width, (int)height);
            ItemStack resultItemStack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return new RollingRecipe(recipeId, width, height, (NonNullList<Ingredient>)ingredients, resultItemStack, tickCost);
        }

        public RollingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int width = buffer.m_130242_();
            int height = buffer.m_130242_();
            int tickCost = buffer.m_130242_();
            NonNullList ingredients = (NonNullList)buffer.m_236838_(NonNullList::m_182647_, Ingredient::m_43940_);
            ItemStack result = buffer.m_130267_();
            return new RollingRecipe(recipeId, width, height, (NonNullList<Ingredient>)ingredients, result, tickCost);
        }

        public void toNetwork(FriendlyByteBuf buffer, RollingRecipe recipe) {
            buffer.m_130130_(recipe.width);
            buffer.m_130130_(recipe.height);
            buffer.m_130130_(recipe.processTime);
            buffer.m_236828_(recipe.ingredients, (buf, ingredient) -> ingredient.m_43923_(buffer));
            buffer.m_130055_(recipe.result);
        }
    }
}

