/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import mods.railcraft.world.item.crafting.RailcraftRecipeSerializers;
import mods.railcraft.world.item.crafting.RailcraftRecipeTypes;
import mods.railcraft.world.level.block.RailcraftBlocks;
import mods.railcraft.world.level.material.RailcraftFluids;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fluids.FluidStack;

public class CokeOvenRecipe
extends AbstractCookingRecipe {
    private final FluidStack creosote;

    public CokeOvenRecipe(ResourceLocation id, String group, Ingredient ingredient, ItemStack result, float experience, int cookingTime, int creosoteOutput) {
        super((RecipeType)RailcraftRecipeTypes.COKING.get(), id, group, CookingBookCategory.MISC, ingredient, result, experience, cookingTime);
        this.creosote = new FluidStack((Fluid)RailcraftFluids.CREOSOTE.get(), creosoteOutput);
    }

    public FluidStack getCreosote() {
        return this.creosote;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RailcraftRecipeSerializers.COKING.get();
    }

    public boolean m_5598_() {
        return true;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)RailcraftBlocks.COKE_OVEN_BRICKS.get());
    }

    public static class Serializer
    implements RecipeSerializer<CokeOvenRecipe> {
        public CokeOvenRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            int cookingTime = GsonHelper.m_13824_((JsonObject)json, (String)"cookingTime", (int)1800);
            int creosoteOutput = GsonHelper.m_13824_((JsonObject)json, (String)"creosoteOutput", (int)1000);
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)json.get("ingredient"));
            ItemStack result = Serializer.itemFromJson(GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            float experience = GsonHelper.m_13820_((JsonObject)json, (String)"experience", (float)0.0f);
            return new CokeOvenRecipe(recipeId, group, ingredient, result, experience, cookingTime, creosoteOutput);
        }

        public CokeOvenRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String group = buffer.m_130277_();
            int creosoteOutput = buffer.m_130242_();
            int cookingTime = buffer.m_130242_();
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack result = buffer.m_130267_();
            float experience = buffer.readFloat();
            return new CokeOvenRecipe(recipeId, group, ingredient, result, experience, cookingTime, creosoteOutput);
        }

        public void toNetwork(FriendlyByteBuf buffer, CokeOvenRecipe recipe) {
            buffer.m_130070_(recipe.f_43728_);
            buffer.m_130130_(recipe.creosote.getAmount());
            buffer.m_130130_(recipe.f_43732_);
            recipe.f_43729_.m_43923_(buffer);
            buffer.m_130055_(recipe.f_43730_);
            buffer.writeFloat(recipe.f_43731_);
        }

        public static ItemStack itemFromJson(JsonObject json) {
            if (!json.has("item")) {
                throw new JsonParseException("No item key found");
            }
            return CraftingHelper.getItemStack((JsonObject)json, (boolean)true);
        }
    }
}

